/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation;

import com.lightcrafts.model.LayerMode;
import com.lightcrafts.model.Operation;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.layout.Box;
import com.lightcrafts.ui.operation.ColorSelectionControls;
import com.lightcrafts.ui.operation.InvertRegionCheckBox;
import com.lightcrafts.ui.operation.LayerControls;
import com.lightcrafts.ui.operation.Locale;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

class OpFooter
extends Box
implements PropertyChangeListener {
    private LayerControls layerControls;
    private InvertRegionCheckBox invertRegionSwitch;
    private ColorSelectionControls colorControls;
    private JTabbedPane tabPane;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    ColorScheme orangeScheme = new LightZoneSkin.CustomColorScheme(LightZoneSkin.Colors.LZOrange);
    private static final String TabIndexTag = "layerControlsIndex";

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.tabPane != null && evt.getPropertyName().equals("Color Selection")) {
            if (evt.getNewValue() == Boolean.TRUE) {
                this.tabPane.setIconAt(1, OpFooter.getThemeIcon(null, false));
            } else {
                this.tabPane.setIconAt(1, OpFooter.getThemeIcon(this.orangeScheme, false));
            }
        }
        if (this.layerControls != null && evt.getPropertyName().equals("Blending Modes")) {
            if (evt.getNewValue() == Boolean.TRUE) {
                this.tabPane.setIconAt(0, OpFooter.getThemeIcon(null, true));
            } else {
                this.tabPane.setIconAt(0, OpFooter.getThemeIcon(this.orangeScheme, true));
            }
        }
    }

    private static Icon getThemeIcon(ColorScheme colorScheme, boolean square) {
        int iSize = SubstanceSizeUtils.getTitlePaneIconSize();
        BufferedImage result = SubstanceCoreUtilities.getBlankImage((int)iSize, (int)iSize);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color1 = colorScheme == null ? Color.red : colorScheme.getUltraDarkColor();
        Color color2 = colorScheme == null ? Color.green : colorScheme.getMidColor();
        Color color3 = colorScheme == null ? Color.blue : colorScheme.getExtraLightColor();
        graphics.setColor(color1);
        if (square) {
            graphics.fillRect(5, 2, 6, 6);
        } else {
            graphics.fillOval(5, 2, 6, 6);
        }
        graphics.setColor(color1.darker());
        if (square) {
            graphics.drawRect(5, 2, 6, 6);
        } else {
            graphics.drawOval(5, 2, 6, 6);
        }
        graphics.setColor(color2);
        if (square) {
            graphics.fillRect(1, 9, 6, 6);
        } else {
            graphics.fillOval(1, 9, 6, 6);
        }
        graphics.setColor(color2.darker());
        if (square) {
            graphics.drawRect(1, 9, 6, 6);
        } else {
            graphics.drawOval(1, 9, 6, 6);
        }
        graphics.setColor(color3);
        if (square) {
            graphics.fillRect(9, 9, 6, 6);
        } else {
            graphics.fillOval(9, 9, 6, 6);
        }
        graphics.setColor(color3.darker());
        if (square) {
            graphics.drawRect(9, 9, 6, 6);
        } else {
            graphics.drawOval(9, 9, 6, 6);
        }
        graphics.dispose();
        return new ImageIcon(result);
    }

    OpFooter(OpControl control, List<LayerMode> layerModes) {
        super(0);
        this.layerControls = new LayerControls(control, layerModes, this.pcs);
        this.invertRegionSwitch = new InvertRegionCheckBox(control, this.pcs);
        this.colorControls = new ColorSelectionControls(control, this.pcs);
        Box blendBox = Box.createVerticalBox();
        blendBox.add(Box.createVerticalStrut(5));
        blendBox.add(this.layerControls);
        blendBox.add(this.invertRegionSwitch);
        blendBox.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.layerControls.setAlignmentX(0.0f);
        this.invertRegionSwitch.setAlignmentX(0.0f);
        this.tabPane = new JTabbedPane();
        this.tabPane.setFont(LightZoneSkin.fontSet.getSmallFont());
        this.tabPane.setTabLayoutPolicy(1);
        this.tabPane.add(Locale.LOCALE.get("ToolSettingsTabName"), blendBox);
        this.tabPane.add(Locale.LOCALE.get("ColorSelectionTabName"), this.colorControls);
        this.tabPane.setIconAt(0, OpFooter.getThemeIcon(this.orangeScheme, true));
        this.tabPane.setIconAt(1, OpFooter.getThemeIcon(this.orangeScheme, false));
        this.add((Component)this.tabPane, "North");
        this.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.pcs.addPropertyChangeListener(this);
    }

    boolean isRegionsInverted() {
        return this.invertRegionSwitch.isRegionsInverted();
    }

    void operationChanged(Operation op) {
        this.layerControls.operationChanged(op);
        this.colorControls.operationChanged(op);
    }

    void save(XmlNode node) {
        this.layerControls.save(node);
        this.invertRegionSwitch.save(node);
        this.colorControls.save(node);
        node.setAttribute(TabIndexTag, Integer.toString(this.tabPane.getSelectedIndex()));
    }

    void restore(XmlNode node) throws XMLException {
        this.layerControls.restore(node);
        this.invertRegionSwitch.restore(node);
        this.colorControls.restore(node);
        if (node.hasAttribute(TabIndexTag)) {
            this.tabPane.setSelectedIndex(Integer.parseInt(node.getAttribute(TabIndexTag)));
        }
    }
}

