/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.ui.editor.Locale;
import com.lightcrafts.ui.editor.ModeManager;
import com.lightcrafts.ui.layout.ToggleTitleBorder;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.CoolToggleButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class ModeButtons
extends Box {
    private static final Icon ArrowIcon = IconFactory.createInvertedIcon(ModeButtons.class, "arrow.png");
    private static final Icon CropIcon = IconFactory.createInvertedIcon(ModeButtons.class, "crop.png");
    private static final Icon RotateIcon = IconFactory.createInvertedIcon(ModeButtons.class, "rotate.png");
    private static final Icon RegionIcon = IconFactory.createInvertedIcon(ModeButtons.class, "regiongeneric.png");
    private static final String ArrowTip = Locale.LOCALE.get("ArrowToolTip");
    private static final String CropTip = Locale.LOCALE.get("CropToolTip");
    private static final String RotateTip = Locale.LOCALE.get("RotateToolTip");
    private static final String RegionTip = Locale.LOCALE.get("RegionToolTip");
    private CoolToggleButton arrowButton = new CoolToggleButton();
    private CoolToggleButton cropButton = new CoolToggleButton();
    private CoolToggleButton rotateButton = new CoolToggleButton();
    private CoolToggleButton regionButton = new CoolToggleButton();
    private JComponent extrasContainer;

    ModeButtons(final ModeManager manager) {
        super(0);
        this.arrowButton.setIcon(ArrowIcon);
        this.cropButton.setIcon(CropIcon);
        this.rotateButton.setIcon(RotateIcon);
        this.regionButton.setIcon(RegionIcon);
        this.arrowButton.setToolTipText(ArrowTip);
        this.cropButton.setToolTipText(CropTip);
        this.rotateButton.setToolTipText(RotateTip);
        this.regionButton.setToolTipText(RegionTip);
        this.arrowButton.setStyle(CoolButton.ButtonStyle.LEFT);
        this.cropButton.setStyle(CoolButton.ButtonStyle.CENTER);
        this.rotateButton.setStyle(CoolButton.ButtonStyle.CENTER);
        this.regionButton.setStyle(CoolButton.ButtonStyle.RIGHT);
        ButtonGroup group = new ButtonGroup();
        group.add(this.arrowButton);
        group.add(this.cropButton);
        group.add(this.rotateButton);
        group.add(this.regionButton);
        this.arrowButton.setSelected(true);
        this.arrowButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModeButtons.this.removeExtras();
                    JComponent extras = manager.setNoMode();
                    ModeButtons.this.addExtras(extras);
                }
            }
        });
        this.cropButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModeButtons.this.removeExtras();
                    manager.setNoMode();
                    JComponent extras = manager.setCropMode();
                    ModeButtons.this.addExtras(extras);
                }
            }
        });
        this.rotateButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModeButtons.this.removeExtras();
                    manager.setNoMode();
                    JComponent extras = manager.setRotateMode();
                    ModeButtons.this.addExtras(extras);
                }
            }
        });
        this.regionButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModeButtons.this.removeExtras();
                    manager.setNoMode();
                    JComponent extras = manager.setRegionMode();
                    ModeButtons.this.addExtras(extras);
                }
            }
        });
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(this.arrowButton);
        buttonBox.add(this.cropButton);
        buttonBox.add(this.rotateButton);
        buttonBox.add(this.regionButton);
        ToggleTitleBorder.setBorder(buttonBox, Locale.LOCALE.get("ModeBorderTitle"));
        this.add(buttonBox);
        this.extrasContainer = Box.createHorizontalBox();
        JPanel extrasOuter = new JPanel(new BorderLayout());
        extrasOuter.add(this.extrasContainer);
        ToggleTitleBorder.setBorder(extrasOuter, " ");
        this.add(extrasOuter);
        Dimension size = this.getPreferredSize();
        size.width = 350;
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
    }

    ModeButtons() {
        this(null);
        this.arrowButton.setEnabled(false);
        this.cropButton.setEnabled(false);
        this.rotateButton.setEnabled(false);
        this.regionButton.setEnabled(false);
    }

    boolean isCropSelected() {
        return this.cropButton.isSelected();
    }

    boolean isRotateSelected() {
        return this.rotateButton.isSelected();
    }

    void clickNoMode() {
        this.arrowButton.doClick();
    }

    void clickCropButton() {
        this.cropButton.doClick();
    }

    void clickRotateButton() {
        this.rotateButton.doClick();
    }

    void clickRegionButton() {
        this.regionButton.doClick();
    }

    void setRegionsEnabled(boolean enabled) {
        this.regionButton.setEnabled(enabled);
    }

    private void removeExtras() {
        this.extrasContainer.removeAll();
        this.revalidate();
        this.repaint();
    }

    private void addExtras(JComponent extras) {
        if (extras != null) {
            this.extrasContainer.add(extras);
            this.revalidate();
            this.repaint();
        }
    }
}

