/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.model.Engine;
import com.lightcrafts.model.Scale;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.editor.Locale;
import com.lightcrafts.ui.editor.ScaleListener;
import com.lightcrafts.ui.editor.ScaleModel;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.CoolToggleButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;

final class FitButton
extends CoolToggleButton
implements ItemListener,
ScaleListener {
    private static Icon Icon = IconFactory.createInvertedIcon(FitButton.class, "fit.png");
    private static final String ToolTip = Locale.LOCALE.get("ZoomFitToolTip");
    private Editor editor;
    private Engine engine;
    private ScaleModel scale;
    private boolean isChangingScale;

    FitButton(Editor editor, Engine engine, ScaleModel scale) {
        this.editor = editor;
        this.engine = engine;
        this.scale = scale;
        this.setStyle(CoolButton.ButtonStyle.CENTER);
        this.setIcon(Icon);
        this.setToolTipText(ToolTip);
        this.addItemListener(this);
        scale.addScaleListener(this);
    }

    FitButton() {
        this.setIcon(Icon);
        this.setToolTipText(ToolTip);
        this.setEnabled(false);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.doZoomToFit();
        }
    }

    void doZoomToFit() {
        Rectangle rect = this.editor.getMaxImageBounds();
        if (rect.width > 0 && rect.height > 0) {
            this.isChangingScale = true;
            Scale oldScale = this.scale.getCurrentScale();
            Scale newScale = this.engine.setScale(rect);
            if (!this.scale.setScale(newScale)) {
                this.engine.setScale(oldScale);
            }
            this.isChangingScale = false;
        }
    }

    @Override
    public void scaleChanged(Scale scale) {
        if (!this.isChangingScale) {
            this.setSelected(false);
        }
    }
}

