/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.ui.ActivityMeter;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.DisabledImages;
import com.lightcrafts.ui.editor.Editor;
import java.awt.image.RenderedImage;
import javax.swing.JComponent;

public class DisabledEditor
extends Editor {
    private DisabledImages images;
    private ActivityMeter imagePane;
    private Object lastKey;

    DisabledEditor(Listener listener) {
        this.images = new DisabledImages(listener);
        this.imagePane = new ActivityMeter(this.images);
        this.images.setBorder(LightZoneSkin.getImageBorder());
    }

    public void addImage(Object key, RenderedImage image) {
        this.images.addImage(key, image);
        this.images.validate();
        this.lastKey = key;
    }

    public void updateImage(Object key, RenderedImage image) {
        this.images.updateImage(key, image);
        this.images.validate();
    }

    public void removeImages() {
        this.images.removeAllImages();
        this.images.repaint();
        this.lastKey = null;
    }

    public void setImage(Object key, RenderedImage image) {
        this.removeImages();
        this.addImage(key, image);
    }

    public boolean hasImage(Object key) {
        return this.images.hasKey(key);
    }

    public Object getLastKey() {
        return this.lastKey;
    }

    @Override
    public JComponent getImage() {
        return this.imagePane;
    }

    @Override
    public void showWait(String text) {
        this.imagePane.showWait(text);
    }

    @Override
    public void hideWait() {
        this.imagePane.hideWait();
    }

    @Override
    public void setDisabledText(String text) {
        this.images.setDisabledText(text);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public static interface Listener {
        public void imageClicked(Object var1);
    }
}

