/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.platform.AlertDialog;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.browser.view.Locale;
import com.lightcrafts.ui.export.ExportNameUtility;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

class FileActions {
    FileActions() {
    }

    static void deleteFiles(File[] files, Component parent) {
        AlertDialog alert = Platform.getPlatform().getAlertDialog();
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        StringBuilder info = new StringBuilder();
        String message = files.length > 1 ? Locale.LOCALE.get("DeleteQuestionPlural", Integer.toString(files.length)) : Locale.LOCALE.get("DeleteQuestionSingular", files[0].getName());
        String okButton = Locale.LOCALE.get("DeleteButton");
        String cancelButton = Locale.LOCALE.get("CancelButton");
        int option = alert.showAlert(frame, message, info.toString(), 1, okButton, cancelButton);
        if (option == 0) {
            Platform platform = Platform.getPlatform();
            for (File file : files) {
                String error;
                boolean deleted;
                String path = file.getAbsolutePath();
                try {
                    ImageInfo.closeAll();
                    deleted = platform.moveFilesToTrash(new String[]{path});
                }
                catch (IOException e) {
                    deleted = false;
                }
                if (!deleted && (option = alert.showAlert(frame, error = Locale.LOCALE.get("DeleteFailed", file.getName()), "", 2, Locale.LOCALE.get("ContinueButton"), Locale.LOCALE.get("CancelButton"))) > 0) break;
            }
        }
    }

    static void renameFile(File file, Component parent) {
        String suffix = ExportNameUtility.getFileExtension(file);
        String oldName = ExportNameUtility.trimFileExtension(file.getName());
        File defaultFile = ExportNameUtility.ensureNotExists(file);
        defaultFile = ExportNameUtility.trimFileExtension(defaultFile);
        String defaultName = defaultFile.getName();
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        String name = JOptionPane.showInputDialog(frame, Locale.LOCALE.get("RenamePrompt", oldName), defaultName);
        if (name != null) {
            int option;
            File dir = file.getParentFile();
            File newFile = new File(dir, name);
            if ((newFile = ExportNameUtility.setFileExtension(newFile, suffix)).isDirectory()) {
                JOptionPane.showMessageDialog(frame, Locale.LOCALE.get("RenameFailedDirectory", name));
                return;
            }
            if (newFile.exists() && (option = JOptionPane.showConfirmDialog(frame, Locale.LOCALE.get("ClobberPrompt", name))) != 0) {
                return;
            }
            boolean fileRenamed = false;
            boolean xmpFileExists = false;
            boolean xmpFileRenamed = false;
            try {
                File xmpFile = FileActions.getXmpFile(file);
                ImageInfo.closeAll();
                fileRenamed = file.renameTo(newFile);
                xmpFileExists = xmpFile.isFile();
                if (fileRenamed && xmpFileExists) {
                    File newXmpFile = FileActions.getXmpFile(newFile);
                    ImageInfo.closeAll();
                    xmpFileRenamed = xmpFile.renameTo(newXmpFile);
                }
            }
            catch (Throwable t) {
                System.out.println("File rename failed");
                t.printStackTrace();
            }
            if (!fileRenamed) {
                String error = Locale.LOCALE.get("RenameError", file.getName(), newFile.getName());
                JOptionPane.showMessageDialog(frame, error, Locale.LOCALE.get("RenameErrorTitle"), 0);
            } else if (xmpFileExists && !xmpFileRenamed) {
                boolean fileUnRenamed;
                if (fileRenamed && !(fileUnRenamed = newFile.renameTo(file))) {
                    System.out.println("Failed to undo file rename");
                }
                String error = Locale.LOCALE.get("XmpRenameError", file.getName());
                JOptionPane.showMessageDialog(frame, error, Locale.LOCALE.get("RenameErrorTitle"), 0);
            }
        }
    }

    private static File getXmpFile(File file) throws IOException, BadImageFileException, UnknownImageTypeException {
        ImageInfo info = ImageInfo.getInstanceFor(file);
        String name = info.getXMPFilename();
        return new File(name);
    }
}

