/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.model;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.CoreDirectory;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.image.metadata.TIFFDirectory;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.ui.browser.model.EggImage;
import com.lightcrafts.ui.browser.model.ImageDatumComparator;
import com.lightcrafts.ui.browser.model.ImageDatumObserver;
import com.lightcrafts.ui.browser.model.ImageDatumType;
import com.lightcrafts.ui.browser.model.ImageGroup;
import com.lightcrafts.ui.browser.model.ImageTask;
import com.lightcrafts.ui.browser.model.ImageTaskQueue;
import com.lightcrafts.ui.browser.model.Locale;
import com.lightcrafts.ui.browser.model.PreviewUpdater;
import com.lightcrafts.ui.browser.model.Thumbnailer;
import com.lightcrafts.utils.filecache.FileCache;
import java.awt.EventQueue;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;

public class ImageDatum {
    private File file;
    private long fileCacheTime;
    private File xmpFile;
    private long xmpFileCacheTime;
    private ImageMetadata meta;
    private SoftReference<RenderedImage> image;
    private ImageDatumType type;
    private boolean isDirty;
    private ImageTask task;
    private ImageTaskQueue queue;
    private FileCache cache;
    private int size;
    private LinkedList<ImageDatumObserver> observers;
    private LinkedList<PreviewUpdater> previews;
    private ImageGroup group;
    private boolean badFile = false;

    public ImageDatum(File file, int size, ImageTaskQueue queue, FileCache cache) {
        this.file = file;
        this.size = size;
        this.queue = queue;
        this.cache = cache;
        this.markDirty();
        this.observers = new LinkedList();
        this.previews = new LinkedList();
        this.group = new ImageGroup(this);
    }

    public File getFile() {
        return this.file;
    }

    public File getXmpFile() {
        return this.xmpFile;
    }

    public boolean isBadFile() {
        return this.badFile;
    }

    void setBadFile() {
        this.badFile = true;
    }

    public void rotateLeft() throws IOException, BadImageFileException, UnknownImageTypeException {
        if (this.type == null || this.type.hasLznData()) {
            throw new IOException(Locale.LOCALE.get("CantRotateLzn"));
        }
        ImageInfo info = ImageInfo.getInstanceFor(this.file);
        ImageMetadata meta = info.getMetadata();
        meta.setOrientation(meta.getOrientation().get90CCW());
        this.commitRotate(info, 3);
    }

    public void rotateRight() throws IOException, BadImageFileException, UnknownImageTypeException {
        if (this.type == null || this.type.hasLznData()) {
            throw new IOException(Locale.LOCALE.get("CantRotateLzn"));
        }
        ImageInfo info = ImageInfo.getInstanceFor(this.file);
        ImageMetadata meta = info.getMetadata();
        meta.setOrientation(meta.getOrientation().get90CW());
        this.commitRotate(info, 1);
    }

    public void setRating(int rating) throws IOException, BadImageFileException, UnknownImageTypeException {
        ImageInfo info = ImageInfo.getInstanceFor(this.file);
        ImageMetadata meta = info.getMetadata();
        meta.setRating(rating);
        this.writeToXmp(info);
        this.rateInMemory(rating);
    }

    public void clearRating() throws IOException, BadImageFileException, UnknownImageTypeException {
        ImageInfo info = ImageInfo.getInstanceFor(this.file);
        ImageMetadata meta = info.getMetadata();
        meta.clearRating();
        this.writeToXmp(info);
        this.rateInMemory(0);
    }

    public void refresh(boolean useImageCache) {
        long mod;
        long now;
        if (!useImageCache && this.meta != null && (now = System.currentTimeMillis()) - (mod = PreviewUpdater.getCachedPreviewTime(this.meta, this.cache)) > 10000L) {
            this.clearPreview();
        }
        this.meta = null;
        this.type = null;
        this.image = null;
        this.clearMetadataCache();
        this.restartTask(useImageCache);
    }

    public void cancel() {
        if (this.task != null) {
            this.queue.removeTask(this.task);
        }
    }

    void setSize(int size) {
        if (size != this.size && size > 0) {
            this.size = size;
            this.restartTask(true);
        }
    }

    public synchronized RenderedImage getImage(ImageDatumObserver observer) {
        RenderedImage image;
        if (observer != null && !this.observers.contains(observer)) {
            this.observers.add(observer);
        }
        RenderedImage renderedImage = image = this.image != null ? this.image.get() : null;
        if (!this.badFile) {
            if (this.task == null || image == null || this.isDirty) {
                this.restartTask(true);
            }
            this.queue.raiseTask(this.task);
        }
        if (image != null) {
            return image;
        }
        return EggImage.getEggImage(this.size);
    }

    public synchronized PreviewUpdater getPreview(PreviewUpdater.Provider provider) {
        RenderedImage preview = this.getImage(null);
        PreviewUpdater updater = new PreviewUpdater(this.cache, preview, this.getMetadata(true), provider);
        this.previews.add(updater);
        return updater;
    }

    public void disposePreviews() {
        for (PreviewUpdater preview : this.previews) {
            preview.dispose();
        }
        this.previews.clear();
    }

    synchronized void setImage(RenderedImage image) {
        this.image = new SoftReference<RenderedImage>(image);
    }

    long getFileCacheTime() {
        return this.fileCacheTime;
    }

    long getXmpFileCacheTime() {
        return this.xmpFileCacheTime;
    }

    public synchronized ImageMetadata getMetadata(boolean useCache) {
        if (this.readRotateCache() != 0) {
            this.migrateRotateCacheToXmp();
            useCache = false;
        }
        if (this.meta == null && useCache) {
            this.readMetadataCache();
        }
        if (this.meta != null) {
            return this.meta;
        }
        File file = this.getFile();
        ImageInfo info = ImageInfo.getInstanceFor(file);
        try {
            ImageMetadata meta = info.getMetadata();
            try {
                this.xmpFile = new File(info.getXMPFilename());
            }
            catch (Throwable e) {
                this.badFile = true;
                this.logMetadataError(e);
                this.xmpFile = null;
            }
            this.updateMetadata(meta);
            this.updateFileTimes();
            this.writeMetadataCache();
        }
        catch (Throwable e) {
            this.badFile = true;
            this.logMetadataError(e);
            this.meta = EggImage.getEggMetadata(file);
        }
        return this.meta;
    }

    public ImageGroup getGroup() {
        return this.group;
    }

    public void setGroup(ImageGroup group) {
        this.group.removeImageDatum(this);
        this.group = group;
        group.addImageDatum(this);
    }

    public ImageGroup newGroup() {
        this.group.removeImageDatum(this);
        this.group = new ImageGroup(this);
        return this.group;
    }

    public ImageDatumType getType() {
        if (this.type == null) {
            this.type = ImageDatumType.getTypeOf(this);
        }
        return this.type;
    }

    void markDirty() {
        this.isDirty = true;
    }

    void markClean() {
        this.isDirty = false;
        this.updatePreviews();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageDatum.this.notifyImageObservers();
            }
        });
    }

    private void updateMetadata(ImageMetadata meta) {
        ImageDatumComparator[] comps;
        int[] tags;
        this.meta = new ImageMetadata();
        ImageMetadataDirectory core = meta.getDirectoryFor(CoreDirectory.class, true);
        ImageMetadataDirectory thisCore = this.meta.getDirectoryFor(CoreDirectory.class, true);
        for (int tag : tags = new int[]{3, 2, 516, 518}) {
            ImageMetaValue value = core.getValue(tag);
            if (value == null) continue;
            thisCore.putValue(tag, value);
        }
        for (ImageDatumComparator comp : comps = ImageDatumComparator.getAll()) {
            int tagId = comp.getTagId();
            ImageMetaValue value = core.getValue(tagId);
            if (value == null) continue;
            thisCore.putValue(tagId, value);
        }
        ImageMetaValue xmpValue = meta.getValue(TIFFDirectory.class, 700);
        if (xmpValue != null) {
            ImageMetadataDirectory thisTiff = this.meta.getDirectoryFor(TIFFDirectory.class, true);
            thisTiff.putValue(700, xmpValue);
        }
    }

    private synchronized void commitRotate(ImageInfo info, int multiple) throws IOException, BadImageFileException, UnknownImageTypeException {
        this.rotateInMemory(multiple);
        try {
            this.writeToXmp(info);
        }
        catch (IOException e) {
            this.rotateInMemory(-multiple);
            throw e;
        }
        catch (BadImageFileException e) {
            this.rotateInMemory(-multiple);
            throw e;
        }
        catch (UnknownImageTypeException e) {
            this.rotateInMemory(-multiple);
            throw e;
        }
    }

    private void rotateInMemory(int multiple) {
        RenderedImage image;
        RenderedImage renderedImage = image = this.image != null ? this.image.get() : null;
        if (image != null) {
            image = Thumbnailer.rotateNinetyTimes(image, multiple);
            this.image = new SoftReference<RenderedImage>(image);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageDatum.this.notifyImageObservers();
                }
            });
        }
    }

    private void rateInMemory(int rating) {
        if (this.meta != null) {
            if (rating > 0) {
                this.meta.setRating(rating);
            } else {
                this.meta.clearRating();
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageDatum.this.notifyImageObservers();
                }
            });
        }
    }

    private void restartTask(boolean useCache) {
        if (this.task != null) {
            this.queue.removeTask(this.task);
        }
        this.task = new ImageTask(this, this.cache, this.size, useCache);
        this.markDirty();
        this.queue.addTask(this.task);
    }

    private synchronized void updatePreviews() {
        LinkedList<PreviewUpdater> newRefs = new LinkedList<PreviewUpdater>();
        Iterator i = this.previews.iterator();
        while (i.hasNext()) {
            RenderedImage image;
            PreviewUpdater updater = (PreviewUpdater)i.next();
            if (updater == null || (image = this.image != null ? this.image.get() : null) == null) continue;
            i.remove();
            updater = new PreviewUpdater(updater, image, this.meta);
            newRefs.add(updater);
        }
        this.previews.addAll(newRefs);
    }

    private void notifyImageObservers() {
        for (ImageDatumObserver observer : this.observers) {
            observer.imageChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readRotateCache() {
        String key = this.getRotateKey();
        int rotate = 0;
        if (this.cache != null && this.cache.contains(key)) {
            try {
                FileInputStream in = this.cache.getStreamFor(key);
                try {
                    rotate = ((InputStream)in).read();
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return rotate;
    }

    private void migrateRotateCacheToXmp() {
        int rotate = this.readRotateCache();
        if (rotate != 0) {
            try {
                ImageInfo info = ImageInfo.getInstanceFor(this.file);
                ImageMetadata meta = info.getMetadata();
                ImageOrientation orient = meta.getOrientation();
                switch (rotate) {
                    case 1: {
                        orient = orient.get90CW();
                        break;
                    }
                    case 2: {
                        orient = orient.get180();
                        break;
                    }
                    case 3: {
                        orient = orient.get90CCW();
                    }
                }
                meta.setOrientation(orient);
                File xmpFile = new File(info.getXMPFilename());
                if (!xmpFile.isFile()) {
                    this.writeToXmp(info);
                    System.out.println("Migrated rotate cache to XMP for " + this.file.getAbsolutePath());
                } else {
                    System.out.println("Rotate cache migration aborted for " + this.file.getAbsolutePath() + " (" + xmpFile.getAbsolutePath() + " already exists)");
                }
            }
            catch (Throwable t) {
                System.err.println("Failed to migrate rotate cache to XMP for " + this.file.getAbsolutePath());
                t.printStackTrace();
            }
            String key = this.getRotateKey();
            try {
                this.cache.remove(key);
                System.out.println("Cleared rotate cache to XMP for " + this.file.getAbsolutePath());
            }
            catch (IOException e) {
                System.err.println("Failed to clear rotate cache for " + this.file.getAbsolutePath());
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetadataCache() {
        if (this.cache == null) {
            return;
        }
        String metaKey = this.getMetadataKey();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(this.cache.putToStream(metaKey));
            out.writeObject(this.meta);
        }
        catch (IOException e) {
            System.err.println("metadata cache error: " + e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    System.err.println("metadata cache error: " + e.getMessage());
                }
            }
        }
        String fileTimeKey = this.getFileTimeCacheKey();
        try {
            out = new ObjectOutputStream(this.cache.putToStream(fileTimeKey));
            out.writeObject(this.fileCacheTime);
        }
        catch (IOException e) {
            System.err.println("file time cache error: " + e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    System.err.println("file time cache error: " + e.getMessage());
                }
            }
        }
        if (this.xmpFile == null) {
            return;
        }
        String xmpFileKey = this.getXmpKey();
        try {
            out = new ObjectOutputStream(this.cache.putToStream(xmpFileKey));
            out.writeObject(this.xmpFile);
        }
        catch (IOException e) {
            System.err.println("file time cache error: " + e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    System.err.println("file time cache error: " + e.getMessage());
                }
            }
        }
        String xmpFileTimeKey = this.getXmpFileTimeCacheKey();
        try {
            out = new ObjectOutputStream(this.cache.putToStream(xmpFileTimeKey));
            out.writeObject(this.xmpFileCacheTime);
        }
        catch (IOException e) {
            System.err.println("XMP file time cache error: " + e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    System.err.println("XMP file time cache error: " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void readMetadataCache() {
        if (this.cache == null) {
            return;
        }
        fileTimeKey = this.getFileTimeCacheKey();
        if (this.cache.contains(fileTimeKey)) {
            oin = null;
            try {
                in = this.cache.getStreamFor(fileTimeKey);
                if (in != null) {
                    oin = new ObjectInputStream(in);
                    this.fileCacheTime = (Long)oin.readObject();
                }
            }
            catch (IOException e) {
                this.fileCacheTime = 0L;
            }
            catch (ClassNotFoundException e) {
                this.fileCacheTime = 0L;
            }
            finally {
                if (oin != null) {
                    try {
                        oin.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (this.cache.contains(xmpFileKey = this.getXmpKey())) {
            oin = null;
            try {
                in = this.cache.getStreamFor(xmpFileKey);
                if (in != null) {
                    oin = new ObjectInputStream(in);
                    this.xmpFile = (File)oin.readObject();
                }
            }
            catch (IOException e) {
                this.xmpFile = null;
            }
            catch (ClassNotFoundException e) {
                this.xmpFile = null;
            }
            finally {
                if (oin != null) {
                    try {
                        oin.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (this.xmpFile != null) {
            xmpFileTimeKey = this.getXmpFileTimeCacheKey();
            if (this.cache.contains(xmpFileTimeKey)) {
                oin = null;
                try {
                    in = this.cache.getStreamFor(xmpFileTimeKey);
                    if (in == null) ** GOTO lbl73
                    oin = new ObjectInputStream(in);
                    this.xmpFileCacheTime = (Long)oin.readObject();
                }
                catch (IOException e) {
                    this.xmpFileCacheTime = 0L;
                }
                catch (ClassNotFoundException e) {
                    this.xmpFileCacheTime = 0L;
                }
                finally {
                    if (oin != null) {
                        try {
                            oin.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        } else {
            this.xmpFileCacheTime = 0L;
        }
lbl73:
        // 6 sources

        if (this.cache.contains(metaKey = this.getMetadataKey())) {
            oin = null;
            try {
                in = this.cache.getStreamFor(metaKey);
                if (in != null) {
                    oin = new ObjectInputStream(in);
                    this.meta = (ImageMetadata)oin.readObject();
                }
            }
            catch (IOException var5_24) {
            }
            catch (ClassNotFoundException var5_26) {
            }
            finally {
                if (oin != null) {
                    try {
                        oin.close();
                    }
                    catch (IOException var5_23) {}
                }
            }
        }
    }

    private void clearMetadataCache() {
        String xmpFileKey;
        String fileTimeKey;
        if (this.cache == null) {
            return;
        }
        String key = this.getMetadataKey();
        if (this.cache.contains(key)) {
            try {
                this.cache.remove(key);
            }
            catch (IOException e) {
                System.err.println("metadata cache clear error: " + e.getMessage());
            }
        }
        if (this.cache.contains(fileTimeKey = this.getFileTimeCacheKey())) {
            try {
                this.cache.remove(fileTimeKey);
            }
            catch (IOException e) {
                System.err.println("metadata cache clear error: " + e.getMessage());
            }
        }
        if (this.cache.contains(xmpFileKey = this.getXmpKey())) {
            try {
                this.cache.remove(xmpFileKey);
            }
            catch (IOException e) {
                System.err.println("metadata cache clear error: " + e.getMessage());
            }
        }
        if (this.xmpFile == null) {
            return;
        }
        String xmpFileTimeKey = this.getXmpFileTimeCacheKey();
        if (this.cache.contains(xmpFileTimeKey)) {
            try {
                this.cache.remove(xmpFileTimeKey);
            }
            catch (IOException e) {
                System.err.println("metadata cache clear error: " + e.getMessage());
            }
        }
    }

    private String getRotateKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.file.getAbsolutePath());
        buffer.append("_rotate");
        return buffer.toString();
    }

    private String getMetadataKey() {
        long time = Math.max(this.fileCacheTime, this.xmpFileCacheTime);
        return this.file.getAbsolutePath() + "_" + time;
    }

    private String getXmpKey() {
        return this.file.getAbsolutePath() + "_xmp_file";
    }

    private void updateFileTimes() {
        if (this.cache == null) {
            return;
        }
        this.fileCacheTime = this.file.lastModified();
        this.xmpFileCacheTime = this.xmpFile != null ? this.xmpFile.lastModified() : 0L;
    }

    private String getFileTimeCacheKey() {
        return this.file.getAbsolutePath() + "_cache_time";
    }

    private String getXmpFileTimeCacheKey() {
        return this.xmpFile.getAbsolutePath() + "_cache_time";
    }

    private void clearPreview() {
        PreviewUpdater.clearCachedPreviewForImage(this.meta, this.cache);
    }

    private void logMetadataError(Throwable t) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.file.getAbsolutePath());
        buffer.append(" reading metadata ");
        buffer.append(t.getClass().getName());
        if (t.getMessage() != null) {
            buffer.append(": ");
            buffer.append(t.getMessage());
        }
        System.err.println(buffer);
    }

    private void writeToXmp(ImageInfo info) throws IOException, BadImageFileException, UnknownImageTypeException {
        info.getImageType().writeMetadata(info);
        try {
            this.xmpFile = new File(info.getXMPFilename());
        }
        catch (Throwable e) {
            this.logMetadataError(e);
            this.xmpFile = null;
        }
    }
}

