/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.folders;

import com.lightcrafts.ui.browser.folders.FolderFilter;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Pattern;

final class MacOSXFolderFilter
extends FolderFilter {
    private static final HashSet<String> m_hiddenDirectories = new HashSet();
    private static final Pattern m_volumePattern = Pattern.compile("^/Volumes/[^/]*$");

    MacOSXFolderFilter() {
    }

    @Override
    public boolean accept(File file) {
        if (!super.accept(file)) {
            return false;
        }
        String parent = file.getParent();
        if (!"/".equals(parent) && !m_volumePattern.matcher(parent).matches()) {
            return true;
        }
        if (m_volumePattern.matcher(parent).matches() && file.getName().equals("tmp")) {
            return true;
        }
        return !m_hiddenDirectories.contains(file.getName());
    }

    static {
        String[] hiddenDirectories = new String[]{"automount", "bin", "cores", "dev", "etc", "Library", "lost+found", "opt", "private", "sbin", "System", "tmp", "usr", "var", "Volumes"};
        m_hiddenDirectories.addAll(Arrays.asList(hiddenDirectories));
    }
}

