/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.ctrls;

import com.lightcrafts.ui.browser.ctrls.Locale;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import java.awt.Dimension;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SizeSlider
extends Box {
    private static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/browser/ctrls");
    private static final String SizeKey = "SizeSlider";
    private static final int MinSize = 80;
    private static final int MaxSize = 320;
    private static final int DefaultSize = 144;
    private JSlider slider = new JSlider(80, 320);

    public SizeSlider(final AbstractImageBrowser browser) {
        super(0);
        this.add(this.slider);
        this.setMaximumSize(new Dimension(150, 150));
        this.setPreferredSize(new Dimension(150, 0));
        int size = Prefs.getInt(SizeKey, 144);
        this.slider.setValue(size);
        this.slider.setToolTipText(Locale.LOCALE.get("SizeToolTip"));
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int size = SizeSlider.this.slider.getValue();
                boolean isAdjusting = SizeSlider.this.slider.getValueIsAdjusting();
                browser.setCharacteristicSize(size, isAdjusting);
                if (!isAdjusting) {
                    Prefs.putInt(SizeSlider.SizeKey, size);
                }
            }
        });
        this.slider.setFocusable(false);
    }

    public int getValue() {
        return this.slider.getValue();
    }
}

