/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.ctrls;

import com.lightcrafts.app.CollapseButton;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.ui.browser.ctrls.CopyPasteButtons;
import com.lightcrafts.ui.browser.ctrls.Locale;
import com.lightcrafts.ui.browser.ctrls.RatingButton;
import com.lightcrafts.ui.browser.ctrls.RotateButtons;
import com.lightcrafts.ui.browser.ctrls.SelectLatestButton;
import com.lightcrafts.ui.browser.ctrls.SizeSlider;
import com.lightcrafts.ui.browser.ctrls.SortCtrl;
import com.lightcrafts.ui.browser.ctrls.TrashButton;
import com.lightcrafts.ui.browser.model.ImageDatumComparator;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.ImageBrowserEvent;
import com.lightcrafts.ui.browser.view.ImageBrowserListener;
import com.lightcrafts.ui.browser.view.ImageBrowserScrollPane;
import com.lightcrafts.ui.layout.ToggleTitleBorder;
import com.lightcrafts.ui.toolkit.BoxedButton;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.border.Border;

public class BrowserControls
extends Box {
    private JLabel browserError;

    public BrowserControls(final ImageBrowserScrollPane browserScroll, ComboFrame frame) {
        super(0);
        AbstractImageBrowser browser = browserScroll.getBrowser();
        BoxedButton rotator = new BoxedButton(Locale.LOCALE.get("RotateBorderTitle"), new RotateButtons(browser));
        BoxedButton rater = new BoxedButton(Locale.LOCALE.get("RateBorderTitle"), new RatingButton(browser));
        BoxedButton copyPaste = new BoxedButton(Locale.LOCALE.get("CopyToolsBorderTitle"), new CopyPasteButtons(browser));
        SortCtrl sortCtrl = new SortCtrl(browser);
        BoxedButton sort = new BoxedButton(Locale.LOCALE.get("SortBorderTitle"), sortCtrl);
        SizeSlider sizeSlider = new SizeSlider(browser);
        ToggleTitleBorder.setBorder(sizeSlider, Locale.LOCALE.get("SizeBorderTitle"));
        sizeSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                browserScroll.setCenteringLayout(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                browserScroll.setCenteringLayout(false);
            }
        });
        BoxedButton collapse = new BoxedButton(Locale.LOCALE.get("CollapseBorderTitle"), new CollapseButton(frame));
        BoxedButton latest = new BoxedButton(Locale.LOCALE.get("SelectBorderTitle"), new SelectLatestButton(browser));
        BoxedButton trash = new BoxedButton(Locale.LOCALE.get("TrashBorderTitle"), new TrashButton(browser));
        browserScroll.setCenteringLayout(false);
        this.browserError = new JLabel();
        browser.addBrowserListener(new ImageBrowserListener(){

            @Override
            public void selectionChanged(ImageBrowserEvent event) {
                BrowserControls.this.browserError.setText("");
            }

            @Override
            public void imageDoubleClicked(ImageBrowserEvent event) {
            }

            @Override
            public void browserError(String message) {
                BrowserControls.this.browserError.setText(message);
            }
        });
        int space = 8;
        this.add(Box.createHorizontalStrut(8));
        this.add(rotator.box);
        this.add(Box.createHorizontalStrut(8));
        this.add(rater.box);
        this.add(Box.createHorizontalStrut(8));
        this.add(trash.box);
        this.add(Box.createHorizontalStrut(8));
        this.add(new Separator());
        this.add(Box.createHorizontalStrut(8));
        this.add(copyPaste.box);
        this.add(Box.createHorizontalStrut(8));
        this.add(Box.createHorizontalGlue());
        this.add(this.browserError);
        this.add(Box.createHorizontalStrut(8));
        this.add(collapse.box);
        this.add(Box.createHorizontalStrut(8));
        this.add(latest.box);
        this.add(Box.createHorizontalStrut(8));
        this.add(new Separator());
        this.add(Box.createHorizontalStrut(8));
        this.add(sizeSlider);
        this.add(Box.createHorizontalStrut(8));
        this.add(sort.box);
        this.add(Box.createHorizontalStrut(8));
        Border border = BorderFactory.createEmptyBorder(0, 0, 3, 0);
        this.setBorder(border);
        ImageDatumComparator comp = sortCtrl.getSort();
        boolean inverted = sortCtrl.getSortInverted();
        int sizeValue = sizeSlider.getValue();
        browser.setSort(comp);
        browser.setSortInverted(inverted);
        browser.setCharacteristicSize(sizeValue);
    }

    public void dispose() {
        ToggleTitleBorder.unsetAllBorders(this);
    }

    class Separator
    extends JSeparator {
        Separator() {
            super(1);
            this.setMaximumSize(new Dimension(3, 32));
        }
    }
}

