/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform;

import com.lightcrafts.image.ImageFilenameFilter;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.platform.FileChooser;
import com.lightcrafts.platform.Locale;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.export.ExportDialog;
import com.lightcrafts.utils.file.FileUtil;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;

public class DefaultFileChooser
implements FileChooser {
    @Override
    public File openFile(String windowTitle, File directory, Frame parent, FilenameFilter filter) {
        File file = null;
        FileDialog fileDialog = new FileDialog(parent, windowTitle, 0);
        if (directory != null) {
            fileDialog.setDirectory(directory.getAbsolutePath());
        }
        if (filter != null) {
            fileDialog.setFilenameFilter(filter);
        }
        fileDialog.setVisible(true);
        String chosenDirectory = fileDialog.getDirectory();
        String chosenFile = fileDialog.getFile();
        if (chosenDirectory != null && chosenFile != null) {
            file = new File(chosenDirectory, chosenFile);
        }
        return file;
    }

    @Override
    public File chooseDirectory(String windowTitle, File directory, Window parent, boolean showHidden) {
        JFileChooser chooser = new JFileChooser(directory);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(windowTitle);
        int option = chooser.showSaveDialog(parent);
        if (option == 0) {
            File file = chooser.getSelectedFile();
            return file;
        }
        return null;
    }

    @Override
    public ImageExportOptions exportFile(ImageExportOptions options, Frame parent) {
        boolean replace;
        File file;
        if ((options = ExportDialog.showDialog(options, parent)) != null && (file = options.getExportFile()) != null && file.exists() && !(replace = DefaultFileChooser.askToReplace(file, parent))) {
            return null;
        }
        return options;
    }

    @Override
    public File saveFile(File file, Frame parent) {
        String extension = FileUtil.getExtensionOf(file);
        FileDialog fileDialog = new FileDialog(parent, Locale.LOCALE.get("SaveTitle"), 1);
        if (file != null) {
            File dir = file.getParentFile();
            if (dir != null) {
                String dirPath = dir.getAbsolutePath();
                fileDialog.setDirectory(dirPath);
            }
            fileDialog.setFile(file.getName());
        }
        fileDialog.setFilenameFilter(ImageFilenameFilter.INSTANCE);
        fileDialog.setVisible(true);
        String dirPath = fileDialog.getDirectory();
        String fileName = fileDialog.getFile();
        if (dirPath != null && fileName != null) {
            File newFile = new File(dirPath, fileName);
            String newExtension = FileUtil.getExtensionOf(newFile);
            if (newExtension == null) {
                return new File(newFile.getAbsolutePath() + "." + extension);
            }
            if (!newExtension.equals(extension)) {
                String path = FileUtil.replaceExtensionOf(newFile, extension);
                return new File(path);
            }
            return newFile;
        }
        return null;
    }

    private static boolean askToReplace(File file, Frame parent) {
        int result = Platform.getPlatform().getAlertDialog().showAlert(parent, Locale.LOCALE.get("ReplaceMessageMajor", file.getName()), Locale.LOCALE.get("ReplaceMessageMinor"), 1, Locale.LOCALE.get("ReplaceMessageReplaceOption"), Locale.LOCALE.get("ReplaceMessageCancelOption"));
        return result == 0;
    }
}

