/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.opimage.FastBilateralFilterOpImage;
import com.lightcrafts.jai.opimage.HDROpImage;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.KernelJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorScience;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.lang.ref.SoftReference;
import java.text.DecimalFormat;

public class HDROperationV2
extends BlendedOperation {
    private double depth = 32.0;
    private double highlights = 1.0;
    private double detail = 0.5;
    private double shadows = 1.0;
    private double fuzz = 0.2;
    private static final String HIGHLIGHTS = "Highlights";
    private static final String DETAIL = "Detail";
    private static final String SHADOWS = "Shadows";
    private static final String DEPTH = "Depth";
    private static final String FUZZ = "Fuzz";
    static final OperationType typeV2 = new OperationTypeImpl("Tone Mapper V2");
    static final OperationType typeV3 = new OperationTypeImpl("Tone Mapper V3");
    static final OperationType typeV4 = new OperationTypeImpl("Tone Mapper V4");

    public HDROperationV2(Rendering rendering, OperationType type) {
        super(rendering, type);
        DecimalFormat format = new DecimalFormat("0.00");
        this.addSliderKey(SHADOWS);
        this.setSliderConfig(SHADOWS, new SliderConfig(0.0, 10.0, this.shadows, 0.05, false, format));
        this.addSliderKey(HIGHLIGHTS);
        this.setSliderConfig(HIGHLIGHTS, new SliderConfig(0.1, 10.0, this.highlights, 0.05, true, format));
        this.addSliderKey(DETAIL);
        this.setSliderConfig(DETAIL, new SliderConfig(0.0, 4.0, this.detail, 0.05, false, format));
        if (type == typeV3 || type == typeV4) {
            this.addSliderKey(DEPTH);
            this.setSliderConfig(DEPTH, new SliderConfig(8.0, 64.0, this.depth, 0.05, false, format));
        }
        if (type == typeV4) {
            this.addSliderKey(FUZZ);
            this.setSliderConfig(FUZZ, new SliderConfig(0.1, 1.0, this.fuzz, 0.05, false, format));
        }
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key.equals(FUZZ) && this.fuzz != value) {
            this.fuzz = value;
        } else if (key.equals(DEPTH) && this.depth != value) {
            this.depth = value;
        } else if (key.equals(HIGHLIGHTS) && this.highlights != value) {
            this.highlights = value;
        } else if (key.equals(DETAIL) && this.detail != value) {
            this.detail = value;
        } else if (key.equals(SHADOWS) && this.shadows != value) {
            this.shadows = value;
        } else {
            return;
        }
        super.setSliderValue(key, value);
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new ToneMaperTransform(source);
    }

    @Override
    public OperationType getType() {
        return this.type;
    }

    private class ToneMaperTransform
    extends BlendedOperation.BlendedTransform {
        SoftReference<PlanarImage> lastBack;
        SoftReference<PlanarImage> mask;
        private double last_radius;
        private double last_fuzz;

        ToneMaperTransform(PlanarImage source) {
            super(source);
            this.lastBack = new SoftReference<Object>(null);
            this.mask = new SoftReference<Object>(null);
            this.last_radius = 0.0;
            this.last_fuzz = 0.0;
        }

        @Override
        public PlanarImage setFront() {
            if (this.lastBack.get() != this.back || this.mask.get() == null || HDROperationV2.this.depth != this.last_radius || HDROperationV2.this.fuzz != this.last_fuzz) {
                PlanarImage singleChannel;
                if (this.back.getColorModel().getNumComponents() == 3) {
                    double[][] yChannel = new double[][]{{ColorScience.Wr, ColorScience.Wg, ColorScience.Wb, 0.0}};
                    ParameterBlock pb = new ParameterBlock();
                    pb.addSource(this.back);
                    pb.add(yChannel);
                    singleChannel = JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
                } else {
                    singleChannel = this.back;
                }
                BorderExtender copyExtender = BorderExtender.createInstance((int)1);
                RenderingHints extenderHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, copyExtender);
                FastBilateralFilterOpImage maskImage = new FastBilateralFilterOpImage((RenderedImage)singleChannel, JAIContext.fileCacheHint, (float)(HDROperationV2.this.depth * (double)HDROperationV2.this.scale), 0.1f);
                ParameterBlock pb = new ParameterBlock();
                pb.addSource((Object)maskImage);
                pb.add(new int[]{0});
                maskImage = JAI.create((String)"bandselect", (ParameterBlock)pb, null);
                if (HDROperationV2.this.fuzz > 0.1) {
                    KernelJAI kernel = Functions.getGaussKernel(10.0 * (HDROperationV2.this.fuzz - 0.1) * (double)HDROperationV2.this.scale);
                    pb = new ParameterBlock();
                    pb.addSource((Object)maskImage);
                    pb.add(kernel);
                    maskImage = JAI.create((String)"LCSeparableConvolve", (ParameterBlock)pb, (RenderingHints)extenderHints);
                }
                this.last_radius = HDROperationV2.this.fuzz;
                this.last_fuzz = HDROperationV2.this.detail;
                this.mask = new SoftReference<FastBilateralFilterOpImage>(maskImage);
                this.lastBack = new SoftReference<PlanarImage>(this.back);
            }
            return new HDROpImage((RenderedImage)this.back, (RenderedImage)this.mask.get(), HDROperationV2.this.shadows, HDROperationV2.this.highlights, 2.0 * HDROperationV2.this.detail, null);
        }
    }
}

