/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorScience;
import java.awt.RenderingHints;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;

public class ChannelMixer
extends BlendedOperation {
    private static final String Red = "Red";
    private static final String Green = "Green";
    private static final String Blue = "Blue";
    static final OperationType type = new OperationTypeImpl("Channel Mixer");
    private double red = ColorScience.Wr;
    private double green = ColorScience.Wg;
    private double blue = ColorScience.Wb;

    public ChannelMixer(Rendering rendering) {
        super(rendering, type);
        this.colorInputOnly = true;
        this.addSliderKey(Red);
        this.addSliderKey(Green);
        this.addSliderKey(Blue);
        DecimalFormat format = new DecimalFormat("0.00");
        this.setSliderConfig(Red, new SliderConfig(-2.0, 2.0, this.red, 0.01, false, format));
        this.setSliderConfig(Green, new SliderConfig(-2.0, 2.0, this.green, 0.01, false, format));
        this.setSliderConfig(Blue, new SliderConfig(-2.0, 2.0, this.blue, 0.01, false, format));
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key.equals(Red) && this.red != value) {
            this.red = value;
        } else if (key.equals(Green) && this.green != value) {
            this.green = value;
        } else if (key.equals(Blue) && this.blue != value) {
            this.blue = value;
        } else {
            return;
        }
        super.setSliderValue(key, value);
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new ChannelMixerTransform(source);
    }

    @Override
    public OperationType getType() {
        return type;
    }

    private class ChannelMixerTransform
    extends BlendedOperation.BlendedTransform {
        ChannelMixerTransform(PlanarImage source) {
            super(source);
        }

        @Override
        public PlanarImage setFront() {
            double[][] transform = new double[][]{{ChannelMixer.this.red, ChannelMixer.this.green, ChannelMixer.this.blue, 0.0}, {ChannelMixer.this.red, ChannelMixer.this.green, ChannelMixer.this.blue, 0.0}, {ChannelMixer.this.red, ChannelMixer.this.green, ChannelMixer.this.blue, 0.0}};
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.back);
            pb.add(transform);
            return JAI.create((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
        }
    }
}

