/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.opimage.BilateralFilterRGBOpImage;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import java.awt.image.RenderedImage;
import java.text.DecimalFormat;

public class AdvancedNoiseReductionOperationV4
extends BlendedOperation {
    static final OperationType type = new OperationTypeImpl("Advanced Noise Reduction V4");
    private static final String COLOR_NOISE = "Color_Noise";
    private static final String GRAIN_NOISE = "Grain_Noise";
    private float chroma_domain = 2.0f;
    private float luma_domain = 0.0f;

    public AdvancedNoiseReductionOperationV4(Rendering rendering, OperationType type) {
        super(rendering, type);
        this.colorInputOnly = true;
        DecimalFormat format = new DecimalFormat("0.0");
        this.addSliderKey(COLOR_NOISE);
        this.setSliderConfig(COLOR_NOISE, new SliderConfig(0.0, 20.0, this.chroma_domain, 1.0, false, format));
        this.addSliderKey(GRAIN_NOISE);
        this.setSliderConfig(GRAIN_NOISE, new SliderConfig(0.0, 20.0, this.luma_domain, 1.0, false, format));
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key.equals(COLOR_NOISE)) {
            this.chroma_domain = (float)value;
        } else if (key.equals(GRAIN_NOISE)) {
            this.luma_domain = (float)value;
        } else {
            return;
        }
        super.setSliderValue(key, value);
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new NoiseReduction(source);
    }

    @Override
    public OperationType getType() {
        return type;
    }

    private class NoiseReduction
    extends BlendedOperation.BlendedTransform {
        NoiseReduction(PlanarImage source) {
            super(AdvancedNoiseReductionOperationV4.this, source);
        }

        @Override
        public PlanarImage setFront() {
            if (AdvancedNoiseReductionOperationV4.this.chroma_domain == 0.0f && AdvancedNoiseReductionOperationV4.this.luma_domain == 0.0f) {
                return this.back;
            }
            BorderExtender borderExtender = BorderExtender.createInstance((int)1);
            BilateralFilterRGBOpImage front = new BilateralFilterRGBOpImage((RenderedImage)this.back, borderExtender, null, null, AdvancedNoiseReductionOperationV4.this.luma_domain * AdvancedNoiseReductionOperationV4.this.scale, 0.02f, AdvancedNoiseReductionOperationV4.this.chroma_domain * AdvancedNoiseReductionOperationV4.this.scale, 0.04f);
            front.setProperty("LCPersistentCache", Boolean.TRUE);
            return front;
        }
    }
}

