/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class CropBounds {
    double angle;
    Point2D center;
    double width;
    double height;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CropBounds)) {
            return false;
        }
        CropBounds cropBounds = (CropBounds)o;
        if (this.angle != cropBounds.angle) {
            return false;
        }
        if (this.height != cropBounds.height) {
            return false;
        }
        if (this.width != cropBounds.width) {
            return false;
        }
        return !(this.center != null ? !this.center.equals(cropBounds.center) : cropBounds.center != null);
    }

    public int hashCode() {
        long temp = this.angle != 0.0 ? Double.doubleToLongBits(this.angle) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        result = 29 * result + (this.center != null ? this.center.hashCode() : 0);
        temp = this.width != 0.0 ? Double.doubleToLongBits(this.width) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = this.height != 0.0 ? Double.doubleToLongBits(this.height) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public CropBounds() {
        this(0.0);
    }

    public CropBounds(double angle) {
        this.angle = angle;
    }

    public CropBounds(Rectangle2D rect) {
        this(rect, 0.0);
    }

    public CropBounds(Rectangle2D rect, double angle) {
        this(rect, AffineTransform.getRotateInstance(-angle, rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0));
    }

    public CropBounds(Rectangle2D screenRect, AffineTransform xform) {
        Point2D.Double ul = new Point2D.Double(screenRect.getX(), screenRect.getY());
        Point2D.Double ll = new Point2D.Double(screenRect.getX(), screenRect.getY() + screenRect.getHeight());
        Point2D.Double ur = new Point2D.Double(screenRect.getX() + screenRect.getWidth(), screenRect.getY());
        if (xform != null) {
            try {
                xform.inverseTransform(ul, ul);
                xform.inverseTransform(ll, ll);
                xform.inverseTransform(ur, ur);
            }
            catch (NoninvertibleTransformException e) {
                throw new RuntimeException("Couldn't infer crop bounds", e);
            }
        }
        this.center = new Point2D.Double((((Point2D)ur).getX() + ((Point2D)ll).getX()) / 2.0, (((Point2D)ur).getY() + ((Point2D)ll).getY()) / 2.0);
        double topDx = ((Point2D)ur).getX() - ((Point2D)ul).getX();
        double topDy = ((Point2D)ur).getY() - ((Point2D)ul).getY();
        double leftDx = ((Point2D)ll).getX() - ((Point2D)ul).getX();
        double leftDy = ((Point2D)ll).getY() - ((Point2D)ul).getY();
        this.angle = Math.atan2(topDy, topDx);
        this.width = Math.sqrt(topDx * topDx + topDy * topDy);
        this.height = Math.sqrt(leftDx * leftDx + leftDy * leftDy);
    }

    public CropBounds(CropBounds bounds, double angle) {
        this(bounds.getCenter(), bounds.getWidth(), bounds.getHeight(), angle);
    }

    public CropBounds(Point2D center, double width, double height, double angle) {
        this.center = center != null ? (Point2D)center.clone() : null;
        this.width = width;
        this.height = height;
        this.angle = angle;
    }

    public static CropBounds transform(AffineTransform xform, CropBounds oldBounds) {
        if (oldBounds.isAngleOnly()) {
            double angle = oldBounds.getAngle();
            Point2D.Double origin = new Point2D.Double(0.0, 0.0);
            Point2D.Double unit = new Point2D.Double(Math.cos(angle), Math.sin(angle));
            xform.transform(origin, origin);
            xform.transform(unit, unit);
            double dx = ((Point2D)unit).getX() - ((Point2D)origin).getX();
            double dy = ((Point2D)unit).getY() - ((Point2D)origin).getY();
            angle = Math.atan2(dy, dx);
            return new CropBounds(angle);
        }
        Point2D ul = oldBounds.getUpperLeft();
        Point2D ur = oldBounds.getUpperRight();
        Point2D ll = oldBounds.getLowerLeft();
        Point2D lr = oldBounds.getLowerRight();
        xform.transform(ul, ul);
        xform.transform(ur, ur);
        xform.transform(ll, ll);
        xform.transform(lr, lr);
        return new CropBounds(ul, ur, ll, lr);
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean isAngleOnly() {
        return this.center == null;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Point2D getCenter() {
        if (this.center != null) {
            return (Point2D)this.center.clone();
        }
        return null;
    }

    public CropBounds(Point2D ul, Point2D ur, Point2D ll, Point2D lr) {
        double topDx = ur.getX() - ul.getX();
        double topDy = ur.getY() - ul.getY();
        double leftDx = ll.getX() - ul.getX();
        double leftDy = ll.getY() - ul.getY();
        this.angle = Math.atan2(topDy, topDx);
        this.width = Math.sqrt(topDx * topDx + topDy * topDy);
        this.height = Math.sqrt(leftDx * leftDx + leftDy * leftDy);
        double x = (ul.getX() + lr.getX()) / 2.0;
        double y = (ul.getY() + lr.getY()) / 2.0;
        this.center = new Point2D.Double(x, y);
    }

    public Point2D getUpperLeft() {
        Point2D.Double p = new Point2D.Double(this.center.getX() - this.width / 2.0, this.center.getY() - this.height / 2.0);
        AffineTransform xform = AffineTransform.getRotateInstance(this.angle, this.center.getX(), this.center.getY());
        xform.transform(p, p);
        return p;
    }

    public Point2D getUpperRight() {
        Point2D.Double p = new Point2D.Double(this.center.getX() + this.width / 2.0, this.center.getY() - this.height / 2.0);
        AffineTransform xform = AffineTransform.getRotateInstance(this.angle, this.center.getX(), this.center.getY());
        xform.transform(p, p);
        return p;
    }

    public Point2D getLowerLeft() {
        Point2D.Double p = new Point2D.Double(this.center.getX() - this.width / 2.0, this.center.getY() + this.height / 2.0);
        AffineTransform xform = AffineTransform.getRotateInstance(this.angle, this.center.getX(), this.center.getY());
        xform.transform(p, p);
        return p;
    }

    public Point2D getLowerRight() {
        Point2D.Double p = new Point2D.Double(this.center.getX() + this.width / 2.0, this.center.getY() + this.height / 2.0);
        AffineTransform xform = AffineTransform.getRotateInstance(this.angle, this.center.getX(), this.center.getY());
        xform.transform(p, p);
        return p;
    }

    public CropBounds createInvertedAspect() {
        CropBounds copy = new CropBounds();
        copy.angle = this.angle;
        copy.center = (Point2D)this.center.clone();
        copy.width = this.height;
        copy.height = this.width;
        return copy;
    }
}

