/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.utils;

import com.lightcrafts.jai.utils.LCCachedTile;
import com.lightcrafts.jai.utils.LCTileCacheListener;
import com.lightcrafts.media.jai.util.CacheDiagnostics;
import com.lightcrafts.media.jai.util.ImageUtil;
import com.lightcrafts.mediax.jai.EnumeratedParameter;
import com.lightcrafts.mediax.jai.TileCache;
import com.lightcrafts.mediax.jai.util.ImagingListener;
import com.lightcrafts.utils.LCArrays;
import com.lightcrafts.utils.MemoryLimits;
import com.lightcrafts.utils.cache.Cache;
import com.lightcrafts.utils.cache.CacheObjectBroker;
import com.lightcrafts.utils.cache.CoalescingFreeBlockManager;
import com.lightcrafts.utils.cache.DirectFileCacheStore;
import com.lightcrafts.utils.cache.LRUCacheObjectMap;
import com.lightcrafts.utils.cache.NativeByteBufferAllocator;
import com.lightcrafts.utils.cache.WriteThroughCacheObjectMap;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.prefs.Preferences;

public final class LCTileCache
extends Observable
implements TileCache,
CacheDiagnostics {
    private static final long DEFAULT_MEMORY_CAPACITY = 0x1000000L;
    private static final int DEFAULT_HASHTABLE_CAPACITY = 1009;
    private static final float LOAD_FACTOR = 0.5f;
    private static LCTileCacheListener Listener;
    private Hashtable cache;
    private SortedSet cacheSortedSet;
    private long memoryCapacity;
    private long memoryUsage = 0L;
    private float memoryThreshold = 0.75f;
    private long timeStamp = 0L;
    private Comparator comparator = null;
    private LCCachedTile first = null;
    private LCCachedTile last = null;
    private long tileCount = 0L;
    private long hitCount = 0L;
    private long missCount = 0L;
    private boolean diagnostics;
    private Cache m_objectCache;
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private static final int REMOVE_FROM_FLUSH = 2;
    private static final int REMOVE_FROM_MEMCON = 3;
    private static final int UPDATE_FROM_ADD = 4;
    private static final int UPDATE_FROM_GETTILE = 5;
    private static final int ABOUT_TO_REMOVE = 6;
    private static final int REMOVE_FROM_GCEVENT = 7;
    private static final Preferences Prefs;
    private static final String CacheDirKey = "ScratchDirectory";
    private File tmpFile = null;
    private static final int CHUNK_SIZE = 0x1000000;
    private long tilesWritten = 0L;
    private long tilesRead = 0L;
    private long tilesOnDisk = 0L;
    private final Map m_imageMap = new HashMap();
    private TileReaper m_tileReaper;

    public static EnumeratedParameter[] getCachedTileActions() {
        return new EnumeratedParameter[]{new EnumeratedParameter("add", 0), new EnumeratedParameter("remove", 1), new EnumeratedParameter("remove_by_flush", 2), new EnumeratedParameter("remove_by_memorycontrol", 3), new EnumeratedParameter("remove_by_gcevent", 7), new EnumeratedParameter("timestamp_update_by_add", 4), new EnumeratedParameter("timestamp_update_by_gettile", 5), new EnumeratedParameter("preremove", 6)};
    }

    public static synchronized void setListener(LCTileCacheListener listener) {
        Listener = listener;
    }

    public LCTileCache(boolean useDisk) {
        this(0x1000000L, useDisk);
    }

    public LCTileCache(long memoryCapacity, boolean useDisk) {
        if (memoryCapacity < 0L) {
            throw new IllegalArgumentException("memory capacity must be >= 0");
        }
        this.memoryCapacity = memoryCapacity;
        this.cache = new Hashtable(1009, 0.5f);
        if (useDisk) {
            this.m_objectCache = this.createDiskCache();
            this.m_tileReaper = new TileReaper(this);
            this.m_tileReaper.start();
        }
    }

    public void add(RenderedImage owner, int tileX, int tileY, Raster tile) {
        this.add(owner, tileX, tileY, tile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(RenderedImage owner, int tileX, int tileY, Raster tile, Object tileCacheMetric) {
        if (this.memoryCapacity == 0L) {
            return;
        }
        Object key = LCCachedTile.hashKey(owner, tileX, tileY);
        LCCachedTile ct = (LCCachedTile)this.cache.get(key);
        if (ct != null) {
            this.updateTileList(ct, 4);
        } else {
            ct = new LCCachedTile(owner, tileX, tileY, tile, tileCacheMetric);
            ct.timeStamp = this.timeStamp++;
            ct.previous = null;
            ct.next = this.first;
            if (this.first == null && this.last == null) {
                this.first = ct;
                this.last = ct;
            } else {
                this.first.previous = ct;
                this.first = ct;
            }
            if (this.cache.put(ct.key, ct) == null) {
                this.memoryUsage += ct.memorySize;
                ++this.tileCount;
                if (this.cacheSortedSet != null) {
                    this.cacheSortedSet.add(ct);
                }
                if (this.diagnostics) {
                    ct.action = 0;
                    this.setChanged();
                    this.notifyObservers(ct);
                }
            }
            if (this.memoryUsage > this.memoryCapacity) {
                this.memoryControl();
            }
        }
        if (this.m_tileReaper != null) {
            LCTileCache lCTileCache = this;
            synchronized (lCTileCache) {
                HashSet<Object> hashKeys;
                WeakReference<RenderedImage> weakKey = null;
                Set keySet = this.m_imageMap.keySet();
                for (WeakReference<RenderedImage> ref : keySet) {
                    if (ref.get() != owner) continue;
                    weakKey = ref;
                    break;
                }
                if (weakKey == null) {
                    weakKey = new WeakReference<RenderedImage>(owner, this.m_tileReaper.getRefQ());
                }
                if ((hashKeys = (HashSet<Object>)this.m_imageMap.get(weakKey)) == null) {
                    hashKeys = new HashSet<Object>();
                    this.m_imageMap.put(weakKey, hashKeys);
                }
                hashKeys.add(key);
            }
        }
    }

    private boolean removeFromTileList(Object key, int action) {
        LCCachedTile ct = (LCCachedTile)this.cache.remove(key);
        if (ct != null) {
            this.memoryUsage -= ct.memorySize;
            --this.tileCount;
            if (this.cacheSortedSet != null) {
                this.cacheSortedSet.remove(ct);
            }
            if (ct == this.first) {
                if (ct == this.last) {
                    this.first = null;
                    this.last = null;
                } else {
                    this.first = ct.next;
                    this.first.previous = null;
                }
            } else if (ct == this.last) {
                this.last = ct.previous;
                this.last.next = null;
            } else {
                ct.previous.next = ct.next;
                ct.next.previous = ct.previous;
            }
            if (this.diagnostics) {
                ct.action = action;
                this.setChanged();
                this.notifyObservers(ct);
            }
            ct.previous = null;
            ct.next = null;
            ct = null;
            return true;
        }
        return false;
    }

    private void updateTileList(LCCachedTile ct, int action) {
        ct.timeStamp = this.timeStamp++;
        if (ct != this.first) {
            if (ct == this.last) {
                this.last = ct.previous;
                this.last.next = null;
            } else {
                ct.previous.next = ct.next;
                ct.next.previous = ct.previous;
            }
            ct.previous = null;
            ct.next = this.first;
            this.first.previous = ct;
            this.first = ct;
        }
        ++this.hitCount;
        if (this.diagnostics) {
            ct.action = action;
            this.setChanged();
            this.notifyObservers(ct);
        }
    }

    public synchronized void remove(RenderedImage owner, int tileX, int tileY) {
        if (this.memoryCapacity == 0L) {
            return;
        }
        Object key = LCCachedTile.hashKey(owner, tileX, tileY);
        LCCachedTile ct = (LCCachedTile)this.cache.get(key);
        if (ct != null) {
            ct.action = 6;
            this.setChanged();
            this.notifyObservers(ct);
            this.removeFromTileList(key, 1);
        } else if (this.m_objectCache != null && this.m_objectCache.contains(key)) {
            this.m_objectCache.remove(key);
            --this.tilesOnDisk;
        }
    }

    public synchronized Raster getTile(RenderedImage owner, int tileX, int tileY) {
        Raster raster;
        if (this.memoryCapacity == 0L) {
            return null;
        }
        Object key = LCCachedTile.hashKey(owner, tileX, tileY);
        LCCachedTile ct = (LCCachedTile)this.cache.get(key);
        if (this.m_objectCache != null && ct == null && (raster = this.readTileFromDisk(owner, tileX, tileY, key)) != null) {
            this.add(owner, tileX, tileY, raster, null);
            ct = (LCCachedTile)this.cache.get(key);
            assert (ct != null);
        }
        Raster tile = null;
        if (ct == null) {
            ++this.missCount;
        } else {
            tile = ct.getTile();
            this.updateTileList(ct, 5);
        }
        return tile;
    }

    public synchronized Raster[] getTiles(RenderedImage owner) {
        Raster[] tiles = null;
        if (this.memoryCapacity == 0L) {
            return null;
        }
        int size = Math.min(owner.getNumXTiles() * owner.getNumYTiles(), (int)this.tileCount);
        if (size > 0) {
            int minTx = owner.getMinTileX();
            int minTy = owner.getMinTileY();
            int maxTx = minTx + owner.getNumXTiles();
            int maxTy = minTy + owner.getNumYTiles();
            Vector<Raster> temp = new Vector<Raster>(10, 20);
            for (int y = minTy; y < maxTy; ++y) {
                for (int x = minTx; x < maxTx; ++x) {
                    Raster raster = this.getTile(owner, x, y);
                    if (raster == null) continue;
                    temp.add(raster);
                }
            }
            int tmpsize = temp.size();
            if (tmpsize > 0) {
                tiles = temp.toArray(new Raster[tmpsize]);
            }
        }
        return tiles;
    }

    public void removeTiles(RenderedImage owner) {
        if (this.memoryCapacity > 0L) {
            int minTx = owner.getMinTileX();
            int minTy = owner.getMinTileY();
            int maxTx = minTx + owner.getNumXTiles();
            int maxTy = minTy + owner.getNumYTiles();
            for (int y = minTy; y < maxTy; ++y) {
                for (int x = minTx; x < maxTx; ++x) {
                    this.remove(owner, x, y);
                }
            }
        }
    }

    public synchronized void addTiles(RenderedImage owner, Point[] tileIndices, Raster[] tiles, Object tileCacheMetric) {
        if (this.memoryCapacity == 0L) {
            return;
        }
        for (int i = 0; i < tileIndices.length; ++i) {
            int tileX = tileIndices[i].x;
            int tileY = tileIndices[i].y;
            Raster tile = tiles[i];
            this.add(owner, tileX, tileY, tile, tileCacheMetric);
        }
    }

    public synchronized Raster[] getTiles(RenderedImage owner, Point[] tileIndices) {
        if (this.memoryCapacity == 0L) {
            return null;
        }
        Raster[] tiles = new Raster[tileIndices.length];
        for (int i = 0; i < tiles.length; ++i) {
            int tileX = tileIndices[i].x;
            int tileY = tileIndices[i].y;
            tiles[i] = this.getTile(owner, tileX, tileY);
        }
        return tiles;
    }

    public synchronized void flush() {
        if (Listener != null) {
            Listener.tileCacheFlushed();
        }
        if (this.m_objectCache != null) {
            System.err.println("flushing the cache");
            float mt = this.memoryThreshold;
            this.memoryThreshold = 0.1f;
            this.memoryControl();
            this.memoryThreshold = mt;
            return;
        }
        Enumeration keys = this.cache.keys();
        this.hitCount = 0L;
        this.missCount = 0L;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            this.removeFromTileList(key, 2);
        }
        if (this.memoryCapacity > 0L) {
            this.cache = new Hashtable(1009, 0.5f);
        }
        if (this.cacheSortedSet != null) {
            this.cacheSortedSet.clear();
            this.cacheSortedSet = Collections.synchronizedSortedSet(new TreeSet(this.comparator));
        }
        this.tileCount = 0L;
        this.timeStamp = 0L;
        this.memoryUsage = 0L;
    }

    public int getTileCapacity() {
        return 0;
    }

    public void setTileCapacity(int tileCapacity) {
    }

    public long getMemoryCapacity() {
        return this.memoryCapacity;
    }

    public void setMemoryCapacity(long memoryCapacity) {
        if (memoryCapacity < 0L) {
            throw new IllegalArgumentException("memory capacity must be >= 0");
        }
        if (memoryCapacity == 0L) {
            this.flush();
        }
        this.memoryCapacity = memoryCapacity;
        if (this.memoryUsage > memoryCapacity) {
            this.memoryControl();
        }
    }

    public void enableDiagnostics() {
        this.diagnostics = true;
    }

    public void disableDiagnostics() {
        this.diagnostics = false;
    }

    public long getCacheTileCount() {
        return this.tileCount;
    }

    public long getCacheMemoryUsed() {
        return this.memoryUsage;
    }

    public long getCacheHitCount() {
        return this.hitCount;
    }

    public long getCacheMissCount() {
        return this.missCount;
    }

    public void resetCounts() {
        this.hitCount = 0L;
        this.missCount = 0L;
    }

    public void setMemoryThreshold(float mt) {
        if (mt < 0.0f || mt > 1.0f) {
            throw new IllegalArgumentException("memory threshold must be between 0 and 1");
        }
        this.memoryThreshold = mt;
        this.memoryControl();
    }

    public float getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": memoryCapacity = " + Long.toHexString(this.memoryCapacity) + " memoryUsage = " + Long.toHexString(this.memoryUsage) + " #tilesInCache = " + Integer.toString(this.cache.size());
    }

    public Object getCachedObject() {
        return this.cache;
    }

    public synchronized void memoryControl() {
        if (this.cacheSortedSet == null) {
            this.standard_memory_control();
        } else {
            this.custom_memory_control();
        }
    }

    private final void standard_memory_control() {
        long limit = (long)((float)this.memoryCapacity * this.memoryThreshold);
        while (this.memoryUsage > limit && this.last != null) {
            LCCachedTile ct = (LCCachedTile)this.cache.get(this.last.key);
            if (ct == null) continue;
            RenderedImage owner = ct.getOwner();
            if (owner != null && owner.getProperty("LCPersistentCache") == Boolean.TRUE && this.m_objectCache != null) {
                this.writeTileToDisk(ct, this.last.key);
            }
            this.removeFromTileList(this.last.key, 3);
        }
    }

    private Cache createDiskCache() {
        try {
            File tmpDir;
            String path = Prefs.get(CacheDirKey, null);
            this.tmpFile = null;
            if (path != null && (tmpDir = new File(path)).isDirectory() && tmpDir.canWrite()) {
                this.tmpFile = File.createTempFile("LCCacheFile", ".cce", tmpDir);
            }
            if (this.tmpFile == null) {
                this.tmpFile = File.createTempFile("LCCacheFile", ".cce");
            }
            this.tmpFile.deleteOnExit();
            File[] oldCacheFiles = this.tmpFile.getParentFile().listFiles(new CacheFileFilter(this.tmpFile));
            if (oldCacheFiles != null) {
                for (int i = 0; i < oldCacheFiles.length; ++i) {
                    oldCacheFiles[i].delete();
                }
            }
            int defaultMemorySize = MemoryLimits.getDefault();
            Preferences prefs = Preferences.userRoot().node("/com/lightcrafts/app");
            long maxMemory = (long)prefs.getInt("MaxMemory", defaultMemorySize) * 1024L * 1024L;
            long maxHeap = Runtime.getRuntime().maxMemory();
            long extraCacheSize = Math.max(maxMemory - maxHeap, 0L);
            System.out.println("Allocating " + extraCacheSize / 0x100000L + "MB for the image cache.");
            return new Cache(new TileCacheCacheObjectBroker(), extraCacheSize < 0x8000000L ? new WriteThroughCacheObjectMap() : new LRUCacheObjectMap(new NativeByteBufferAllocator(0x1000000), extraCacheSize), new DirectFileCacheStore(this.tmpFile), new CoalescingFreeBlockManager());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized void dispose() throws IOException {
        this.m_objectCache.dispose();
        if (this.m_tileReaper != null) {
            this.m_tileReaper.kill();
        }
        if (this.tmpFile != null) {
            this.tmpFile.delete();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public long tilesWritten() {
        return this.tilesWritten;
    }

    public long tilesRead() {
        return this.tilesRead;
    }

    public long tilesOnDisk() {
        return this.tilesOnDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Raster readTileFromDisk(RenderedImage owner, int tileX, int tileY, Object key) {
        if (this.m_objectCache.contains(key)) {
            SampleModel sm = owner.getSampleModel();
            DataBuffer db = sm.createDataBuffer();
            try {
                switch (db.getDataType()) {
                    case 0: {
                        this.m_objectCache.getOnce(key, ((DataBufferByte)db).getData());
                        break;
                    }
                    case 1: {
                        this.m_objectCache.getOnce(key, ((DataBufferUShort)db).getData());
                        break;
                    }
                    case 3: {
                        this.m_objectCache.getOnce(key, ((DataBufferInt)db).getData());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported image type " + db.getClass());
                    }
                }
                LCTileCache lCTileCache = this;
                synchronized (lCTileCache) {
                    --this.tilesOnDisk;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            WritableRaster raster = Raster.createWritableRaster(sm, db, new Point(tileX * owner.getTileWidth(), tileY * owner.getTileHeight()));
            LCTileCache lCTileCache = this;
            synchronized (lCTileCache) {
                ++this.tilesRead;
            }
            return raster;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTileToDisk(LCCachedTile ct, Object key) {
        LCTileCache lCTileCache;
        Raster raster = ct.getTile();
        DataBuffer db = raster.getDataBuffer();
        try {
            switch (db.getDataType()) {
                case 0: {
                    this.m_objectCache.put(key, ((DataBufferByte)db).getData());
                    break;
                }
                case 1: {
                    this.m_objectCache.put(key, ((DataBufferUShort)db).getData());
                    break;
                }
                case 3: {
                    this.m_objectCache.put(key, ((DataBufferInt)db).getData());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported image type " + db.getClass());
                }
            }
            lCTileCache = this;
            synchronized (lCTileCache) {
                ++this.tilesOnDisk;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        lCTileCache = this;
        synchronized (lCTileCache) {
            ++this.tilesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void custom_memory_control() {
        long limit = (long)((float)this.memoryCapacity * this.memoryThreshold);
        Iterator iter = this.cacheSortedSet.iterator();
        while (iter.hasNext() && this.memoryUsage > limit) {
            LCCachedTile ct;
            block15: {
                block13: {
                    block14: {
                        ct = (LCCachedTile)iter.next();
                        this.memoryUsage -= ct.memorySize;
                        LCTileCache lCTileCache = this;
                        synchronized (lCTileCache) {
                            --this.tileCount;
                        }
                        try {
                            iter.remove();
                        }
                        catch (ConcurrentModificationException e) {
                            ImagingListener listener = ImageUtil.getImagingListener((RenderingHints)null);
                            listener.errorOccurred("something wrong with the TileCache", (Throwable)e, (Object)this, false);
                        }
                        if (ct != this.first) break block13;
                        if (ct != this.last) break block14;
                        this.first = null;
                        this.last = null;
                        break block15;
                    }
                    this.first = ct.next;
                    if (this.first == null) break block15;
                    this.first.previous = null;
                    this.first.next = ct.next.next;
                    break block15;
                }
                if (ct == this.last) {
                    this.last = ct.previous;
                    if (this.last != null) {
                        this.last.next = null;
                        this.last.previous = ct.previous.previous;
                    }
                } else {
                    LCCachedTile ptr = this.first.next;
                    while (ptr != null) {
                        if (ptr == ct) {
                            if (ptr.previous != null) {
                                ptr.previous.next = ptr.next;
                            }
                            if (ptr.next == null) break;
                            ptr.next.previous = ptr.previous;
                            break;
                        }
                        ptr = ptr.next;
                    }
                }
            }
            this.cache.remove(ct.key);
            if (!this.diagnostics) continue;
            ct.action = 3;
            this.setChanged();
            this.notifyObservers(ct);
        }
        if (this.memoryUsage > limit) {
            this.standard_memory_control();
        }
    }

    public synchronized void setTileComparator(Comparator c) {
        if (this.comparator != null) {
            throw new IllegalArgumentException("TileComparator not supported by LCTileCache");
        }
        this.comparator = c;
        if (this.comparator == null) {
            if (this.cacheSortedSet != null) {
                this.cacheSortedSet.clear();
                this.cacheSortedSet = null;
            }
        } else {
            this.cacheSortedSet = Collections.synchronizedSortedSet(new TreeSet(this.comparator));
            Enumeration keys = this.cache.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object ct = this.cache.get(key);
                this.cacheSortedSet.add(ct);
            }
        }
    }

    public Comparator getTileComparator() {
        return this.comparator;
    }

    public void dump() {
        System.out.println("first = " + this.first);
        System.out.println("last  = " + this.last);
        Iterator iter = this.cacheSortedSet.iterator();
        int k = 0;
        while (iter.hasNext()) {
            LCCachedTile ct = (LCCachedTile)iter.next();
            System.out.println(k++);
            System.out.println(ct);
        }
    }

    void sendExceptionToListener(String message, Exception e) {
        ImagingListener listener = ImageUtil.getImagingListener((RenderingHints)null);
        listener.errorOccurred(message, (Throwable)e, (Object)this, false);
    }

    static {
        Prefs = Preferences.userNodeForPackage(LCTileCache.class);
    }

    private static final class TileReaper
    extends Thread {
        private boolean m_killed;
        private final ReferenceQueue m_refQ;
        private final WeakReference m_tileCacheRef;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.m_killed) {
                try {
                    Reference weakKey = this.m_refQ.remove();
                    LCTileCache tileCache = (LCTileCache)this.m_tileCacheRef.get();
                    if (tileCache != null) {
                        LCTileCache lCTileCache = tileCache;
                        synchronized (lCTileCache) {
                            Set hashKeys = (Set)tileCache.m_imageMap.remove(weakKey);
                            assert (hashKeys != null);
                            for (Object o : hashKeys) {
                                if (tileCache.removeFromTileList(o, 7)) {
                                    // empty if block
                                }
                                if (!tileCache.m_objectCache.remove(o)) continue;
                                LCTileCache lCTileCache2 = tileCache;
                                synchronized (lCTileCache2) {
                                    tileCache.tilesOnDisk--;
                                }
                            }
                            continue;
                        }
                    }
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        TileReaper(LCTileCache tileCache) {
            super("TileReaper");
            this.setDaemon(true);
            this.m_refQ = new ReferenceQueue();
            this.m_tileCacheRef = new WeakReference<LCTileCache>(tileCache);
        }

        ReferenceQueue getRefQ() {
            return this.m_refQ;
        }

        void kill() {
            this.m_killed = true;
            this.interrupt();
        }
    }

    static class CacheFileFilter
    implements FilenameFilter {
        File goodFile;

        CacheFileFilter(File goodFile) {
            this.goodFile = goodFile;
        }

        @Override
        public boolean accept(File dir, String name) {
            return !name.equals(this.goodFile.getName()) && name.startsWith("LCCacheFile") && name.endsWith(".cce");
        }
    }

    private static class TileCacheCacheObjectBroker
    implements CacheObjectBroker {
        private TileCacheCacheObjectBroker() {
        }

        @Override
        public int getEncodedSizeOf(Object obj) {
            if (obj instanceof byte[]) {
                byte[] ba = (byte[])obj;
                return ba.length;
            }
            if (obj instanceof short[]) {
                short[] sa = (short[])obj;
                return sa.length * 2;
            }
            if (obj instanceof int[]) {
                int[] ia = (int[])obj;
                return ia.length * 4;
            }
            throw new IllegalArgumentException("can't get size of " + obj.getClass());
        }

        @Override
        public Object decodeFromByteBuffer(ByteBuffer buf, Object obj) {
            if (obj instanceof byte[]) {
                if (buf.hasArray()) {
                    LCArrays.copy(buf.array(), 0, (byte[])obj, 0, buf.capacity());
                } else {
                    buf.get((byte[])obj);
                }
            } else if (obj instanceof short[]) {
                if (buf.hasArray()) {
                    LCArrays.copy(buf.array(), 0, (short[])obj, 0, buf.capacity());
                } else {
                    buf.asShortBuffer().get((short[])obj);
                }
            } else if (obj instanceof int[]) {
                if (buf.hasArray()) {
                    LCArrays.copy(buf.array(), 0, (int[])obj, 0, buf.capacity());
                } else {
                    buf.asIntBuffer().get((int[])obj);
                }
            } else {
                throw new IllegalArgumentException("can't decode " + obj.getClass());
            }
            return obj;
        }

        @Override
        public void encodeToByteBuffer(ByteBuffer buf, Object obj) {
            if (obj instanceof byte[]) {
                if (buf.hasArray()) {
                    LCArrays.copy((byte[])obj, 0, buf.array(), 0, buf.capacity());
                } else {
                    buf.put((byte[])obj);
                }
            } else if (obj instanceof short[]) {
                if (buf.hasArray()) {
                    LCArrays.copy((short[])obj, 0, buf.array(), 0, buf.capacity());
                } else {
                    buf.asShortBuffer().put((short[])obj);
                }
            } else if (obj instanceof int[]) {
                if (buf.hasArray()) {
                    LCArrays.copy((int[])obj, 0, buf.array(), 0, buf.capacity());
                } else {
                    buf.asIntBuffer().put((int[])obj);
                }
            } else {
                throw new IllegalArgumentException("can't encode " + obj.getClass());
            }
        }
    }
}

