/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

public class RawAdjustmentsOpImage
extends PointOpImage {
    private float exposureCompensation;
    private float[][] cameraRGB;

    public RawAdjustmentsOpImage(RenderedImage source, Map config, ImageLayout layout, float exposureCompensation, float colorTemperature, float[][] cameraRGB) {
        super(source, layout, config, true);
        this.exposureCompensation = exposureCompensation;
        this.cameraRGB = cameraRGB;
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        switch (dstAccessor.getDataType()) {
            case 1: {
                this.ushortLoop(srcAccessor, dstAccessor);
                break;
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstLineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcLineStride = src.getScanlineStride();
        short[] dstData = dstDataArrays[0];
        short[] srcData = srcDataArrays[0];
        int srcROffset = srcBandOffsets[0];
        int srcGOffset = srcBandOffsets[1];
        int srcBOffset = srcBandOffsets[2];
        int dstROffset = dstBandOffsets[0];
        int dstGOffset = dstBandOffsets[1];
        int dstBOffset = dstBandOffsets[2];
        float t00 = this.cameraRGB[0][0];
        float t01 = this.cameraRGB[0][1];
        float t02 = this.cameraRGB[0][2];
        float t10 = this.cameraRGB[1][0];
        float t11 = this.cameraRGB[1][1];
        float t12 = this.cameraRGB[1][2];
        float t20 = this.cameraRGB[2][0];
        float t21 = this.cameraRGB[2][1];
        float t22 = this.cameraRGB[2][2];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int r = 0xFFFF & srcData[3 * col + row * srcLineStride + srcROffset];
                int g = 0xFFFF & srcData[3 * col + row * srcLineStride + srcGOffset];
                int b = 0xFFFF & srcData[3 * col + row * srcLineStride + srcBOffset];
                float r1 = t00 * (float)r + t01 * (float)g + t02 * (float)b;
                float g1 = t10 * (float)r + t11 * (float)g + t12 * (float)b;
                float b1 = t20 * (float)r + t21 * (float)g + t22 * (float)b;
                float c = this.exposureCompensation;
                if (c < 1.0f && (g1 > 65535.0f || r1 > 65535.0f || b1 > 65535.0f)) {
                    float rs = Math.min(r1, 65535.0f);
                    float gs = Math.min(g1, 65535.0f);
                    float bs = Math.min(b1, 65535.0f);
                    float c1s = gs - rs;
                    float c2s = gs - bs;
                    r1 = c * (g1 - c1s);
                    b1 = c * (g1 - c2s);
                } else {
                    r1 *= c;
                    b1 *= c;
                }
                dstData[3 * col + row * dstLineStride + dstROffset] = (short)(r1 < 0.0f ? 0 : (r1 > 65535.0f ? 65535 : (int)r1));
                dstData[3 * col + row * dstLineStride + dstGOffset] = (short)(g1 < 0.0f ? 0 : (g1 > 65535.0f ? 65535 : (int)(g1 *= c)));
                dstData[3 * col + row * dstLineStride + dstBOffset] = (short)(b1 < 0.0f ? 0 : (b1 > 65535.0f ? 65535 : (int)b1));
            }
        }
    }
}

