/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

public class HighlightRecoveryOpImage
extends PointOpImage {
    private final float[] preMul;
    private final float[][] csMatrix;

    public HighlightRecoveryOpImage(RenderedImage source, float[] preMul, float[][] csMatrix, Map config) {
        super(source, new ImageLayout(source), config, true);
        this.permitInPlaceOperation();
        this.preMul = preMul;
        this.csMatrix = csMatrix;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        this.ushortLoop(srcAccessor, dstAccessor);
    }

    private native void floatNativeUshortLoop(short[] var1, short[] var2, int[] var3, int[] var4, int var5, int var6, int var7, int var8, int var9, int var10, float[] var11, float[] var12);

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        short[][] dstDataArrays = dst.getShortDataArrays();
        short[] dstData = dstDataArrays[0];
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[] srcData = srcDataArrays[0];
        int[] srcBandOffsets = src.getBandOffsets();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        float[] csArray = new float[9];
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(this.csMatrix[i], 0, csArray, 3 * i, 3);
        }
        this.floatNativeUshortLoop(srcData, dstData, dstBandOffsets, srcBandOffsets, dstLineStride, srcLineStride, dstPixelStride, srcPixelStride, width, height, this.preMul, csArray);
    }
}

