/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.types.JPEGParserEventHandler;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;

public final class JPEGParser {
    public static void parse(JPEGParserEventHandler handler, File jpegFile, LCByteBuffer buf) throws BadImageFileException, IOException {
        try {
            buf.position(2);
            while (true) {
                int segLength;
                byte segID;
                byte b;
                if ((b = buf.get()) != -1) {
                    throw new BadImageFileException(jpegFile, "JPEG marker byte (0xFF) expected; got: 0x" + Integer.toHexString(b & 0xFF));
                }
                while ((segID = buf.get()) == -1) {
                }
                switch (segID) {
                    case -39: {
                        return;
                    }
                    case -38: {
                        segLength = 0;
                        break;
                    }
                    default: {
                        segLength = buf.getUnsignedShort() - 2;
                        int segRemaining = buf.remaining();
                        if (segLength <= segRemaining) break;
                        throw new BadImageFileException(jpegFile, "JPEG segment length (" + segLength + ") > actual length (" + segRemaining + ')');
                    }
                }
                int savedPos = buf.position();
                boolean continueParsing = handler.gotSegment(segID, segLength, jpegFile, buf);
                if (segID != -38 && continueParsing) {
                    buf.position(savedPos + segLength);
                    continue;
                }
                break;
            }
        }
        catch (BufferUnderflowException e) {
            throw new BadImageFileException(jpegFile, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadImageFileException(jpegFile, (Throwable)e);
        }
    }
}

