/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadColorProfileException;
import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ColorProfileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.export.ImageExportOptionReader;
import com.lightcrafts.image.export.ImageExportOptionWriter;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.export.QualityOption;
import com.lightcrafts.image.libs.InputStreamImageDataProvider;
import com.lightcrafts.image.libs.LCImageLibException;
import com.lightcrafts.image.libs.LCJPEGReader;
import com.lightcrafts.image.libs.LCJPEGWriter;
import com.lightcrafts.image.metadata.CoreDirectory;
import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.EXIFEncoder;
import com.lightcrafts.image.metadata.EXIFMetadataReader;
import com.lightcrafts.image.metadata.IPTCDirectory;
import com.lightcrafts.image.metadata.IPTCMetadataReader;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.image.metadata.SubEXIFDirectory;
import com.lightcrafts.image.metadata.XMPMetadataReader;
import com.lightcrafts.image.metadata.XMPUtil;
import com.lightcrafts.image.metadata.providers.PreviewImageProvider;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.types.AuxiliaryImageInfo;
import com.lightcrafts.image.types.EXIFJPEGSegmentFilter;
import com.lightcrafts.image.types.ICCProfileJPEGSegmentFilter;
import com.lightcrafts.image.types.IPTCJPEGSegmentFilter;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGConstants;
import com.lightcrafts.image.types.JPEGImageInfo;
import com.lightcrafts.image.types.JPEGParser;
import com.lightcrafts.image.types.JPEGParserEventHandler;
import com.lightcrafts.image.types.JPEGSegmentFilter;
import com.lightcrafts.image.types.NotJPEGSegmentFilter;
import com.lightcrafts.image.types.OrJPEGSegmentFilter;
import com.lightcrafts.image.types.SidecarJPEGImageType;
import com.lightcrafts.image.types.TrueImageTypeProvider;
import com.lightcrafts.image.types.XMPJPEGSegmentFilter;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.opimage.CachedImage;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.utils.ColorProfileInfo;
import com.lightcrafts.utils.UserCanceledException;
import com.lightcrafts.utils.bytebuffer.ArrayByteBuffer;
import com.lightcrafts.utils.bytebuffer.ByteBufferUtil;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import com.lightcrafts.utils.bytebuffer.LCMappedByteBuffer;
import com.lightcrafts.utils.file.FileUtil;
import com.lightcrafts.utils.thread.ProgressThread;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XMLUtil;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import org.w3c.dom.Document;

public class JPEGImageType
extends ImageType
implements TrueImageTypeProvider {
    public static final JPEGImageType INSTANCE = new JPEGImageType();
    private static final String[] EXTENSIONS = new String[]{"jpg", "jpe", "jpeg"};
    private static final short NO_META_VALUE = 0;

    @Override
    public boolean canExport() {
        return true;
    }

    public static List<ByteBuffer> getAllSegments(ImageInfo imageInfo, byte segID) throws BadImageFileException, IOException, UnknownImageTypeException {
        return JPEGImageType.getAllSegments(imageInfo, segID, null);
    }

    public static List<ByteBuffer> getAllSegments(ImageInfo imageInfo, byte segID, JPEGSegmentFilter filter) throws BadImageFileException, IOException, UnknownImageTypeException {
        AuxiliaryImageInfo auxInfo = imageInfo.getAuxiliaryInfo();
        if (!(auxInfo instanceof JPEGImageInfo)) {
            return null;
        }
        JPEGImageInfo jpegInfo = (JPEGImageInfo)auxInfo;
        return jpegInfo.getAllSegmentsFor(segID, filter);
    }

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    public static ByteBuffer getFirstSegment(ImageInfo imageInfo, byte segID) throws BadImageFileException, IOException, UnknownImageTypeException {
        return JPEGImageType.getFirstSegment(imageInfo, segID, null);
    }

    public static ByteBuffer getFirstSegment(ImageInfo imageInfo, byte segID, JPEGSegmentFilter filter) throws BadImageFileException, IOException, UnknownImageTypeException {
        AuxiliaryImageInfo auxInfo = imageInfo.getAuxiliaryInfo();
        if (!(auxInfo instanceof JPEGImageInfo)) {
            return null;
        }
        JPEGImageInfo jpegInfo = (JPEGImageInfo)auxInfo;
        return jpegInfo.getFirstSegmentFor(segID, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getDimension(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        Dimension d = null;
        try {
            LCJPEGReader reader = null;
            try {
                String path = imageInfo.getFile().getAbsolutePath();
                reader = new LCJPEGReader(path);
                d = new Dimension(reader.getWidth(), reader.getHeight());
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
        }
        catch (LCImageLibException lCImageLibException) {
            // empty catch block
        }
        return d;
    }

    @Override
    public ICC_Profile getICCProfile(ImageInfo imageInfo) throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException {
        byte[] iccProfileData;
        List<ByteBuffer> iccSegBufs = JPEGImageType.getAllSegments(imageInfo, (byte)-30, new ICCProfileJPEGSegmentFilter());
        if (iccSegBufs == null) {
            String path = imageInfo.getFile().getAbsolutePath();
            try {
                switch (new LCJPEGReader(path).getColorsPerPixel()) {
                    case 1: {
                        return JAIContext.gray22Profile;
                    }
                    case 3: {
                        return JPEGImageType.getICCProfileFromEXIF(imageInfo);
                    }
                    case 4: {
                        return JAIContext.CMYKProfile;
                    }
                }
                throw new BadColorProfileException(path);
            }
            catch (LCImageLibException lCImageLibException) {
                // empty catch block
            }
        }
        try {
            iccProfileData = JPEGImageType.assembleICCProfile(iccSegBufs);
        }
        catch (BufferUnderflowException e) {
            throw new BadImageFileException(imageInfo.getFile());
        }
        catch (IllegalArgumentException e) {
            throw new BadImageFileException(imageInfo.getFile());
        }
        try {
            return ICC_Profile.getInstance(iccProfileData);
        }
        catch (IllegalArgumentException e) {
            throw new BadColorProfileException(imageInfo.getFile().getName());
        }
    }

    @Override
    public PlanarImage getImage(ImageInfo imageInfo, ProgressThread thread) throws BadImageFileException, IOException, UserCanceledException, UnknownImageTypeException {
        return this.getImage(imageInfo, thread, 0, 0);
    }

    public PlanarImage getImage(ImageInfo imageInfo, ProgressThread thread, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UserCanceledException, UnknownImageTypeException {
        try {
            ICC_Profile profile;
            try {
                profile = this.getICCProfile(imageInfo);
            }
            catch (ColorProfileException e) {
                profile = null;
            }
            LCJPEGReader reader = new LCJPEGReader(imageInfo.getFile().getAbsolutePath(), maxWidth, maxHeight, (JPEGImageInfo)imageInfo.getAuxiliaryInfo());
            PlanarImage image = reader.getImage(thread, profile != null ? new ICC_ColorSpace(profile) : null);
            assert (image instanceof CachedImage && image.getTileWidth() == 512 && image.getTileHeight() == 512);
            return image;
        }
        catch (LCImageLibException e) {
            throw new BadImageFileException(imageInfo.getFile(), (Throwable)e);
        }
    }

    public static RenderedImage getImageFromBuffer(byte[] buf, int offset, int length, ColorSpace cs, int maxWidth, int maxHeight) throws BadImageFileException {
        ByteArrayInputStream is = new ByteArrayInputStream(buf, offset, length);
        return JPEGImageType.getImageFromInputStream(is, cs, maxWidth, maxHeight);
    }

    public static RenderedImage getImageFromBuffer(LCByteBuffer buf, ImageMetaValue offsetValue, int offsetAdjustment, ImageMetaValue lengthValue, int maxWidth, int maxHeight) throws BadImageFileException {
        return JPEGImageType.getImageFromBuffer(buf, offsetValue, offsetAdjustment, lengthValue, null, maxWidth, maxHeight);
    }

    public static RenderedImage getImageFromBuffer(LCByteBuffer buf, ImageMetaValue offsetValue, int offsetAdjustment, ImageMetaValue lengthValue, ColorSpace cs, int maxWidth, int maxHeight) throws BadImageFileException {
        if (buf == null || offsetValue == null || lengthValue == null) {
            return null;
        }
        int offset = offsetValue.getIntValue();
        int length = lengthValue.getIntValue();
        if (offset < 0 || length <= 0) {
            return null;
        }
        return JPEGImageType.getImageFromBuffer(buf, offset + offsetAdjustment, length, cs, maxWidth, maxHeight);
    }

    public static RenderedImage getImageFromBuffer(LCByteBuffer buf, int offset, int length, ColorSpace cs, int maxWidth, int maxHeight) throws BadImageFileException {
        byte[] imageBuf;
        try {
            imageBuf = buf.getBytes(offset, length);
        }
        catch (Exception e) {
            throw new BadImageFileException(e);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(imageBuf);
        return JPEGImageType.getImageFromInputStream(is, cs, maxWidth, maxHeight);
    }

    public static RenderedImage getImageFromInputStream(InputStream stream, ColorSpace cs, int maxWidth, int maxHeight) throws BadImageFileException {
        try {
            LCJPEGReader reader = new LCJPEGReader(new InputStreamImageDataProvider(stream), maxWidth, maxHeight);
            return reader.getImage(cs);
        }
        catch (UserCanceledException e) {
            return null;
        }
        catch (Exception e) {
            throw new BadImageFileException(e);
        }
    }

    @Override
    public String getName() {
        return "JPEG";
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException {
        ImageMetadata metadata = imageInfo.getMetadata();
        ImageMetadataDirectory dir = metadata.findProviderOf(PreviewImageProvider.class);
        if (dir != null) {
            return ((PreviewImageProvider)((Object)dir)).getPreviewImage(imageInfo, maxWidth, maxHeight);
        }
        return super.getPreviewImage(imageInfo, maxWidth, maxHeight);
    }

    @Override
    public RenderedImage getThumbnailImage(ImageInfo imageInfo) throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException {
        ImageMetadataDirectory dir = imageInfo.getMetadata().getDirectoryFor(EXIFDirectory.class);
        if (dir == null) {
            return null;
        }
        ByteBuffer exifSegBuf = JPEGImageType.getFirstSegment(imageInfo, (byte)-31);
        if (exifSegBuf == null) {
            return null;
        }
        ICC_Profile profile = this.getICCProfile(imageInfo);
        return JPEGImageType.getImageFromBuffer(new ArrayByteBuffer(exifSegBuf), dir.getValue(513), 6, dir.getValue(514), profile != null ? new ICC_ColorSpace(profile) : null, 0, 0);
    }

    @Override
    public final ImageType getTrueImageTypeOf(ImageInfo imageInfo) throws BadImageFileException, IOException {
        block5: {
            try {
                ByteBuffer buf = JPEGImageType.getFirstSegment(imageInfo, (byte)-28);
                if (buf == null) break block5;
                SidecarJPEGImageType sidecar = SidecarJPEGImageType.INSTANCE;
                try {
                    if (sidecar.getLZNDocument(buf) != null) {
                        return sidecar;
                    }
                }
                catch (IOException iOException) {}
            }
            catch (UnknownImageTypeException unknownImageTypeException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Document getXMP(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        byte[] xmpBytes;
        ByteBuffer xmpSegBuf = JPEGImageType.getFirstSegment(imageInfo, (byte)-31, new XMPJPEGSegmentFilter());
        if (xmpSegBuf == null) {
            return null;
        }
        if (xmpSegBuf.hasArray()) {
            xmpBytes = xmpSegBuf.array();
        } else {
            xmpBytes = new byte[xmpSegBuf.remaining()];
            xmpSegBuf.get(xmpBytes);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(xmpBytes, JPEGConstants.JPEG_XMP_HEADER_SIZE, xmpBytes.length - JPEGConstants.JPEG_XMP_HEADER_SIZE);
        return XMLUtil.readDocumentFrom(bis);
    }

    @Override
    public boolean hasFastPreview() {
        return true;
    }

    @Override
    public JPEGImageInfo newAuxiliaryInfo(ImageInfo imageInfo) throws BadImageFileException, IOException {
        return new JPEGImageInfo(imageInfo, -31, -30, -28, -19, -18);
    }

    @Override
    public ExportOptions newExportOptions() {
        return new ExportOptions();
    }

    @Override
    public void putImage(ImageInfo imageInfo, PlanarImage image, ImageExportOptions options, Document lznDoc, ProgressThread thread) throws IOException {
        ImageMetadata metadata;
        ExportOptions jpegOptions = (ExportOptions)options;
        try {
            metadata = imageInfo.getMetadata();
        }
        catch (BadImageFileException e) {
            metadata = new ImageMetadata(this);
        }
        catch (UnknownImageTypeException e) {
            metadata = new ImageMetadata(this);
        }
        try {
            int numComponents = image.getColorModel().getNumComponents();
            int colorSpace = LCJPEGWriter.getColorSpaceFromNumComponents(numComponents);
            if (colorSpace == 0) {
                throw new LCImageLibException("Unsupported number of components: " + numComponents);
            }
            LCJPEGWriter writer = new LCJPEGWriter(options.getExportFile().getPath(), image.getWidth(), image.getHeight(), numComponents, colorSpace, jpegOptions.quality.getValue(), jpegOptions.resolution.getValue(), jpegOptions.resolutionUnit.getValue());
            ICC_Profile profile = ColorProfileInfo.getExportICCProfileFor(jpegOptions.colorProfile.getValue());
            if (profile == null) {
                profile = JAIContext.sRGBExportColorProfile;
            }
            writer.setICCProfile(profile);
            if (lznDoc != null) {
                byte[] buf = XMLUtil.encodeDocument(lznDoc, false);
                writer.writeSegment(-28, buf);
            }
            writer.putMetadata(metadata);
            writer.putImage((RenderedImage)image, thread);
        }
        catch (LCImageLibException e) {
            IOException ioe = new IOException("JPEG export failed");
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        Document xmpDoc;
        BadImageFileException exceptionOnHold;
        block8: {
            ByteBuffer iptcSegBuf;
            exceptionOnHold = null;
            ByteBuffer exifSegBuf = JPEGImageType.getFirstSegment(imageInfo, (byte)-31, new EXIFJPEGSegmentFilter());
            if (exifSegBuf != null) {
                EXIFMetadataReader reader = new EXIFMetadataReader(imageInfo, new ArrayByteBuffer(exifSegBuf), false);
                try {
                    reader.readMetadata();
                }
                catch (BadImageFileException e) {
                    exceptionOnHold = e;
                }
            }
            if ((iptcSegBuf = JPEGImageType.getFirstSegment(imageInfo, (byte)-19, new IPTCJPEGSegmentFilter())) != null) {
                IPTCMetadataReader reader = new IPTCMetadataReader(imageInfo, new ArrayByteBuffer(iptcSegBuf), this);
                try {
                    reader.readMetadata();
                }
                catch (BadImageFileException e) {
                    if (exceptionOnHold != null) break block8;
                    exceptionOnHold = e;
                }
            }
        }
        if ((xmpDoc = this.getXMP(imageInfo)) != null) {
            ImageMetadata xmpMetadata = XMPMetadataReader.readFrom(xmpDoc);
            imageInfo.getCurrentMetadata().mergeFrom(xmpMetadata);
        }
        if (exceptionOnHold != null) {
            throw exceptionOnHold;
        }
    }

    @Override
    public void writeMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        ImageMetadataDirectory iptcDir;
        ImageMetaValue rating;
        ImageMetadataDirectory coreDir;
        ImageMetaValue orientation;
        File xmpFile = new File(imageInfo.getXMPFilename());
        boolean xmpExists = xmpFile.exists();
        ImageMetadata metadata = imageInfo.getCurrentMetadata();
        ImageMetadata xmpMetadata = null;
        Document oldXMPDoc = INSTANCE.getXMP(imageInfo);
        if (oldXMPDoc != null) {
            xmpMetadata = XMPMetadataReader.readFrom(oldXMPDoc);
        }
        if ((orientation = (coreDir = metadata.getDirectoryFor(CoreDirectory.class)).getValue(516)) != null && (orientation.isEdited() || xmpExists)) {
            ImageOrientation xmpOrientation = xmpMetadata != null ? xmpMetadata.getOrientation() : ImageOrientation.ORIENTATION_UNKNOWN;
            JPEGImageType.modifyMetadata(imageInfo, 274, orientation.getShortValue(), xmpOrientation != ImageOrientation.ORIENTATION_UNKNOWN ? xmpOrientation.getTIFFConstant() : (short)0, false);
            orientation.clearEdited();
        }
        if ((rating = coreDir.getValue(518)) != null && (rating.isEdited() || xmpExists)) {
            short xmpRating = xmpMetadata != null ? (short)xmpMetadata.getRating() : (short)0;
            short newRating = rating.getShortValue();
            boolean removeRating = false;
            if (newRating == 0) {
                metadata.removeValues(CoreDirectory.class, 518);
                metadata.removeValues(SubEXIFDirectory.class, 18246);
                removeRating = true;
            }
            JPEGImageType.modifyMetadata(imageInfo, 18246, newRating, xmpRating, removeRating);
            rating.clearEdited();
        }
        if ((iptcDir = metadata.getDirectoryFor(IPTCDirectory.class)) != null && iptcDir.isChanged()) {
            byte[] iptcSegBuf = ((IPTCDirectory)iptcDir).encode(true);
            Document newXMPDoc = metadata.toXMP(true, true, new Class[0]);
            if (oldXMPDoc != null) {
                newXMPDoc = XMPUtil.mergeMetadata(newXMPDoc, oldXMPDoc);
            }
            byte[] xmpSegBuf = XMLUtil.encodeDocument(newXMPDoc, true);
            new JPEGCopier().copyAndInsertSegments(imageInfo.getFile(), new NotJPEGSegmentFilter(new OrJPEGSegmentFilter(new IPTCJPEGSegmentFilter(), new XMPJPEGSegmentFilter())), new JPEGCopier.SegmentInfo(-31, xmpSegBuf), new JPEGCopier.SegmentInfo(-19, iptcSegBuf));
            iptcDir.clearEdited();
        }
        CoreDirectory.syncEditableMetadata(metadata);
        if (xmpExists) {
            xmpFile.delete();
        }
    }

    protected JPEGImageType() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyMetadata(ImageInfo jpegInfo, int tagID, short newValue, short oldXMPValue, boolean removeValue) throws BadImageFileException, IOException, UnknownImageTypeException {
        File jpegFile = jpegInfo.getFile();
        ImageMetadata metadata = jpegInfo.getCurrentMetadata();
        Document oldXMPDoc = INSTANCE.getXMP(jpegInfo);
        if (oldXMPValue == 0) {
            LCMappedByteBuffer exifSegBuf = new EXIFSegmentFinder().getEXIFSegmentOf(jpegFile);
            if (exifSegBuf == null || removeValue) {
                metadata = metadata.prepForExport(INSTANCE, true);
                ByteBuffer newEXIFSegBuf = EXIFEncoder.encode(metadata, true);
                new JPEGCopier().copyAndInsertSegments(jpegInfo.getFile(), null, new JPEGCopier.SegmentInfo(-31, newEXIFSegBuf.array()));
                return;
            }
            try {
                InPlaceModifier modifier = new InPlaceModifier(jpegInfo, exifSegBuf);
                if (modifier.modify(tagID, newValue)) {
                    return;
                }
            }
            finally {
                exifSegBuf.close();
            }
        }
        Document newXMPDoc = metadata.toXMP(true, true, new Class[0]);
        if (oldXMPDoc != null) {
            newXMPDoc = XMPUtil.mergeMetadata(newXMPDoc, oldXMPDoc);
        }
        byte[] newXMPSegBuf = XMLUtil.encodeDocument(newXMPDoc, true);
        new JPEGCopier().copyAndInsertSegments(jpegInfo.getFile(), new NotJPEGSegmentFilter(new XMPJPEGSegmentFilter()), new JPEGCopier.SegmentInfo(-31, newXMPSegBuf));
    }

    private static byte[] assembleICCProfile(List<ByteBuffer> list) {
        if (list.size() == 1) {
            ByteBuffer buf = list.get(0);
            return ByteBufferUtil.getBytes(buf, 14, buf.limit() - 14);
        }
        ByteBuffer firstBuf = list.get(0);
        byte numSegments = firstBuf.get(13);
        ByteBuffer[] sortedList = new ByteBuffer[numSegments];
        int totalProfileSize = 0;
        for (ByteBuffer buf : list) {
            int chunkIndex = buf.get(12) - 1;
            sortedList[chunkIndex] = buf;
            totalProfileSize += buf.limit() - 14;
        }
        byte[] iccProfileData = new byte[totalProfileSize];
        int dataOffset = 0;
        for (ByteBuffer buf : sortedList) {
            int chunkSize = buf.limit() - 14;
            ByteBufferUtil.getBytes(buf, 14, iccProfileData, dataOffset, chunkSize);
            dataOffset += chunkSize;
        }
        return iccProfileData;
    }

    private static ICC_Profile getICCProfileFromEXIF(ImageInfo imageInfo) throws BadImageFileException, IOException {
        try {
            ImageMetaValue colorSpace = imageInfo.getMetadata().getValue(EXIFDirectory.class, 40961);
            if (colorSpace != null) {
                switch (colorSpace.getIntValue()) {
                    case 1: {
                        return JAIContext.sRGBColorProfile;
                    }
                }
                return JAIContext.adobeRGBProfile;
            }
        }
        catch (UnknownImageTypeException unknownImageTypeException) {
            // empty catch block
        }
        return null;
    }

    private static final class JPEGCopier
    implements JPEGParserEventHandler {
        private boolean m_copied;
        private RandomAccessFile m_raf;
        private JPEGSegmentFilter m_segFilter;
        private SegmentInfo[] m_segInfo;

        private JPEGCopier() {
        }

        @Override
        public boolean gotSegment(byte segID, int segLength, File jpegFile, LCByteBuffer buf) throws IOException {
            if (segID == -38) {
                if (this.m_segInfo != null) {
                    this.insertSegments();
                }
                buf.skipBytes(-2);
                JPEGCopier.copy(buf, this.m_raf, buf.remaining());
                this.m_copied = true;
                return false;
            }
            if (this.m_segFilter != null) {
                int chunkSize = Math.min(segLength, 32);
                byte[] chunk = buf.getBytes(buf.position(), chunkSize);
                ByteBuffer chunkBuf = ByteBuffer.wrap(chunk);
                if (!this.m_segFilter.accept(segID, chunkBuf)) {
                    return true;
                }
            }
            if (this.m_segInfo != null) {
                this.insertSegments();
            }
            buf.skipBytes(-4);
            JPEGCopier.copy(buf, this.m_raf, segLength + 4);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void copyAndInsertSegments(File jpegFile, JPEGSegmentFilter segFilter, SegmentInfo ... segments) throws BadImageFileException, IOException {
            this.m_segFilter = segFilter;
            this.m_segInfo = segments;
            LCMappedByteBuffer buf = new LCMappedByteBuffer(jpegFile);
            File newFile = null;
            try {
                try {
                    newFile = File.createTempFile("LZcp", null, jpegFile.getParentFile());
                    this.m_raf = new RandomAccessFile(newFile, "rw");
                    this.m_raf.writeByte(-1);
                    this.m_raf.writeByte(-40);
                    JPEGParser.parse(this, jpegFile, buf);
                }
                finally {
                    if (this.m_raf != null) {
                        this.m_raf.close();
                    }
                    buf.close();
                    if (this.m_copied) {
                        ImageInfo.closeAll();
                        for (int i = 0; !jpegFile.delete() && i < 5; ++i) {
                            System.gc();
                        }
                        FileUtil.renameFile(newFile, jpegFile);
                    }
                }
            }
            finally {
                if (newFile != null) {
                    newFile.delete();
                }
            }
        }

        private static void copy(LCByteBuffer from, RandomAccessFile to, int byteCount) throws IOException {
            byte[] chunk = new byte[Math.min(byteCount, 65536)];
            while (byteCount > 0) {
                int bytesToCopy = Math.min(byteCount, chunk.length);
                from.get(chunk, 0, bytesToCopy);
                to.write(chunk, 0, bytesToCopy);
                byteCount -= bytesToCopy;
            }
        }

        private void insertSegments() throws IOException {
            for (SegmentInfo seg : this.m_segInfo) {
                if (seg.m_segData == null || seg.m_segData.length <= 0) continue;
                this.m_raf.writeByte(-1);
                this.m_raf.writeByte(seg.m_segID);
                this.m_raf.writeShort(seg.m_segData.length + 2);
                this.m_raf.write(seg.m_segData);
            }
            this.m_segInfo = null;
        }

        static final class SegmentInfo {
            final byte m_segID;
            final byte[] m_segData;

            SegmentInfo(byte segID, byte[] segData) {
                this.m_segID = segID;
                this.m_segData = segData;
            }
        }
    }

    private static final class InPlaceModifier
    extends EXIFMetadataReader {
        private short m_newValue;
        private boolean m_succeeded;
        private int m_tagID;

        @Override
        public void gotTag(int tagID, int fieldType, int numValues, int byteCount, int valueOffset, int valueOffsetAdjustment, int subdirOffset, File imageFile, LCByteBuffer buf, ImageMetadataDirectory dir) throws IOException {
            if (tagID == this.m_tagID) {
                buf.position(valueOffset);
                buf.putShort(this.m_newValue);
                this.m_exifParser.stopParsing();
                this.m_succeeded = true;
            }
        }

        InPlaceModifier(ImageInfo jpegInfo, LCByteBuffer exifSegBuf) {
            super(jpegInfo, exifSegBuf, false);
        }

        boolean modify(int tagID, short newValue) throws BadImageFileException, IOException {
            this.m_newValue = newValue;
            this.m_tagID = tagID;
            this.readMetadata();
            if (this.m_succeeded) {
                FileUtil.touch(this.m_imageInfo.getFile());
            }
            return this.m_succeeded;
        }
    }

    private static final class EXIFSegmentFinder
    implements JPEGParserEventHandler {
        private LCMappedByteBuffer m_exifSegBuf;

        private EXIFSegmentFinder() {
        }

        @Override
        public boolean gotSegment(byte segID, int segLength, File jpegFile, LCByteBuffer buf) throws IOException {
            if (segID == -31 && buf.getEquals("Exif", "ASCII")) {
                this.m_exifSegBuf = new LCMappedByteBuffer(jpegFile, buf.position() - 4, segLength - 4, FileChannel.MapMode.READ_WRITE);
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LCMappedByteBuffer getEXIFSegmentOf(File jpegFile) throws BadImageFileException, IOException {
            LCMappedByteBuffer buf = new LCMappedByteBuffer(jpegFile);
            try {
                JPEGParser.parse(this, jpegFile, buf);
                LCMappedByteBuffer lCMappedByteBuffer = this.m_exifSegBuf;
                return lCMappedByteBuffer;
            }
            finally {
                buf.close();
            }
        }
    }

    public static class ExportOptions
    extends ImageFileExportOptions {
        public final QualityOption quality = new QualityOption(85, (ImageExportOptions)this);

        public ExportOptions() {
            this(INSTANCE);
        }

        @Override
        public void readFrom(ImageExportOptionReader r) throws IOException {
            super.readFrom(r);
            this.quality.readFrom(r);
        }

        @Override
        public void writeTo(ImageExportOptionWriter w) throws IOException {
            super.writeTo(w);
            this.quality.writeTo(w);
        }

        protected ExportOptions(ImageType instance) {
            super(instance);
        }

        @Override
        protected void save(XmlNode node) {
            super.save(node);
            this.quality.save(node);
        }

        @Override
        protected void restore(XmlNode node) throws XMLException {
            super.restore(node);
            try {
                this.quality.restore(node);
            }
            catch (XMLException e) {
                System.err.println("Failed to restore JPEG quality");
            }
        }
    }
}

