/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ColorProfileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.types.ARWImageType;
import com.lightcrafts.image.types.AuxiliaryImageInfo;
import com.lightcrafts.image.types.CIFFImageType;
import com.lightcrafts.image.types.CR2ImageType;
import com.lightcrafts.image.types.DCRImageType;
import com.lightcrafts.image.types.DNGImageType;
import com.lightcrafts.image.types.ERFImageType;
import com.lightcrafts.image.types.FFFImageType;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.KDCImageType;
import com.lightcrafts.image.types.LZNDocumentProvider;
import com.lightcrafts.image.types.LZNImageType;
import com.lightcrafts.image.types.MOSImageType;
import com.lightcrafts.image.types.MRWImageType;
import com.lightcrafts.image.types.MultipageTIFFImageType;
import com.lightcrafts.image.types.NEFImageType;
import com.lightcrafts.image.types.ORFImageType;
import com.lightcrafts.image.types.PEFImageType;
import com.lightcrafts.image.types.PanasonicRawImageType;
import com.lightcrafts.image.types.RAFImageType;
import com.lightcrafts.image.types.RW2ImageType;
import com.lightcrafts.image.types.SR2ImageType;
import com.lightcrafts.image.types.SRWImageType;
import com.lightcrafts.image.types.SidecarJPEGImageType;
import com.lightcrafts.image.types.SidecarTIFFImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.utils.UserCanceledException;
import com.lightcrafts.utils.file.FileUtil;
import com.lightcrafts.utils.thread.ProgressThread;
import com.lightcrafts.utils.xml.XMLUtil;
import java.awt.Dimension;
import java.awt.color.ICC_Profile;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Document;

public abstract class ImageType {
    private static final ArrayList<ImageType> m_types = new ArrayList();

    public boolean canExport() {
        return false;
    }

    public static ImageType determineTypeByExtensionOf(File file) {
        String extension = FileUtil.getExtensionOf(file);
        return extension != null ? ImageType.findTypeFromExtension(extension) : null;
    }

    public static ImageType findTypeFromExtension(String extension) {
        for (ImageType t : m_types) {
            if (t instanceof LZNDocumentProvider && t != LZNImageType.INSTANCE || !t.matchExtension(extension)) continue;
            return t;
        }
        return null;
    }

    public static Collection<ImageType> getAllTypes() {
        return m_types;
    }

    public Dimension getDimension(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        return null;
    }

    public abstract String[] getExtensions();

    public ICC_Profile getICCProfile(ImageInfo imageInfo) throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException {
        return null;
    }

    public abstract PlanarImage getImage(ImageInfo var1, ProgressThread var2) throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException, UserCanceledException;

    public static ImageType getImageTypeByName(String name) {
        for (ImageType t : m_types) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public abstract String getName();

    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException {
        return null;
    }

    public boolean hasFastPreview() {
        return false;
    }

    public RenderedImage getThumbnailImage(ImageInfo imageInfo) throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException {
        return null;
    }

    public Document getXMP(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        return null;
    }

    public AuxiliaryImageInfo newAuxiliaryInfo(ImageInfo imageInfo) throws BadImageFileException, IOException {
        return null;
    }

    public ImageExportOptions newExportOptions() {
        throw new UnsupportedOperationException("can not export to " + this.getName());
    }

    public final void putImage(ImageInfo imageInfo, PlanarImage image, ImageExportOptions options, byte[] lznData, ProgressThread thread) throws IOException {
        Document lznDoc = lznData != null ? XMLUtil.readDocumentFrom(new ByteArrayInputStream(lznData)) : null;
        this.putImage(imageInfo, image, options, lznDoc, thread);
    }

    public void putImage(ImageInfo imageInfo, PlanarImage image, ImageExportOptions options, Document lznDoc, ProgressThread thread) throws IOException {
        throw new UnsupportedOperationException("can not export to " + this.getName());
    }

    public abstract void readMetadata(ImageInfo var1) throws BadImageFileException, IOException, UnknownImageTypeException;

    public abstract void writeMetadata(ImageInfo var1) throws BadImageFileException, IOException, UnknownImageTypeException;

    protected ImageType() {
        m_types.add(this);
    }

    private boolean matchExtension(String extension) {
        String extensionLC = extension.toLowerCase();
        for (String e : this.getExtensions()) {
            if (!extensionLC.equals(e)) continue;
            return true;
        }
        return false;
    }

    static {
        ImageType[] imageTypeArray = new ImageType[]{ARWImageType.INSTANCE, CIFFImageType.INSTANCE, CR2ImageType.INSTANCE, DCRImageType.INSTANCE, DNGImageType.INSTANCE, ERFImageType.INSTANCE, FFFImageType.INSTANCE, JPEGImageType.INSTANCE, KDCImageType.INSTANCE, LZNImageType.INSTANCE, MOSImageType.INSTANCE, MRWImageType.INSTANCE, NEFImageType.INSTANCE, ORFImageType.INSTANCE, PanasonicRawImageType.INSTANCE, PEFImageType.INSTANCE, RAFImageType.INSTANCE, RW2ImageType.INSTANCE, SR2ImageType.INSTANCE, SRWImageType.INSTANCE, TIFFImageType.INSTANCE, SidecarJPEGImageType.INSTANCE, SidecarTIFFImageType.INSTANCE, MultipageTIFFImageType.INSTANCE};
    }
}

