/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.makernotes.CanonDirectory;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.types.CanonTIFFRawImageType;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.TrueImageTypeProvider;
import java.io.IOException;

final class CanonTIFFRawImageProbe
implements TrueImageTypeProvider {
    static final CanonTIFFRawImageProbe INSTANCE = new CanonTIFFRawImageProbe();

    @Override
    public ImageType getTrueImageTypeOf(ImageInfo imageInfo) throws BadImageFileException, IOException {
        try {
            ImageMetadata metadata = imageInfo.getMetadata();
            ImageMetaValue modelId = metadata.getValue(CanonDirectory.class, 16);
            if (modelId == null) {
                return null;
            }
            int id = modelId.getIntValue();
            if (id != -2147483647 && id != -2147483289) {
                return null;
            }
            ImageMetaValue qualityValue = metadata.getValue(CanonDirectory.class, 259);
            if (qualityValue == null) {
                return null;
            }
            if (qualityValue.getIntValue() == 4) {
                MetadataUtil.removePreviewMetadataFrom(metadata);
                MetadataUtil.removeWidthHeightFrom(metadata);
                return CanonTIFFRawImageType.INSTANCE;
            }
        }
        catch (UnknownImageTypeException unknownImageTypeException) {
            // empty catch block
        }
        return null;
    }

    private CanonTIFFRawImageProbe() {
    }
}

