/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.values;

import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.values.NumericMetaValue;
import com.lightcrafts.utils.LCArrays;
import com.lightcrafts.utils.Rational;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RationalMetaValue
extends NumericMetaValue {
    private Rational[] m_value;

    public RationalMetaValue() {
    }

    public RationalMetaValue(int numerator, int denominator) {
        this(new Rational(numerator, denominator));
    }

    public RationalMetaValue(Rational ... values) {
        this.m_value = values;
    }

    public RationalMetaValue(String ... values) {
        this.setValuesImpl(values);
    }

    @Override
    public RationalMetaValue clone() {
        RationalMetaValue copy = (RationalMetaValue)super.clone();
        copy.m_value = (Rational[])this.m_value.clone();
        return copy;
    }

    @Override
    public final int compareTo(Object o) {
        if (o instanceof NumericMetaValue) {
            NumericMetaValue rightVal = (NumericMetaValue)o;
            double leftDouble = this.getDoubleValue();
            double rightDouble = rightVal.getDoubleValue();
            return Double.compare(leftDouble, rightDouble);
        }
        return super.compareTo(o);
    }

    @Override
    public final int compareTo(String s) {
        try {
            Rational rightRational = Rational.parseRational(s);
            Rational leftRational = this.getRationalValue();
            return leftRational.compareTo(rightRational);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @Override
    public final double getDoubleValue() {
        return this.getRationalValue().doubleValue();
    }

    @Override
    public final long getLongValue() {
        return this.getRationalValue().longValue();
    }

    public final Rational getRationalValue() {
        return this.m_value[0];
    }

    public final Rational[] getRationalValues() {
        return this.m_value;
    }

    @Override
    public ImageMetaType getType() {
        return ImageMetaType.META_SRATIONAL;
    }

    @Override
    public final int getValueCount() {
        return this.m_value != null ? this.m_value.length : 0;
    }

    @Override
    public boolean isLegalValue(String value) {
        try {
            Rational.parseRational(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public void setLongValue(long newValue) {
        this.setRationalValueAt(new Rational((int)newValue, 1), 0);
    }

    public final synchronized void setRationalValueAt(Rational newValue, int index) {
        this.checkIsEditable();
        if (this.m_value == null) {
            this.m_value = new Rational[index + 1];
        } else if (index >= this.m_value.length) {
            this.m_value = (Rational[])LCArrays.resize(this.m_value, index + 1);
        }
        this.m_value[index] = newValue;
        this.dirty();
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException {
        int length = this.readHeader(in);
        this.m_value = new Rational[length];
        for (int i = 0; i < length; ++i) {
            this.m_value[i] = new Rational(in.readInt(), in.readInt());
        }
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        this.writeHeader(out);
        for (Rational value : this.m_value) {
            out.writeInt(value.numerator());
            out.writeInt(value.denominator());
        }
    }

    @Override
    protected final void appendValueImpl(String newValue) {
        Rational newRational = Rational.parseRational(newValue);
        if (this.m_value == null) {
            this.m_value = new Rational[]{newRational};
        } else {
            this.m_value = (Rational[])LCArrays.resize(this.m_value, this.m_value.length + 1);
            this.m_value[this.m_value.length - 1] = newRational;
        }
    }

    @Override
    protected final String[] getValuesImpl() {
        if (this.m_value == null) {
            return null;
        }
        String[] value = new String[this.m_value.length];
        for (int i = 0; i < this.m_value.length; ++i) {
            value[i] = this.m_value[i].toString();
        }
        return value;
    }

    @Override
    protected final void setValuesImpl(String[] newValue) {
        if (this.m_value == null || this.m_value.length != newValue.length) {
            this.m_value = new Rational[newValue.length];
        }
        for (int i = 0; i < newValue.length; ++i) {
            this.m_value[i] = Rational.parseRational(newValue[i]);
        }
    }

    @Override
    protected final String toStringImpl() {
        if (this.m_value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        for (Rational value : this.m_value) {
            if (!comma) {
                comma = true;
            } else {
                sb.append(',');
            }
            sb.append(value.toString());
        }
        return sb.toString();
    }
}

