/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.makernotes;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.TIFFDirectory;
import com.lightcrafts.image.metadata.makernotes.CanonTags;
import com.lightcrafts.image.metadata.makernotes.MakerNotesDirectory;
import com.lightcrafts.image.metadata.providers.ApertureProvider;
import com.lightcrafts.image.metadata.providers.ArtistProvider;
import com.lightcrafts.image.metadata.providers.ColorTemperatureProvider;
import com.lightcrafts.image.metadata.providers.FocalLengthProvider;
import com.lightcrafts.image.metadata.providers.ISOProvider;
import com.lightcrafts.image.metadata.providers.ImageMetadataProvider;
import com.lightcrafts.image.metadata.providers.LensProvider;
import com.lightcrafts.image.metadata.providers.OrientationProvider;
import com.lightcrafts.image.metadata.providers.PreviewImageProvider;
import com.lightcrafts.image.metadata.providers.ShutterSpeedProvider;
import com.lightcrafts.image.metadata.providers.ThumbnailImageProvider;
import com.lightcrafts.image.metadata.providers.WidthHeightProvider;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.LongMetaValue;
import com.lightcrafts.image.metadata.values.ShortMetaValue;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.utils.TextUtil;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class CanonDirectory
extends MakerNotesDirectory
implements ApertureProvider,
ArtistProvider,
ColorTemperatureProvider,
FocalLengthProvider,
ISOProvider,
LensProvider,
OrientationProvider,
PreviewImageProvider,
ShutterSpeedProvider,
ThumbnailImageProvider,
WidthHeightProvider {
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.makernotes.CanonTags");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();

    @Override
    public float getAperture() {
        ImageMetaValue value = this.getValue(1045);
        return value != null ? (float)MetadataUtil.convertFStopFromAPEX(value.getIntValue()) : 0.0f;
    }

    @Override
    public String getArtist() {
        ImageMetaValue value = this.getValue(9);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public int getColorTemperature() {
        ImageMetaValue value = this.getValue(40969);
        if (value == null) {
            value = this.getValue(2569);
        }
        if (value == null) {
            value = this.getValue(174);
        }
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public float getFocalLength() {
        ImageMetaValue value = this.getValue(513);
        return value != null ? value.getFloatValue() : 0.0f;
    }

    @Override
    public int getImageHeight() {
        ImageMetaValue value = this.getValue(4611);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public int getImageWidth() {
        ImageMetaValue value = this.getValue(4610);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public int getISO() {
        ImageMetaValue value = this.getValue(1026);
        boolean isAPEX = true;
        if (value == null) {
            value = this.getValue(272);
            isAPEX = false;
        }
        if (value == null) {
            return 0;
        }
        int iso = value.getIntValue();
        if (isAPEX) {
            iso = MetadataUtil.convertISOFromAPEX(iso);
        }
        return iso >= 1 && iso <= 10000 ? iso : 0;
    }

    @Override
    public String getName() {
        return "Canon";
    }

    @Override
    public String getLens() {
        ImageMetaValue lensValue = this.getValue(278);
        String label = CanonDirectory.hasTagValueLabelFor(lensValue);
        if (label != null) {
            return label;
        }
        return CanonDirectory.makeLensLabelFrom(this.getValue(280), this.getValue(279), this.getValue(281));
    }

    @Override
    public ImageOrientation getOrientation() {
        ImageMetaValue value = this.getValue(1051);
        if (value != null) {
            switch (value.getIntValue()) {
                case 0: {
                    return ImageOrientation.ORIENTATION_LANDSCAPE;
                }
                case 1: {
                    return ImageOrientation.ORIENTATION_90CCW;
                }
                case 2: {
                    return ImageOrientation.ORIENTATION_180;
                }
                case 3: {
                    return ImageOrientation.ORIENTATION_90CW;
                }
            }
        }
        return ImageOrientation.ORIENTATION_UNKNOWN;
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException {
        return JPEGImageType.getImageFromBuffer(imageInfo.getByteBuffer(), this.getValue(46597), 12, this.getValue(46594), maxWidth, maxHeight);
    }

    @Override
    public RenderedImage getThumbnailImage(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        ImageMetadataDirectory dir = imageInfo.getMetadata().getDirectoryFor(TIFFDirectory.class);
        if (dir == null) {
            return null;
        }
        return JPEGImageType.getImageFromBuffer(imageInfo.getByteBuffer(), dir.getValue(513), 0, dir.getValue(514), 0, 0);
    }

    @Override
    public float getShutterSpeed() {
        ImageMetaValue value = this.getValue(1046);
        return value != null ? this.getShutterSpeedFrom(value) : 0.0f;
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    public void putValue(Integer tagID, ImageMetaValue value) {
        switch (tagID) {
            case 1: 
            case 2: 
            case 4: 
            case 10: 
            case 160: 
            case 224: {
                this.explodeSubfields(tagID, 1, value, false);
                return;
            }
            case 18: 
            case 147: 
            case 182: 
            case 16385: 
            case 16387: {
                this.explodeSubfields(tagID, 1, value, true);
                return;
            }
            case 15: {
                value.setNonDisplayable();
                if (value instanceof LongMetaValue) {
                    long[] longs = ((LongMetaValue)value).getLongValues();
                    int cfTagIDStart = tagID << 8;
                    for (int i = 1; i < longs.length; ++i) {
                        int n = (int)longs[i];
                        this.putValue(cfTagIDStart | n >>> 8, new ShortMetaValue((short)(n & 0xFF)));
                    }
                }
                return;
            }
            case 3: {
                return;
            }
        }
        super.putValue(tagID, value);
    }

    @Override
    public String valueToString(ImageMetaValue value) {
        switch (value.getOwningTagID()) {
            case 278: {
                String label = this.hasTagValueLabelFor(278);
                return label != null ? label : "unknown";
            }
            case 279: 
            case 280: 
            case 513: 
            case 3338: 
            case 3346: 
            case 3348: {
                return value.getStringValue() + "mm";
            }
            case 40971: {
                return TextUtil.tenths((float)value.getIntValue() / 10.0f);
            }
            case 1029: 
            case 1046: {
                float shutterSpeed = this.getShutterSpeedFrom(value);
                return MetadataUtil.shutterSpeedString(shutterSpeed);
            }
            case 1028: 
            case 1045: {
                int apex = value.getIntValue();
                return TextUtil.tenths(MetadataUtil.convertFStopFromAPEX(apex));
            }
        }
        return super.valueToString(value);
    }

    @Override
    protected int getProviderPriorityFor(Class<? extends ImageMetadataProvider> provider) {
        return provider == ShutterSpeedProvider.class ? 0 : super.getProviderPriorityFor(provider);
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return CanonTags.class;
    }

    private static void add(int id, String name, ImageMetaType type) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, false);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    private float getShutterSpeedFrom(ImageMetaValue value) {
        int apex = value.getIntValue();
        double speed = Math.exp(-MetadataUtil.convertAPEXToEV(apex) * MetadataUtil.LN_2);
        String model = this.getOwningMetadata().getCameraMake(true);
        if (model != null && (model.contains("20D") || model.contains("350D") || model.contains("REBEL XT"))) {
            speed *= 31.25;
        }
        return (float)speed;
    }

    static {
        CanonDirectory.add(1, "CameraSettings", ImageMetaType.META_UNDEFINED);
        CanonDirectory.add(0x400100, "CDVersion", ImageMetaType.META_SSHORT);
        CanonDirectory.add(3845, "CFAssistLight", ImageMetaType.META_SSHORT);
        CanonDirectory.add(3847, "CFAutoExposureBracketing", ImageMetaType.META_SSHORT);
        CanonDirectory.add(3842, "CFAutoExposureLockButtons", ImageMetaType.META_SSHORT);
        CanonDirectory.add(3850, "CFFillFlashAutoReduction", ImageMetaType.META_SSHORT);
        CanonDirectory.add(3849, "CFLensAutoFocusStopButton", ImageMetaType.META_SSHORT);
        CanonDirectory.add(3841, "CFLongExposureNoiseReduction", ImageMetaType.META_SSHORT);
        CanonDirectory.add(3851, "CFMenuButtonReturnPosition", ImageMetaType.META_SSHORT);
        CanonDirectory.add(3843, "CFMirrorLockup", ImageMetaType.META_SSHORT);
        CanonDirectory.add(3853, "CFSensorCleaning", ImageMetaType.META_SSHORT);
        CanonDirectory.add(3852, "CFSetButtonFunction", ImageMetaType.META_SSHORT);
        CanonDirectory.add(3848, "CFShutterCurtainSync", ImageMetaType.META_SSHORT);
        CanonDirectory.add(3846, "CFShutterSpeedInAvMode", ImageMetaType.META_SSHORT);
        CanonDirectory.add(3844, "CFTVAVExposureLevel", ImageMetaType.META_SSHORT);
        CanonDirectory.add(4195074, "CIColorHue", ImageMetaType.META_SSHORT);
        CanonDirectory.add(0x400303, "CIColorSpace", ImageMetaType.META_SSHORT);
        CanonDirectory.add(2570, "CID30ColorMatrix", ImageMetaType.META_SSHORT);
        CanonDirectory.add(2569, "CID30ColorTemperature", ImageMetaType.META_USHORT);
        CanonDirectory.add(16387, "ColorInfo", ImageMetaType.META_UNDEFINED);
        CanonDirectory.add(10, "ColorInfoD30", ImageMetaType.META_UNDEFINED);
        CanonDirectory.add(180, "ColorSpace", ImageMetaType.META_USHORT);
        CanonDirectory.add(174, "ColorTemperature", ImageMetaType.META_USHORT);
        CanonDirectory.add(275, "CSAFPointSelected", ImageMetaType.META_SSHORT);
        CanonDirectory.add(261, "CSContinuousDriveMode", ImageMetaType.META_SSHORT);
        CanonDirectory.add(269, "CSContrast", ImageMetaType.META_SSHORT);
        CanonDirectory.add(268, "CSDigitalZoom", ImageMetaType.META_SSHORT);
        CanonDirectory.add(267, "CSEasyShootingMode", ImageMetaType.META_SSHORT);
        CanonDirectory.add(276, "CSExposureMode", ImageMetaType.META_SSHORT);
        CanonDirectory.add(284, "CSFlashActivity", ImageMetaType.META_SSHORT);
        CanonDirectory.add(285, "CSFlashDetails", ImageMetaType.META_SSHORT);
        CanonDirectory.add(260, "CSFlashMode", ImageMetaType.META_SSHORT);
        CanonDirectory.add(281, "CSFocalUnitsPerMM", ImageMetaType.META_SSHORT);
        CanonDirectory.add(263, "CSFocusMode", ImageMetaType.META_SSHORT);
        CanonDirectory.add(288, "CSFocusModeG1", ImageMetaType.META_SSHORT);
        CanonDirectory.add(274, "CSFocusType", ImageMetaType.META_SSHORT);
        CanonDirectory.add(266, "CSImageSize", ImageMetaType.META_SSHORT);
        CanonDirectory.add(272, "CSISO", ImageMetaType.META_SSHORT);
        CanonDirectory.add(278, "CSLensType", ImageMetaType.META_SSHORT);
        CanonDirectory.add(279, "CSLongFocalLength", ImageMetaType.META_SSHORT);
        CanonDirectory.add(257, "CSMacroMode", ImageMetaType.META_SSHORT);
        CanonDirectory.add(273, "CSMeteringMode", ImageMetaType.META_SSHORT);
        CanonDirectory.add(259, "CSQuality", ImageMetaType.META_SSHORT);
        CanonDirectory.add(270, "CSSaturation", ImageMetaType.META_SSHORT);
        CanonDirectory.add(258, "CSSelfTimerDelay", ImageMetaType.META_SSHORT);
        CanonDirectory.add(271, "CSSharpness", ImageMetaType.META_SSHORT);
        CanonDirectory.add(280, "CSShortFocalLength", ImageMetaType.META_SSHORT);
        CanonDirectory.add(292, "CSZoomedResolution", ImageMetaType.META_SSHORT);
        CanonDirectory.add(293, "CSZoomedResolutionBase", ImageMetaType.META_SSHORT);
        CanonDirectory.add(15, "CustomFunctions", ImageMetaType.META_SSHORT);
        CanonDirectory.add(147, "FileInfo", ImageMetaType.META_UNDEFINED);
        CanonDirectory.add(14, "FileLength", ImageMetaType.META_ULONG);
        CanonDirectory.add(7, "FirmwareVersion", ImageMetaType.META_STRING);
        CanonDirectory.add(37633, "FIFileNumber", ImageMetaType.META_ULONG);
        CanonDirectory.add(37634, "FIShutterCount", ImageMetaType.META_ULONG);
        CanonDirectory.add(3, "FlashInfo", ImageMetaType.META_UNDEFINED);
        CanonDirectory.add(513, "FLFocalLength", ImageMetaType.META_USHORT);
        CanonDirectory.add(514, "FLFocalPlaneXSize", ImageMetaType.META_USHORT);
        CanonDirectory.add(515, "FLFocalPlaneYSize", ImageMetaType.META_USHORT);
        CanonDirectory.add(2, "FocalLength", ImageMetaType.META_UNDEFINED);
        CanonDirectory.add(8, "ImageNumber", ImageMetaType.META_ULONG);
        CanonDirectory.add(6, "ImageType", ImageMetaType.META_STRING);
        CanonDirectory.add(13, "LensInfo1D", ImageMetaType.META_UNDEFINED);
        CanonDirectory.add(3338, "LIFocalLength", ImageMetaType.META_USHORT);
        CanonDirectory.add(3341, "LILensType", ImageMetaType.META_USHORT);
        CanonDirectory.add(3348, "LILongFocalLength", ImageMetaType.META_USHORT);
        CanonDirectory.add(3346, "LIShortFocalLength", ImageMetaType.META_USHORT);
        CanonDirectory.add(16, "ModelID", ImageMetaType.META_ULONG);
        CanonDirectory.add(9, "OwnerName", ImageMetaType.META_STRING);
        CanonDirectory.add(4630, "PIAFPointsUsed", ImageMetaType.META_USHORT);
        CanonDirectory.add(40969, "PIColorTemperature", ImageMetaType.META_SSHORT);
        CanonDirectory.add(40971, "PIDigitalGain", ImageMetaType.META_SSHORT);
        CanonDirectory.add(4611, "PIImageHeight", ImageMetaType.META_USHORT);
        CanonDirectory.add(4613, "PIImageHeightAsShot", ImageMetaType.META_USHORT);
        CanonDirectory.add(4610, "PIImageWidth", ImageMetaType.META_USHORT);
        CanonDirectory.add(4612, "PIImageWidthAsShot", ImageMetaType.META_USHORT);
        CanonDirectory.add(40970, "PIPictureStyle", ImageMetaType.META_SSHORT);
        CanonDirectory.add(40964, "PISensorBlueLevel", ImageMetaType.META_SSHORT);
        CanonDirectory.add(40964, "PISensorRedLevel", ImageMetaType.META_SSHORT);
        CanonDirectory.add(40961, "PIToneCurve", ImageMetaType.META_SSHORT);
        CanonDirectory.add(40972, "PIWBShiftAB", ImageMetaType.META_SSHORT);
        CanonDirectory.add(40973, "PIWBShiftGM", ImageMetaType.META_SSHORT);
        CanonDirectory.add(40964, "PIWhiteBalanceBlue", ImageMetaType.META_SSHORT);
        CanonDirectory.add(40964, "PIWhiteBalanceRed", ImageMetaType.META_SSHORT);
        CanonDirectory.add(9729, "PI2AfAreaMode", ImageMetaType.META_USHORT);
        CanonDirectory.add(18, "PictureInfo", ImageMetaType.META_UNDEFINED);
        CanonDirectory.add(38, "PictureInfo2", ImageMetaType.META_UNDEFINED);
        CanonDirectory.add(46598, "PIIFocalPlaneXResolution", ImageMetaType.META_SRATIONAL);
        CanonDirectory.add(46600, "PIIFocalPlaneYResolution", ImageMetaType.META_SRATIONAL);
        CanonDirectory.add(46596, "PIIImageHeight", ImageMetaType.META_ULONG);
        CanonDirectory.add(46594, "PIIImageLength", ImageMetaType.META_ULONG);
        CanonDirectory.add(46597, "PIIImageStart", ImageMetaType.META_ULONG);
        CanonDirectory.add(46595, "PIIImageWidth", ImageMetaType.META_ULONG);
        CanonDirectory.add(182, "PreviewImageInfo", ImageMetaType.META_UNDEFINED);
        CanonDirectory.add(160, "ColorProcessingInfo", ImageMetaType.META_UNDEFINED);
        CanonDirectory.add(224, "SensorInfo", ImageMetaType.META_UNDEFINED);
        CanonDirectory.add(12, "SerialNumber", ImageMetaType.META_ULONG);
        CanonDirectory.add(4, "ShotInfo", ImageMetaType.META_UNDEFINED);
        CanonDirectory.add(1041, "AEBBracketValue", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1038, "SIAFPointUsed", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1040, "SIAutoExposureBracketing", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1051, "SIAutoRotate", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1048, "SIBulbDuration", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1030, "SIExposureCompensation", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1046, "ExposureTime", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1039, "SIFlashBias", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1045, "FNumber", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1044, "FocusDistanceLower", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1044, "SIFocusDistanceLower", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1043, "SIFocusDistanceUpper", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1026, "SIISO", ImageMetaType.META_SSHORT);
        CanonDirectory.add(57345, "SISensorWidth", ImageMetaType.META_SSHORT);
        CanonDirectory.add(57346, "SISensorHeight", ImageMetaType.META_SSHORT);
        CanonDirectory.add(57349, "SISensorLeftBorder", ImageMetaType.META_SSHORT);
        CanonDirectory.add(57350, "SISensorTopBorder", ImageMetaType.META_SSHORT);
        CanonDirectory.add(57351, "SISensorRightBorder", ImageMetaType.META_SSHORT);
        CanonDirectory.add(57352, "SISensorBottomBorder", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1033, "SISequenceNumber", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1028, "TargetAperture", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1029, "TargetExposure", ImageMetaType.META_SSHORT);
        CanonDirectory.add(1031, "SIWhiteBalance", ImageMetaType.META_SSHORT);
        CanonDirectory.add(169, "WhiteBalanceTable", ImageMetaType.META_SSHORT);
    }
}

