/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.ImageMetadataReader;
import com.lightcrafts.image.metadata.TIFFMetadataReader;
import java.io.IOException;

public final class RAFMetadataReader
extends ImageMetadataReader {
    private TIFFMetadataReader m_tiffMetadataReader;
    private int m_tiffOffset;

    public RAFMetadataReader(ImageInfo imageInfo) {
        super(imageInfo, imageInfo.getByteBuffer());
    }

    public int getTIFFOffset() {
        return this.m_tiffOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readHeader() throws BadImageFileException, IOException {
        String s = this.m_buf.getString(0, 15, "ASCII");
        if (!s.equals("FUJIFILMCCD-RAW")) {
            throw new BadImageFileException(this.m_imageInfo.getFile());
        }
        this.m_tiffOffset = this.m_buf.getInt(84) + 1 + 1 + 1 + 1 + 2 + 6;
        this.m_tiffMetadataReader = new TIFFMetadataReader(this.m_imageInfo);
        this.m_buf.initialOffset(this.m_tiffOffset);
        try {
            this.m_tiffMetadataReader.readHeader();
        }
        finally {
            this.m_buf.initialOffset(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readAllDirectories() throws IOException {
        this.m_buf.initialOffset(this.m_tiffOffset);
        try {
            this.m_tiffMetadataReader.readAllDirectories();
        }
        finally {
            this.m_buf.initialOffset(0);
        }
    }
}

