/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.metadata.GPSTags;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class GPSDirectory
extends ImageMetadataDirectory {
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.GPSTags");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();

    @Override
    public String getName() {
        return "GPS";
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return GPSTags.class;
    }

    private static void add(int id, String name, ImageMetaType type) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, false);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    static {
        GPSDirectory.add(6, "GPSAltitude", ImageMetaType.META_URATIONAL);
        GPSDirectory.add(5, "GPSAltitudeRef", ImageMetaType.META_UBYTE);
        GPSDirectory.add(28, "GPSAreaInformation", ImageMetaType.META_UNDEFINED);
        GPSDirectory.add(29, "GPSDateStamp", ImageMetaType.META_STRING);
        GPSDirectory.add(24, "GPSDestBearing", ImageMetaType.META_URATIONAL);
        GPSDirectory.add(23, "GPSDestBearingRef", ImageMetaType.META_STRING);
        GPSDirectory.add(26, "GPSDestDistance", ImageMetaType.META_URATIONAL);
        GPSDirectory.add(25, "GPSDestDistanceRef", ImageMetaType.META_STRING);
        GPSDirectory.add(20, "GPSDestLatitude", ImageMetaType.META_URATIONAL);
        GPSDirectory.add(19, "GPSDestLatitudeRef", ImageMetaType.META_STRING);
        GPSDirectory.add(22, "GPSDestLongitude", ImageMetaType.META_URATIONAL);
        GPSDirectory.add(21, "GPSDestLongitudeRef", ImageMetaType.META_STRING);
        GPSDirectory.add(30, "GPSDifferential", ImageMetaType.META_USHORT);
        GPSDirectory.add(11, "GPSDop", ImageMetaType.META_URATIONAL);
        GPSDirectory.add(17, "GPSImgDirection", ImageMetaType.META_URATIONAL);
        GPSDirectory.add(16, "GPSImgDirectionRef", ImageMetaType.META_STRING);
        GPSDirectory.add(2, "GPSLatitude", ImageMetaType.META_URATIONAL);
        GPSDirectory.add(1, "GPSLatitudeRef", ImageMetaType.META_STRING);
        GPSDirectory.add(4, "GPSLongitude", ImageMetaType.META_URATIONAL);
        GPSDirectory.add(3, "GPSLongitudeRef", ImageMetaType.META_STRING);
        GPSDirectory.add(18, "GPSMapDatum", ImageMetaType.META_STRING);
        GPSDirectory.add(10, "GPSMeasureMode", ImageMetaType.META_STRING);
        GPSDirectory.add(27, "GPSProcessingMethod", ImageMetaType.META_UNDEFINED);
        GPSDirectory.add(8, "GPSSatellites", ImageMetaType.META_STRING);
        GPSDirectory.add(13, "GPSSpeed", ImageMetaType.META_URATIONAL);
        GPSDirectory.add(12, "GPSSpeedRef", ImageMetaType.META_STRING);
        GPSDirectory.add(9, "GPSStatus", ImageMetaType.META_STRING);
        GPSDirectory.add(7, "GPSTimeStamp", ImageMetaType.META_URATIONAL);
        GPSDirectory.add(15, "GPSTrack", ImageMetaType.META_URATIONAL);
        GPSDirectory.add(14, "GPSTrackRef", ImageMetaType.META_STRING);
        GPSDirectory.add(0, "GPSVersionID", ImageMetaType.META_UBYTE);
    }
}

