/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.MenuFactory;
import com.lightcrafts.app.menu.UpdatableDisposableMenu;
import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.ui.editor.Document;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

final class TemplatesMenu
extends UpdatableDisposableMenu {
    private WeakReference<Document> docRef = new WeakReference<Object>(null);

    TemplatesMenu(ComboFrame frame) {
        super(frame, "Templates");
        JMenuItem noneItem = MenuFactory.createMenuItem("NoTemplateDoc");
        noneItem.setEnabled(false);
        this.add(noneItem);
    }

    @Override
    void update() {
        Document oldDoc;
        ComboFrame frame = this.getComboFrame();
        Document newDoc = frame != null ? frame.getDocument() : null;
        if (newDoc != (oldDoc = (Document)this.docRef.get())) {
            try {
                this.removeAll();
                if (newDoc != null) {
                    List<TemplateKey> keys = TemplateDatabase.getTemplateKeys();
                    if (!keys.isEmpty()) {
                        LinkedHashMap nsMap = new LinkedHashMap();
                        for (TemplateKey key : keys) {
                            String namespace = key.getNamespace();
                            if (!nsMap.containsKey(namespace)) {
                                nsMap.put(namespace, new LinkedList());
                            }
                            ((LinkedList)nsMap.get(namespace)).add(key);
                        }
                        for (String namespace : nsMap.keySet()) {
                            JMenu nsItem = new JMenu(namespace);
                            List nsKeys = (List)nsMap.get(namespace);
                            for (final TemplateKey key : nsKeys) {
                                JMenuItem templateItem = new JMenuItem(key.getName());
                                templateItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent event) {
                                        ComboFrame frame = TemplatesMenu.this.getComboFrame();
                                        Application.applyTemplate(frame, key);
                                    }
                                });
                                nsItem.add(templateItem);
                            }
                            this.add(nsItem);
                        }
                        this.setEnabled(true);
                    } else {
                        JMenuItem noTemplatesItem = MenuFactory.createMenuItem("NoTemplates");
                        noTemplatesItem.setEnabled(false);
                        this.add(noTemplatesItem);
                    }
                } else {
                    JMenuItem noDocItem = MenuFactory.createMenuItem("NoTemplateDoc");
                    noDocItem.setEnabled(false);
                    this.add(noDocItem);
                }
            }
            catch (TemplateDatabase.TemplateException e) {
                this.setEnabled(false);
            }
            this.docRef = new WeakReference<Document>(newDoc);
        }
    }
}

