/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.MenuFactory;
import com.lightcrafts.app.menu.UpdatableDisposableMenu;
import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.ui.editor.Document;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenuItem;

final class TemplateMenu
extends UpdatableDisposableMenu {
    TemplateMenu(ComboFrame frame) {
        super(frame, "ApplyTemplate");
    }

    @Override
    void update() {
        Document doc;
        ComboFrame frame = this.getComboFrame();
        Document document = doc = frame != null ? frame.getDocument() : null;
        if (doc == null) {
            this.setEnabled(false);
            return;
        }
        try {
            this.removeAll();
            List<TemplateKey> keys = TemplateDatabase.getTemplateKeys();
            if (!keys.isEmpty()) {
                for (final TemplateKey key : keys) {
                    JMenuItem templateItem = new JMenuItem(key.toString());
                    templateItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            ComboFrame frame = TemplateMenu.this.getComboFrame();
                            Application.applyTemplate(frame, key);
                        }
                    });
                    this.add(templateItem);
                }
                this.setEnabled(true);
            } else {
                JMenuItem noneItem = MenuFactory.createMenuItem("NoTemplates");
                this.add(noneItem);
                this.setEnabled(false);
            }
        }
        catch (TemplateDatabase.TemplateException e) {
            this.setEnabled(false);
        }
    }
}

