/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.ActionMenuItem;
import com.lightcrafts.app.menu.Locale;
import com.lightcrafts.ui.action.ToggleAction;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.editor.EditorMode;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.Action;

class ShowHideRegionsMenuItem
extends ActionMenuItem {
    private static final String ShowRegionsText = Locale.LOCALE.get("ShowRegionsMenuItemText");
    private static final String HideRegionsText = Locale.LOCALE.get("HideRegionsMenuItemText");

    ShowHideRegionsMenuItem(ComboFrame frame) {
        super(frame, "ShowHideRegions");
    }

    @Override
    Action getDocumentAction() {
        final Document doc = this.getDocument();
        if (doc != null) {
            ToggleAction action = new ToggleAction(HideRegionsText, ShowRegionsText){

                @Override
                protected void onActionPerformed(ActionEvent event) {
                    EditorMode mode = doc.getEditor().getMode();
                    if (mode != EditorMode.REGION) {
                        doc.getEditor().setMode(EditorMode.REGION);
                    } else {
                        doc.getEditor().setMode(EditorMode.ARROW);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.setState(false);
                            }
                        });
                    }
                }

                @Override
                protected void offActionPerformed(ActionEvent event) {
                    EditorMode mode = doc.getEditor().getMode();
                    if (mode == EditorMode.REGION) {
                        doc.getEditor().setMode(EditorMode.ARROW);
                    } else {
                        doc.getEditor().setMode(EditorMode.REGION);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.setState(true);
                            }
                        });
                    }
                }
            };
            return action;
        }
        return null;
    }
}

