/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.EditorButton;
import com.lightcrafts.app.Locale;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;

class UndoButton
extends EditorButton
implements PropertyChangeListener {
    private static final Icon Icon = IconFactory.createInvertedIcon(UndoButton.class, "undo.png");
    private static final String ToolTip = Locale.LOCALE.get("UndoButtonToolTip");
    private Document doc;

    UndoButton(ComboFrame frame) {
        super(frame, Icon);
        this.setStyle(CoolButton.ButtonStyle.LEFT);
        this.setToolTipText(ToolTip);
        this.setEnabled(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UndoButton.this.doc.getUndoAction().actionPerformed(event);
            }
        });
    }

    @Override
    void updateButton() {
        Action action;
        ComboFrame frame = this.getComboFrame();
        Document newDoc = frame.getDocument();
        if (newDoc == this.doc) {
            return;
        }
        if (this.doc != null) {
            action = this.doc.getUndoAction();
            action.removePropertyChangeListener(this);
        }
        this.doc = newDoc;
        if (this.doc != null) {
            action = this.doc.getUndoAction();
            action.addPropertyChangeListener(this);
            this.setEnabled(action.isEnabled());
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Action action = (Action)evt.getSource();
        this.setEnabled(action.isEnabled());
    }
}

