/*
 * Decompiled with CFR 0.152.
 */
package main;

import dictionary.core.Dictionary;
import dictionary.core.SearchOptions;
import dictionary.simple.Language;
import dictionary.simple.SearchMode;
import java.io.File;
import java.util.Scanner;
import misc.GPLv3License;

public class Program {
    public static void main(String[] stringArray) {
        String string = "EnDe";
        GPLv3License gPLv3License = new GPLv3License(string, "1.0", "2010-2014", "Falco Preiseni");
        Dictionary dictionary = new Dictionary(Program.getWorkingDir() + "de-en.txt");
        Scanner scanner = new Scanner(System.in);
        String string2 = "";
        SearchOptions searchOptions = new SearchOptions();
        System.out.println(gPLv3License);
        System.out.println("Enter '.help' to get help.");
        while (true) {
            System.out.println("");
            System.out.println(searchOptions);
            System.out.print("> ");
            string2 = scanner.nextLine();
            if (string2.length() == 0) continue;
            for (int i = 0; i < 16; ++i) {
                System.out.println();
            }
            if (string2.startsWith(".")) {
                if (string2.contains("help")) {
                    System.out.println("Enter some word to seek it (case-sensitive!)\n");
                    System.out.println("OPTIONS\n");
                    System.out.println("Translation mode settings:");
                    System.out.println(".en\t\tset translation mode to: en -> ... (standard)");
                    System.out.println(".de\t\tset translation mode to: ... -> en");
                    System.out.println("");
                    System.out.println("Search settings (all case-sensitive!):");
                    System.out.println(".1\t\tenable " + (Object)((Object)SearchMode.STARTS_WITH) + " searching (default; entries match when they start with the search term)");
                    System.out.println(".2\t\tenable " + (Object)((Object)SearchMode.FUZZY) + " searching (entries match when they contain the search term)");
                    System.out.println("");
                    System.out.println("you can combine exactly ONE translation mode setting with ONE search setting");
                    System.out.println("example: .en1");
                    System.out.println("");
                    System.out.println(".exit \tto exit");
                } else if (string2.contains("exit")) {
                    System.out.println("exiting...");
                    System.exit(0);
                } else {
                    if (string2.contains("1")) {
                        searchOptions.setSearchMode(SearchMode.STARTS_WITH);
                    } else if (string2.contains("2")) {
                        searchOptions.setSearchMode(SearchMode.FUZZY);
                    }
                    if (string2.contains("en")) {
                        searchOptions.setLanguages(Language.ENGLISH, Language.GERMAN);
                    } else if (string2.contains("fl") || string2.contains("de")) {
                        searchOptions.setLanguages(Language.GERMAN, Language.ENGLISH);
                    }
                }
                System.out.println("");
                continue;
            }
            dictionary.searchAndPrint(string2, searchOptions);
        }
    }

    public static String getWorkingDir() {
        File file = new File("");
        return file.getAbsolutePath() + File.separator;
    }
}

