/*
 * Decompiled with CFR 0.152.
 */
package dictionary.core;

import dictionary.core.Form;
import dictionary.core.SearchOptions;
import dictionary.core.Term;
import dictionary.simple.Language;
import java.util.ArrayList;
import java.util.EnumMap;

public class Entry {
    private EnumMap<Language, ArrayList<Form>> forms = new EnumMap(Language.class);

    public Entry(String string) {
        this.forms.put(Language.ENGLISH, new ArrayList());
        this.forms.put(Language.GERMAN, new ArrayList());
        int n = string.indexOf("::");
        this.addForms(Language.GERMAN, string.substring(0, n));
        this.addForms(Language.ENGLISH, string.substring(n + 2));
    }

    private void addForms(Language language, String string) {
        ArrayList<Form> arrayList = this.forms.get((Object)language);
        int n = 0;
        int n2 = string.indexOf("|");
        while (n2 != -1) {
            arrayList.add(new Form(string.substring(n, n2)));
            n = n2 + 1;
            n2 = string.indexOf("|", n2 + 1);
        }
        arrayList.add(new Form(string.substring(n)));
        arrayList.trimToSize();
    }

    public ArrayList<Form> getForms(Language language) {
        return this.forms.get((Object)language);
    }

    public boolean search(String string, SearchOptions searchOptions) {
        ArrayList<Form> arrayList = this.forms.get((Object)searchOptions.getSourceLanguage());
        for (Form form : arrayList) {
            for (Term term : form.getTerms()) {
                boolean bl = false;
                switch (searchOptions.getSearchMode()) {
                    case EXACT: {
                        bl = term.getText().equals(string);
                        break;
                    }
                    case FUZZY: {
                        bl = term.getText().contains(string);
                        break;
                    }
                    default: {
                        bl = term.getText().startsWith(string);
                    }
                }
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    public void print(Language language, Language language2) {
        ArrayList<Form> arrayList = this.forms.get((Object)language);
        ArrayList<Form> arrayList2 = this.forms.get((Object)language2);
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            System.out.println(arrayList.get(i).termsToString() + " --- " + arrayList2.get(i).termsToString());
        }
        System.out.println("");
    }
}

