/*
	file automatically generated by make_test_files.pl
	Tue Feb  9 11:21:29 2010
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for TDR
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );



/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */
double pdf( double x, const UNUR_DISTR *distr );

double pdf_bimodal( double x, const UNUR_DISTR *distr );
double dpdf_bimodal( double x, const UNUR_DISTR *distr );

double pdf_negative( double x, const UNUR_DISTR *distr );
double dpdf_negative( double x, const UNUR_DISTR *distr );

double pdf_partnegative( double x, const UNUR_DISTR *distr );
double dpdf_partnegative( double x, const UNUR_DISTR *distr );

#define COMPARE_SAMPLE_SIZE   (10000)
#define VIOLATE_SAMPLE_SIZE   (20)




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



/* pdf of bimodal density */
double pdf_bimodal( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ 
	return ( exp(-(x-1.)*(x-1.)) + exp(-(x+1.)*(x+1.)) );
}
double dpdf_bimodal( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ 
	return ( -2. * (x-1.) * exp(-(x-1.)*(x-1.)) -2. * (x+1.) * exp(-(x+1.)*(x+1.)) );
}

/* pdf with negative value */
double pdf_negative( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
	return (-x*x);
}
double dpdf_negative( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
	return (-2.*x);
}

/* pdf with partial negative value */
double pdf_partnegative( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)  
{ 
	return ((x>-0.89 && x<0.89) ? -1.: exp(-x*x)); 
}
double dpdf_partnegative( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED) 
{
	return ((x>-0.89 && x<0.89) ?0.: -2.*x*exp(-x*x));
}

/* pdf of normal density */
double pdf( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ 
	return exp(-x*x/2.);
} /* end of pdf */

/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,36,(unur_tdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,36,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,42,(unur_tdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,42,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* data missing in distribution object */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
/* pdf, dpdf */
n_tests_failed += (check_expected_NULL(TESTLOG,49,(unur_tdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,49,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* dpdf */
unur_distr_cont_set_pdf(distr,pdf);
n_tests_failed += (check_expected_NULL(TESTLOG,54,(unur_tdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,54,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,64,(unur_tdr_set_cpoints( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,64,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,67,(unur_tdr_set_reinit_percentiles( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,67,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,70,(unur_tdr_set_guidefactor( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,70,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,73,(unur_tdr_set_max_sqhratio( par, 0.95 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,73,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,76,(unur_tdr_set_max_intervals( par, 100 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,76,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,79,(unur_tdr_set_usecenter( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,79,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,82,(unur_tdr_set_usemode( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,82,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,85,(unur_tdr_set_variant_gw( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,85,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,88,(unur_tdr_set_variant_ps( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,88,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,91,(unur_tdr_set_variant_ia( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,91,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,94,(unur_tdr_set_usedars( par, TRUE )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,94,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,97,(unur_tdr_set_darsfactor( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,97,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,100,(unur_tdr_set_c( par, -0.5 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,100,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,103,(unur_tdr_set_verify( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,103,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,106,(unur_tdr_set_pedantic( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,106,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid parameter object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_arou_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,115,(unur_tdr_set_cpoints( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,115,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,118,(unur_tdr_set_reinit_percentiles( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,118,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,121,(unur_tdr_set_guidefactor( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,121,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,124,(unur_tdr_set_max_sqhratio( par, 0.95 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,124,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,127,(unur_tdr_set_max_intervals( par, 100 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,127,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,130,(unur_tdr_set_usecenter( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,130,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,133,(unur_tdr_set_usemode( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,133,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,136,(unur_tdr_set_variant_gw( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,136,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,139,(unur_tdr_set_variant_ps( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,139,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,142,(unur_tdr_set_variant_ia( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,142,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,145,(unur_tdr_set_usedars( par, TRUE )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,145,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,148,(unur_tdr_set_darsfactor( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,148,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,151,(unur_tdr_set_c( par, -0.5 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,151,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,154,(unur_tdr_set_verify( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,154,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,157,(unur_tdr_set_pedantic( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,157,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double perc[] = {0.1,0.4,0.2};
   double stp[] = {1.,0.,1.};
   int n_stp = 3;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_tdr_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,170,(unur_tdr_set_cpoints( par, -1, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,170,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,173,(unur_tdr_set_cpoints( par, n_stp, stp )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,173,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_tdr_set_reinit_percentiles( par, -1, NULL );
n_tests_failed += (check_errorcode(TESTLOG,176,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,179,(unur_tdr_set_reinit_percentiles( par, n_stp, stp )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,179,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,182,(unur_tdr_set_reinit_percentiles( par, n_stp, perc )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,182,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,185,(unur_tdr_set_guidefactor( par, -1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,185,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,188,(unur_tdr_set_max_sqhratio( par, -1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,188,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,191,(unur_tdr_set_max_sqhratio( par, 2. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,191,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,194,(unur_tdr_set_max_intervals( par, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,194,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,197,(unur_tdr_set_usedars( par, -1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,197,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,200,(unur_tdr_set_darsfactor( par, -1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,200,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,203,(unur_tdr_set_c( par, 0.5 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,203,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,206,(unur_tdr_set_c( par, -0.6 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,206,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_tdr_set_c( par, -0.3 );
n_tests_failed += (check_errorcode(TESTLOG,209,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [get] */

void test_get (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[get "); fflush(stdout);
	fprintf(TESTLOG,"\n[get]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_arou_new(distr);
   gen = unur_init(par); 
abort_if_NULL(TESTLOG, 219,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,223,(unur_tdr_get_sqhratio(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,223,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,226,(unur_tdr_get_hatarea(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,226,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,229,(unur_tdr_get_squeezearea(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,229,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_get() */

/*---------------------------------------------------------------------------*/
/* [chg] */

void test_chg (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[chg "); fflush(stdout);
	fprintf(TESTLOG,"\n[chg]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_arou_new(distr);
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 240,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,244,(unur_tdr_chg_reinit_percentiles(gen, -1, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,244,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,247,(unur_tdr_chg_verify(gen,1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,247,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double percmon[] = {0.1,0.4,0.2};
   double percdom[] = {0.1,0.4,2.};
   int n_perc = 3;
   distr = unur_distr_normal(NULL,0);
   par = unur_tdr_new(distr); 
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 256,    gen );


unur_reset_errno();
unur_tdr_chg_reinit_percentiles( gen, -1, NULL );
n_tests_failed += (check_errorcode(TESTLOG,260,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,263,(unur_tdr_chg_reinit_percentiles( gen, n_perc, percmon )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,263,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,266,(unur_tdr_chg_reinit_percentiles( gen, n_perc, percdom )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,266,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_chg() */

/*---------------------------------------------------------------------------*/
/* [init] */

void test_init (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[init "); fflush(stdout);
	fprintf(TESTLOG,"\n[init]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,277,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,277,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* stp out of domain */
UNUR_GEN   *gen = NULL;
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double stp[] = {-2.5,-1.,0.,1.,2.5};
   int n_stp = 5;
   gen = NULL;
   distr = unur_distr_normal(NULL,0);
   unur_distr_cont_set_domain(distr,-2.,2.);
   par = unur_tdr_new(distr);
   unur_tdr_set_usedars(par,FALSE);
   unur_tdr_set_cpoints( par, n_stp, stp ); 


unur_reset_errno();
gen = unur_init( par );
n_tests_failed += (check_errorcode(TESTLOG,290,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;
unur_free(gen);
unur_distr_free(distr);
}

{ /* bimodal */
UNUR_GEN   *gen = NULL;
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   gen = NULL;
   distr = unur_distr_cont_new(); 
   unur_distr_cont_set_pdf(distr,pdf_bimodal);
   unur_distr_cont_set_dpdf(distr,dpdf_bimodal);
   par = unur_tdr_new(distr);
   unur_tdr_set_usedars(par,FALSE);
   unur_tdr_set_cpoints( par, 30, NULL ); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,302,(gen = unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,302,UNUR_ERR_GEN_CONDITION)==UNUR_SUCCESS)?0:1;
unur_free(gen);
unur_distr_free(distr);
}

{ /* wrong mode */
UNUR_GEN   *gen = NULL;
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = NULL; 


unur_reset_errno();
unur_distr_cont_set_mode(distr,-1.);
par = unur_tdr_new(distr);
unur_tdr_set_usedars(par,FALSE);
unur_tdr_set_cpoints( par, 30, NULL );
n_tests_failed += (check_expected_NULL(TESTLOG,314,(gen = unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,314,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_distr_cont_set_mode(distr,1.);
par = unur_tdr_new(distr);
unur_tdr_set_usedars(par,FALSE);
unur_tdr_set_cpoints( par, 30, NULL );
gen = unur_init( par );
n_tests_failed += (check_errorcode(TESTLOG,321,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;
unur_free(gen);
unur_distr_free(distr);
}

{ /* negative value of pdf */
UNUR_GEN   *gen = NULL;
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   gen = NULL;
   distr = unur_distr_cont_new(); 
   unur_distr_cont_set_pdf(distr,pdf_negative);
   unur_distr_cont_set_dpdf(distr,dpdf_negative);
   par = NULL; 


unur_reset_errno();
par = unur_tdr_new(distr);
unur_tdr_set_usedars(par,FALSE);
unur_tdr_set_cpoints( par, 30, NULL );
n_tests_failed += (check_expected_NULL(TESTLOG,334,(gen = unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,334,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_distr_cont_set_domain(distr,-2.,2.);
par = unur_tdr_new(distr);
unur_tdr_set_usedars(par,FALSE);
unur_tdr_set_cpoints( par, 30, NULL );
n_tests_failed += (check_expected_NULL(TESTLOG,341,(gen = unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,341,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;
unur_free(gen);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_init() */

/*---------------------------------------------------------------------------*/
/* [reinit] */

void test_reinit (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[reinit "); fflush(stdout);
	fprintf(TESTLOG,"\n[reinit]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* exist */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_tdr_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 349,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_reinit(TESTLOG,353,(unur_reinit( gen )))==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_reinit() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_GEN   *gen = NULL;
   gen = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,363,(unur_tdr_eval_invcdfhat(gen,0.5,NULL,NULL,NULL)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,363,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_free(gen);
}

{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_arou_new(distr);
   gen = unur_init(par); 
abort_if_NULL(TESTLOG, 369,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,373,(unur_tdr_eval_invcdfhat(gen,0.5,NULL,NULL,NULL)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,373,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* invalid domain */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_tdr_new(distr);
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 380,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,384,(unur_tdr_eval_invcdfhat(gen,1.5,NULL,NULL,NULL)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,384,UNUR_ERR_DOMAIN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_negINFINITY(TESTLOG,387,(unur_tdr_eval_invcdfhat(gen,-0.5,NULL,NULL,NULL)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,387,UNUR_ERR_DOMAIN)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* partial negative value of pdf */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   int i;
   double x;
   double stp[] = {-0.9,0.9};
   int n_stp = 2;
   distr = unur_distr_cont_new();
   unur_distr_cont_set_pdf(distr,pdf_partnegative);
   unur_distr_cont_set_dpdf(distr,dpdf_partnegative);
   par = unur_tdr_new(distr);
   unur_tdr_set_usedars(par,FALSE);
   unur_tdr_set_usecenter(par,FALSE);
   unur_tdr_set_cpoints( par, n_stp, stp );
   unur_tdr_set_pedantic( par, 1 );
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 403,    gen );


unur_reset_errno();
for (i=0; i<100; i++) { x = unur_sample_cont(gen); }
n_tests_failed += (check_expected_INFINITY(TESTLOG,408,(x))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,408,UNUR_ERR_GEN_CONDITION)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = unur_distr_normal(NULL,0); 
   par = NULL; 


unur_reset_errno();
/* GW, c = -0.5 */
par = unur_tdr_new(distr);
unur_tdr_set_variant_gw(par);
unur_tdr_set_c(par,-0.5);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par_start(TESTLOG,423,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* GW, c = -0.5 - verifying mode */
par = unur_tdr_new(distr);
unur_tdr_set_variant_gw(par);
unur_tdr_set_c(par,-0.5);
unur_tdr_set_verify(par,1);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par(TESTLOG,431,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* PS, c = -0.5 */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ps(par);
unur_tdr_set_c(par,-0.5);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par_start(TESTLOG,438,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* PS, c = -0.5 - verifying mode */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ps(par);
unur_tdr_set_c(par,-0.5);
unur_tdr_set_verify(par,1);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par(TESTLOG,446,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* IA, c = -0.5 */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ia(par);
unur_tdr_set_c(par,-0.5);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par_start(TESTLOG,453,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* IA, c = -0.5 - verifying mode */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ia(par);
unur_tdr_set_c(par,-0.5);
unur_tdr_set_verify(par,1);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par(TESTLOG,461,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* GW, c = 0 */
par = unur_tdr_new(distr);
unur_tdr_set_variant_gw(par);
unur_tdr_set_c(par,0.);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par_start(TESTLOG,471,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* GW, c = 0, verifying mode */
par = unur_tdr_new(distr);
unur_tdr_set_variant_gw(par);
unur_tdr_set_c(par,0.);
unur_tdr_set_verify(par,1);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par(TESTLOG,479,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* PS, c = 0 */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ps(par);
unur_tdr_set_c(par,0.);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par_start(TESTLOG,486,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* PS, c = 0, verifying mode */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ps(par);
unur_tdr_set_c(par,0.);
unur_tdr_set_verify(par,1);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par(TESTLOG,494,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* IA, c = 0 */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ia(par);
unur_tdr_set_c(par,0.);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par_start(TESTLOG,501,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* IA, c = 0, verifying mode */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ia(par);
unur_tdr_set_c(par,0.);
unur_tdr_set_verify(par,1);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par(TESTLOG,509,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   distr = unur_distr_normal(NULL,0); 
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_tdr_new(distr);
unur_tabl_set_max_sqhratio(par,0.);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,523,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,529,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare stringparser */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {3.,3.};
   distr = NULL;
   par = NULL;
   gen = NULL; 


unur_reset_errno();
distr = unur_distr_gamma(fpar,2);
unur_distr_cont_set_center(distr,2.1);
par = unur_tdr_new(distr);
unur_tdr_set_cpoints(par,20,NULL);
unur_tdr_set_guidefactor(par,2.);
unur_tdr_set_max_intervals(par,32);
unur_tdr_set_max_sqhratio(par,0.9);
unur_tdr_set_usecenter(par,TRUE);
unur_tdr_set_verify(par,TRUE);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,549,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.); center = 2.1 & \
  method = tdr; usecenter; cpoints = 20; guidefactor = 2.; \
  max_intervals = 32; max_sqhratio = 0.9; verify" );
n_tests_failed += (compare_sequence_gen(TESTLOG,556,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_gamma(fpar,2);
par = unur_tdr_new(distr);
unur_tdr_set_cpoints(par,9,NULL);
unur_tdr_set_pedantic(par,TRUE);
unur_tdr_set_usemode(par,FALSE);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,566,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & \
  method = tdr; cpoints = 9; pedantic; usemode = false" );
n_tests_failed += (compare_sequence_gen(TESTLOG,572,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_gamma(fpar,2);
par = unur_tdr_new(distr);
unur_tdr_set_c(par,0.);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,580,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & \
  method = tdr; c = 0." );
n_tests_failed += (compare_sequence_gen(TESTLOG,586,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_gamma(fpar,2);
par = unur_tdr_new(distr);
unur_tdr_set_c(par,-0.5);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,594,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & \
  method = tdr; c = -0.5" );
n_tests_failed += (compare_sequence_gen(TESTLOG,600,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_gamma(fpar,2);
par = unur_tdr_new(distr);
unur_tdr_set_variant_gw(par);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,608,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & \
  method = tdr; variant_gw" );
n_tests_failed += (compare_sequence_gen(TESTLOG,614,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_gamma(fpar,2);
par = unur_tdr_new(distr);
unur_tdr_set_variant_ia(par);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,622,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & \
  method = tdr; variant_ia" );
n_tests_failed += (compare_sequence_gen(TESTLOG,628,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_gamma(fpar,2);
par = unur_tdr_new(distr);
unur_tdr_set_variant_ps(par);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,636,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & \
  method = tdr; variant_ps" );
n_tests_failed += (compare_sequence_gen(TESTLOG,642,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_tdr_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */


/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_tdr_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_tdr_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 859459;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 859459;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("tdr: ");

	/* run tests */
test_new();
test_set();
test_get();
test_chg();
test_init();
test_reinit();
test_sample();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

