/*
	file automatically generated by make_test_files.pl
	Tue Feb  9 11:21:07 2010
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for MIXT
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );

int unur_mixt_set_verify( UNUR_PAR *par, int verify);


/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */

double cdf_cont_1 ( double x, const UNUR_DISTR *distr );
double cdf_cont_inv ( double x, const UNUR_DISTR *distr );

#define COMPARE_SAMPLE_SIZE   (10000)
#define VIOLATE_SAMPLE_SIZE   (20)

/* #define SEED (1656256) */




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



double cdf_cont_1 ( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED )
{
   static UNUR_DISTR *d0 = NULL;
   static UNUR_DISTR *d1 = NULL;
   static UNUR_DISTR *d2 = NULL;
   double p[3] = {1./6., 2./6., 3./6.};
   double y;

   if (d0 == NULL) {
      d0 = unur_distr_exponential(NULL,0);
   }
   if (d1 == NULL) {
      d1 = unur_distr_normal(NULL,0);
   }
   if (d2 == NULL) {
      double fpar[2] = {-2,-1};
      d2 = unur_distr_uniform(fpar,2);
   }

   y = ( p[0] * unur_distr_cont_eval_cdf(x,d0) + 
         p[1] * unur_distr_cont_eval_cdf(x,d1) + 
	 p[2] * unur_distr_cont_eval_cdf(x,d2) ); 
   
   return y;
}

double cdf_cont_inv ( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED )
{
   static UNUR_DISTR *d = NULL;
   double p[3] = {1./6., 2./6., 3./6.};
   double y;

   if (d == NULL) {
      d = unur_distr_normal(NULL,0);
   }

   if (x < -1.) {
      y = p[0] * unur_distr_cont_eval_cdf(x,d) / 0.1586553;
   }
   else if (x < 1.) {
      y = p[0] + p[1] * (unur_distr_cont_eval_cdf(x,d) - 0.1586553) / (0.8413447 - 0.1586553);
   }
   else {
      y = p[0] + p[1] + p[2] * (unur_distr_cont_eval_cdf(x,d) - 0.8413447) / (1 - 0.8413447);
   }

   return y;
}

/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
   double prob[2] = {1,2}; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,31,(unur_mixt_new( 0, NULL, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,31,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,34,(unur_mixt_new( 2, prob, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,34,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid arguments */
   double prob[2] = {1,2};
   UNUR_GEN *comp[2]; 

comp[0] = unur_str2gen("normal");
comp[1] = unur_str2gen("normal");

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,45,(unur_mixt_new( -1, prob, comp )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,45,UNUR_ERR_DISTR_DOMAIN)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,59,(unur_mixt_set_useinversion(par,0.)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,59,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid parameter object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_arou_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,66,(unur_mixt_set_useinversion(par,0.)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,66,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [init] */

void test_init (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[init "); fflush(stdout);
	fprintf(TESTLOG,"\n[init]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL in list of components */
UNUR_PAR   *par = NULL;
   double prob[2] = {1,2};
   UNUR_GEN *comp[2] = {NULL, NULL}; 
   par = unur_mixt_new(2,prob,comp); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,88,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,88,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid distribution type */
   double prob[2] = {1,2};
   UNUR_DISTR *distr;
   UNUR_PAR *par;
   UNUR_GEN *comp[2]; 

distr = unur_distr_multinormal(2,NULL,NULL);
comp[0] = unur_init(unur_hitro_new(distr));
comp[1] = unur_str2gen("normal");

unur_reset_errno();
par = unur_mixt_new( 2, prob, comp );
n_tests_failed += (check_expected_NULL(TESTLOG,102,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,102,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(comp[0]);
unur_free(comp[1]);
}

{ /* invalid probabilities */
   double prob[2] = {1,-2};
   UNUR_PAR *par;
   UNUR_GEN *comp[2]; 

comp[0] = unur_str2gen("normal");
comp[1] = unur_str2gen("normal");

unur_reset_errno();
par = unur_mixt_new( 2, prob, comp );
n_tests_failed += (check_expected_NULL(TESTLOG,119,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,119,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
}

{ /* no inversion method */
   double prob[2] = {1,2};
   UNUR_PAR *par;
   UNUR_GEN *comp[2]; 

comp[0] = unur_str2gen("normal&method=ssr");
comp[1] = unur_str2gen("normal&method=ssr");

unur_reset_errno();
par = unur_mixt_new( 2, prob, comp );
unur_mixt_set_useinversion(par,TRUE);
n_tests_failed += (check_expected_NULL(TESTLOG,136,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,136,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
}

{ /* overlapping domains cont+cont */
   double prob[2] = {1,2};
   UNUR_PAR *par;
   UNUR_GEN *comp[2]; 

comp[0] = unur_str2gen("normal;domain=(-2,1)&method=pinv");
comp[1] = unur_str2gen("normal;domain=(-1,2)&method=pinv");

unur_reset_errno();
par = unur_mixt_new( 2, prob, comp );
unur_mixt_set_useinversion(par,TRUE);
n_tests_failed += (check_expected_NULL(TESTLOG,153,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,153,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
}

{ /* overlapping domains cont+discr */
   double prob[2] = {1,2};
   UNUR_PAR *par;
   UNUR_GEN *comp[2]; 

comp[0] = unur_str2gen("normal;domain=(-2,3)&method=pinv");
comp[1] = unur_str2gen("binomial(100,0.2)&method=dgt");

unur_reset_errno();
par = unur_mixt_new( 2, prob, comp );
unur_mixt_set_useinversion(par,TRUE);
n_tests_failed += (check_expected_NULL(TESTLOG,170,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,170,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
}

{ /* overlapping domains discr+discr */
   double prob[2] = {1,2};
   UNUR_PAR *par;
   UNUR_GEN *comp[2]; 

comp[0] = unur_str2gen("geometric(0.1)&method=dgt");
comp[1] = unur_str2gen("binomial(100,0.2)&method=dgt");

unur_reset_errno();
par = unur_mixt_new( 2, prob, comp );
unur_mixt_set_useinversion(par,TRUE);
n_tests_failed += (check_expected_NULL(TESTLOG,187,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,187,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
}

{ /* unsorted domains */
   double prob[2] = {1,2};
   UNUR_PAR *par;
   UNUR_GEN *comp[2]; 

comp[0] = unur_str2gen("normal;domain=(1,2)&method=pinv");
comp[1] = unur_str2gen("normal;domain=(-2,-1)&method=pinv");

unur_reset_errno();
par = unur_mixt_new( 2, prob, comp );
unur_mixt_set_useinversion(par,TRUE);
n_tests_failed += (check_expected_NULL(TESTLOG,204,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,204,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_init() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* compare clone cont+cont */
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   double prob[2] = {1,2};
   UNUR_GEN *comp[2];
   par = NULL;
   gen = NULL; 

comp[0] = unur_str2gen("normal");
comp[1] = unur_str2gen("exponential");

unur_reset_errno();
/* original generator object */
par = unur_mixt_new( 2, prob, comp );
gen = unur_init( par );
n_tests_failed += (compare_sequence_gen_start(TESTLOG,231,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,237,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
unur_free(gen);
}

{ /* compare clone cont+discr */
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   double prob[2] = {1,2};
   UNUR_GEN *comp[2];
   par = NULL;
   gen = NULL; 

comp[0] = unur_str2gen("normal&method=tdr");
comp[1] = unur_str2gen("binomial(100,0.2)&method=dgt");

unur_reset_errno();
/* original generator object */
par = unur_mixt_new( 2, prob, comp );
gen = unur_init( par );
n_tests_failed += (compare_sequence_gen_start(TESTLOG,257,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,263,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
unur_free(gen);
}

{ /* compare clone discr+discr */
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   double prob[2] = {1,2};
   UNUR_GEN *comp[2];
   par = NULL;
   gen = NULL; 

comp[0] = unur_str2gen("geometric(0.1)&method=dgt");
comp[1] = unur_str2gen("binomial(100,0.2)&method=dgt");

unur_reset_errno();
/* original generator object */
par = unur_mixt_new( 2, prob, comp );
gen = unur_init( par );
n_tests_failed += (compare_sequence_gen_start(TESTLOG,283,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,289,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
unur_free(gen);
}

{ /* compare clone cont+discr */
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   double prob[2] = {1,2};
   UNUR_GEN *comp[2];
   par = NULL;
   gen = NULL; 

comp[0] = unur_str2gen("normal");
comp[1] = unur_str2gen("binomial(100,0.2)&method=dgt");

unur_reset_errno();
/* original generator object */
par = unur_mixt_new( 2, prob, comp );
gen = unur_init( par );
n_tests_failed += (compare_sequence_gen_start(TESTLOG,309,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,315,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
unur_free(gen);
}

{ /* compare clone empirical+discr */
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   double prob[2] = {1,2};
   UNUR_GEN *comp[2];
   par = NULL;
   gen = NULL; 

comp[0] = unur_str2gen("distr = cemp; \
                        data=(-0.10, 0.05,-0.50, 0.08, 0.13,  \
                               -0.21,-0.44,-0.43,-0.33,-0.30, \
                                0.18, 0.20,-0.37,-0.29,-0.90) \
                        & method=empk; smoothing=0.8");
comp[1] = unur_str2gen("binomial(100,0.2)&method=dgt");

unur_reset_errno();
/* original generator object */
par = unur_mixt_new( 2, prob, comp );
gen = unur_init( par );
n_tests_failed += (compare_sequence_gen_start(TESTLOG,339,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,345,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
unur_free(gen);
}

{ /* compare clone mixt+cont */
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   double prob[2] = {1,2};
   UNUR_GEN *comp[2];
   par = NULL;
   gen = NULL; 

comp[0] = unur_str2gen("normal&method=tdr");
comp[1] = unur_str2gen("exponential&method=arou");
par = unur_mixt_new( 2, prob, comp );
gen = unur_init( par );
unur_free(comp[0]);
unur_free(comp[1]);
comp[0] = gen;
comp[1] = unur_str2gen("cauchy&method=srou");

unur_reset_errno();
/* original generator object */
par = unur_mixt_new( 2, prob, comp );
gen = unur_init( par );
n_tests_failed += (compare_sequence_gen_start(TESTLOG,372,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,378,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
unur_free(gen);
}

{ /* compare clone mixt+cont+inversion */
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   double prob[2] = {1,2};
   UNUR_GEN *comp[2];
   par = NULL;
   gen = NULL; 

comp[0] = unur_str2gen("normal;domain=(-inf,-1)&method=pinv");
comp[1] = unur_str2gen("normal;domain=(-1,1)&method=pinv");
par = unur_mixt_new( 2, prob, comp );
unur_mixt_set_useinversion(par,TRUE);
gen = unur_init( par );
unur_free(comp[0]);
unur_free(comp[1]);
comp[0] = gen;
comp[1] = unur_str2gen("normal;domain=(1,inf)&method=pinv");

unur_reset_errno();
/* original generator object */
par = unur_mixt_new( 2, prob, comp );
unur_mixt_set_useinversion(par,TRUE);
gen = unur_init( par );
n_tests_failed += (compare_sequence_gen_start(TESTLOG,407,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,413,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_free(comp[0]);
unur_free(comp[1]);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [special] */

void test_special (void)
{
	/* set boolean to FALSE */
	int FAILED = 0;





int rcode = 0;
int errorsum = 0;

UNUR_DISTR *dtmp;
UNUR_PAR *par;
UNUR_GEN *gen;
UNUR_GEN *comp[3];
double prob[3] = {1.,2.,3.};

/* start test */
printf("[special "); fflush(stdout);
fprintf(TESTLOG,"\n[special]\n");

/* set stop watch */
stopwatch_lap(&watch);



/* very ugly hack */

comp[0] = unur_str2gen("exponential&method=pinv");
comp[1] = unur_str2gen("normal&method=pinv");
comp[2] = unur_str2gen("uniform(-2,-1)&method=pinv");

unur_reset_errno();
par = unur_mixt_new( 3, prob, comp );
gen = unur_init(par);
dtmp = unur_get_distr(gen);
unur_distr_set_name(dtmp,"cont");
unur_distr_cont_set_cdf(dtmp,cdf_cont_1);
rcode = run_validate_chi2(TESTLOG,0,gen,dtmp,'+');
errorsum += (rcode==UNUR_SUCCESS)?0:1;
unur_free(gen);

unur_free(comp[0]);
unur_free(comp[1]);
unur_free(comp[2]);

/* ---------------------------------- */

comp[0] = unur_str2gen("normal;domain=(-inf,-1)&method=pinv");
comp[1] = unur_str2gen("normal;domain=(-1,1)&method=pinv");
comp[2] = unur_str2gen("normal;domain=(1,inf)&method=pinv");

unur_reset_errno();
par = unur_mixt_new( 3, prob, comp );
gen = unur_init(par);
dtmp = unur_get_distr(gen);
unur_distr_set_name(dtmp,"cont");
unur_distr_cont_set_cdf(dtmp,cdf_cont_inv);
rcode = run_validate_chi2(TESTLOG,0,gen,dtmp,'+');
errorsum += (rcode==UNUR_SUCCESS)?0:1;
unur_free(gen);

unur_free(comp[0]);
unur_free(comp[1]);
unur_free(comp[2]);

comp[0] = unur_str2gen("normal;domain=(-inf,-1)&method=pinv");
comp[1] = unur_str2gen("normal;domain=(-1,1)&method=pinv");
comp[2] = unur_str2gen("normal;domain=(1,inf)&method=pinv");

unur_reset_errno();
par = unur_mixt_new( 3, prob, comp );
unur_mixt_set_useinversion(par,TRUE);
gen = unur_init(par);
dtmp = unur_get_distr(gen);
unur_distr_set_name(dtmp,"cont_inv");
unur_distr_cont_set_cdf(dtmp,cdf_cont_inv);
rcode = run_validate_chi2(TESTLOG,0,gen,dtmp,'+');
errorsum += (rcode==UNUR_SUCCESS)?0:1;
unur_free(gen);

unur_free(comp[0]);
unur_free(comp[1]);
unur_free(comp[2]);

/* ---------------------------------- */

/* test finished */
FAILED = (errorsum < 1) ? 0 : 1;




	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (FAILED) ? 0 : 1;
	(FAILED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_special() */


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_mixt_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */

int unur_mixt_set_verify(UNUR_PAR *par ATTRIBUTE__UNUSED, int verify ATTRIBUTE__UNUSED) {return 0;}

/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_mixt_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_mixt_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 954526;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 954526;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("mixt: ");

	/* run tests */
test_new();
test_set();
test_init();
test_sample();
test_special();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

