/*
	file automatically generated by make_test_files.pl
	Tue Feb  9 11:21:48 2010
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for TDRGW
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );



/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */
double logpdf_normal_1( double x, const UNUR_DISTR *distr );
double dlogpdf_normal_1( double x, const UNUR_DISTR *distr );
double cdf_normal_1( double x, const UNUR_DISTR *distr );
double logpdf_normal_2( double x, const UNUR_DISTR *distr );
double dlogpdf_normal_2( double x, const UNUR_DISTR *distr );
double cdf_normal_2( double x, const UNUR_DISTR *distr );

#define COMPARE_SAMPLE_SIZE   (10000)
#define VIOLATE_SAMPLE_SIZE   (20)

/* #define SEED   (298346) */




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



/* logPDF of normal density */
double logpdf_normal_1( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
	return (-x*x/2. - 10000.);
}
double dlogpdf_normal_1( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
	return (-x);
}

double cdf_normal_1( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED) 
{ 
	static UNUR_DISTR *normal = NULL;
	static double fpm[2] = {0., 1.};
	if (normal == NULL) normal = unur_distr_normal(fpm,2);
	return unur_distr_cont_eval_cdf( x, normal );
}

/* ......................................................................... */

#define mu_2 (100.)

double logpdf_normal_2( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
	return (-(x-mu_2)*(x-mu_2)/2. - 10000.);
}
double dlogpdf_normal_2( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
	return (-(x-mu_2));
}

double cdf_normal_2( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED) 
{ 
	static UNUR_DISTR *normal_2 = NULL;
	static double fpm[2] = {mu_2, 1.};
	if (normal_2 == NULL) normal_2 = unur_distr_normal(fpm,2);
	return unur_distr_cont_eval_cdf( x, normal_2 );
}

/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,34,(unur_tdrgw_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,34,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,40,(unur_tdrgw_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,40,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* data missing in distribution object */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_normal_wo_logpdf(NULL,0); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,46,(unur_tdrgw_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,46,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* data missing in distribution object */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
/* logpdf, dlogpdf */
n_tests_failed += (check_expected_NULL(TESTLOG,54,(unur_tdrgw_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,54,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* dlogpdf */
unur_distr_cont_set_logpdf(distr,logpdf_normal_1);
n_tests_failed += (check_expected_NULL(TESTLOG,59,(unur_tdrgw_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,59,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,69,(unur_tdrgw_set_cpoints( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,69,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,72,(unur_tdrgw_set_reinit_percentiles( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,72,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,75,(unur_tdrgw_set_reinit_ncpoints( par, 20 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,75,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,78,(unur_tdrgw_set_max_intervals( par, 100 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,78,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,81,(unur_tdrgw_set_verify( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,81,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,84,(unur_tdrgw_set_pedantic( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,84,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid parameter object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_tdr_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,92,(unur_tdrgw_set_cpoints( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,92,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,95,(unur_tdrgw_set_reinit_percentiles( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,95,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,98,(unur_tdrgw_set_reinit_ncpoints( par, 30 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,98,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,101,(unur_tdrgw_set_max_intervals( par, 100 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,101,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,104,(unur_tdrgw_set_verify( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,104,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,107,(unur_tdrgw_set_pedantic( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,107,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double stp[] = {1.,0.,1.};
   double perc[] = {0.1,0.4,0.2};
   int n_stp = 3;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_tdrgw_new(distr); 


unur_reset_errno();
unur_tdrgw_set_cpoints( par, -1, NULL );
n_tests_failed += (check_errorcode(TESTLOG,120,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,123,(unur_tdrgw_set_cpoints( par, n_stp, stp )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,123,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_tdrgw_set_reinit_percentiles( par, -1, NULL );
n_tests_failed += (check_errorcode(TESTLOG,126,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,129,(unur_tdrgw_set_reinit_percentiles( par, n_stp, stp )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,129,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,132,(unur_tdrgw_set_reinit_percentiles( par, n_stp, perc )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,132,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,135,(unur_tdrgw_set_reinit_ncpoints( par, 9 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,135,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,138,(unur_tdrgw_set_max_intervals( par, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,138,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [get] */

void test_get (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[get "); fflush(stdout);
	fprintf(TESTLOG,"\n[get]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_tdr_new(distr);
   gen = unur_init(par); 
abort_if_NULL(TESTLOG, 148,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,152,(unur_tdrgw_get_loghatarea(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,152,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_get() */

/*---------------------------------------------------------------------------*/
/* [chg] */

void test_chg (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[chg "); fflush(stdout);
	fprintf(TESTLOG,"\n[chg]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_tdr_new(distr);
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 162,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,166,(unur_tdrgw_chg_verify(gen,1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,166,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,169,(unur_tdrgw_chg_reinit_percentiles(gen, -1, NULL)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,169,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,172,(unur_tdrgw_chg_reinit_ncpoints(gen, 30)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,172,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double percmon[] = {0.1,0.4,0.2};
   double percdom[] = {0.1,0.4,2.};
   int n_perc = 3;
   distr = unur_distr_normal(NULL,0);
   par = unur_tdrgw_new(distr); 
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 181,    gen );


unur_reset_errno();
unur_tdrgw_chg_reinit_percentiles( gen, -1, NULL );
n_tests_failed += (check_errorcode(TESTLOG,185,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,188,(unur_tdrgw_chg_reinit_percentiles( gen, n_perc, percmon )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,188,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,191,(unur_tdrgw_chg_reinit_percentiles( gen, n_perc, percdom )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,191,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,194,(unur_tdrgw_chg_reinit_ncpoints( gen, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,194,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_chg() */

/*---------------------------------------------------------------------------*/
/* [init] */

void test_init (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[init "); fflush(stdout);
	fprintf(TESTLOG,"\n[init]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,205,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,205,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* stp out of domain */
UNUR_GEN   *gen = NULL;
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double stp[] = {-2.5,-1.,0.,1.,2.5};
   int n_stp = 5;
   gen = NULL;
   distr = unur_distr_normal(NULL,0);
   unur_distr_cont_set_domain(distr,-2.,2.);
   par = unur_tdrgw_new(distr);
   unur_tdrgw_set_cpoints( par, n_stp, stp ); 


unur_reset_errno();
gen = unur_init( par );
n_tests_failed += (check_errorcode(TESTLOG,217,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;
unur_free(gen);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_init() */

/*---------------------------------------------------------------------------*/
/* [reinit] */

void test_reinit (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[reinit "); fflush(stdout);
	fprintf(TESTLOG,"\n[reinit]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* exist */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_tdrgw_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 226,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_reinit(TESTLOG,230,(unur_reinit( gen )))==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_reinit() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_GEN   *gen = NULL;
   gen = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,240,(unur_tdrgw_eval_invcdfhat(gen,0.5)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,240,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_free(gen);
}

{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_arou_new(distr);
   gen = unur_init(par); 
abort_if_NULL(TESTLOG, 246,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,250,(unur_tdrgw_eval_invcdfhat(gen,0.5)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,250,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* invalid domain */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_tdrgw_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 256,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,260,(unur_tdrgw_eval_invcdfhat(gen,1.5)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,260,UNUR_ERR_DOMAIN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_negINFINITY(TESTLOG,263,(unur_tdrgw_eval_invcdfhat(gen,-0.5)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,263,UNUR_ERR_DOMAIN)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = unur_distr_normal(NULL,0); 
   par = NULL; 


unur_reset_errno();
/* default */
par = unur_tdrgw_new(distr);
n_tests_failed += (compare_sequence_par_start(TESTLOG,273,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* verifying mode */
par = unur_tdrgw_new(distr);
unur_tdrgw_set_verify(par,1);
n_tests_failed += (compare_sequence_par(TESTLOG,278,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* don't use private copy for distr object */
par = unur_tdrgw_new(distr);
unur_set_use_distr_privatecopy(par,FALSE);
n_tests_failed += (compare_sequence_par(TESTLOG,283,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* verifying mode, don't use private copy for distr object */
par = unur_tdrgw_new(distr);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_verify(par,1);
n_tests_failed += (compare_sequence_par(TESTLOG,289,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   double fpar[] = {1.23456,2.3456}; 
   distr = unur_distr_normal(fpar,2);
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_tdrgw_new(distr);
unur_tdrgw_set_max_intervals(par,2);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,304,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,310,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* dont use private copy for distr object */
/* original generator object */
unur_free(clone);
par = unur_tdrgw_new(distr);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_max_intervals(par,2);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,319,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,325,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare reinit */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0); 
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_tdrgw_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,337,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* reinit */
unur_reinit(gen);
n_tests_failed += (compare_sequence_gen(TESTLOG,341,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare stringparser */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {3.,3.};
   distr = NULL;
   par = NULL;
   gen = NULL; 


unur_reset_errno();
distr = unur_distr_gamma(fpar,2);
par = unur_tdrgw_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,354,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & method = ars ");
n_tests_failed += (compare_sequence_gen(TESTLOG,359,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_gamma(fpar,2);
par = unur_tdrgw_new(distr);
unur_tdrgw_set_cpoints(par,20,NULL);
unur_tdrgw_set_max_intervals(par,32);
unur_tdrgw_set_verify(par,TRUE);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,369,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & \
  method = ars; cpoints = 20; \
  max_intervals = 32; verify" );
n_tests_failed += (compare_sequence_gen(TESTLOG,376,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [validate] */

/*---------------------------------------------------------------------------*/

/* [validate] */

void test_validate (void)
{
	UNUR_DISTR *distr[31];
	UNUR_PAR *par;
	UNUR_GEN *gen;
	int n_tests_failed;
	int rcode;
	double *darray;
	double fpm[10];

	rcode = 0;

	/* start test */
	printf("[validate "); fflush(stdout);
	fprintf(TESTLOG,"\n[validate]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);


/* distributions: 31 */
{
fpm[0] = 1.;
fpm[1] = 2.;
distr[0] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 1.;
fpm[1] = 5.;
distr[1] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 1.;
fpm[1] = 100.;
distr[2] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 2.;
fpm[1] = 5.;
distr[3] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 2.;
distr[4] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 3.;
fpm[1] = 4.;
distr[5] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 100.;
distr[6] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 500.;
fpm[1] = 300.;
distr[7] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 10.;
fpm[2] = -3.;
fpm[3] = 15.;
distr[8] = unur_distr_beta(fpm,4);
}

{
distr[9] = unur_distr_cauchy(NULL,0);
}

{
fpm[0] = 1.;
fpm[1] = 20.;
distr[10] = unur_distr_cauchy(fpm,2);
}

{
distr[11] = unur_distr_exponential(NULL,0);
}

{
fpm[0] = 30.;
fpm[1] = -5.;
distr[12] = unur_distr_exponential(fpm,2);
}

{
fpm[0] = 1.;
distr[13] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 2.;
distr[14] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 3.;
distr[15] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 10.;
distr[16] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 1000.;
distr[17] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 5.;
fpm[1] = 1000.;
distr[18] = unur_distr_gamma(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 1.e-5;
distr[19] = unur_distr_gamma(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 10.;
fpm[2] = 1000;
distr[20] = unur_distr_gamma(fpm,3);
}

{
distr[21] = unur_distr_laplace(NULL,0);
}

{
fpm[0] = -10.;
fpm[1] = 100.;
distr[22] = unur_distr_laplace(fpm,2);
}

{
distr[23] = unur_distr_normal(NULL,0);
}

{
fpm[0] = 1.;
fpm[1] = 1.e-5;
distr[24] = unur_distr_normal(fpm,2);
}

{
fpm[0] = 0.;
fpm[1] = 1.e+5;
distr[25] = unur_distr_normal(fpm,2);
}

{
distr[26] = unur_distr_uniform(NULL,0);
}

{
fpm[0] = 1.;
fpm[1] = 20.;
distr[27] = unur_distr_uniform(fpm,2);
}

{
fpm[0] = 3.;
fpm[1] = 4.;
distr[28] = unur_distr_beta(fpm,2);
unur_distr_cont_set_domain(distr[23],-2.,5.);
}

{
distr[29] = unur_distr_cont_new();
unur_distr_cont_set_logpdf(distr[29],logpdf_normal_1);
unur_distr_cont_set_dlogpdf(distr[29],dlogpdf_normal_1);
unur_distr_cont_set_cdf(distr[29],cdf_normal_1);
unur_distr_set_name(distr[29],"normal_1"); 
}

{
distr[30] = unur_distr_cont_new();
unur_distr_cont_set_logpdf(distr[30],logpdf_normal_2);
unur_distr_cont_set_dlogpdf(distr[30],dlogpdf_normal_2);
unur_distr_cont_set_cdf(distr[30],cdf_normal_2);
unur_distr_set_name(distr[30],"normal_2"); 
}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>setup time = %.3f ms\n", stopwatch_lap(&watch));

	printf("\n(chi^2) "); fflush(stdout);

/* chi^2 tests: 217 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nChi^2 Test:\n");

/* distribution [0] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [1] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [2] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [3] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [4] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [5] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [6] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [7] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [9] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [10] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [11] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [12] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [13] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [14] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [15] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [16] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [17] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [18] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [19] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [20] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [21] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [22] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [23] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [24] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [25] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [26] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [27] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [28] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [29] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [30] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_tdrgw_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_tdrgw_new(distr_localcopy);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_tdrgw_new(distr_localcopy);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));

	printf("\n(verify hat) "); fflush(stdout);

/* verify hat tests: 217 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nVerify Hat Test (squeeze <= PDF <= hat):\n");

/* distribution [0] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [1] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [2] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [3] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [4] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [5] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [6] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [7] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [9] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'-')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'-')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'-')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'-')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [10] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'-')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'-')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'-')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [11] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [12] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [13] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [14] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [15] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [16] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [17] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [18] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[18],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[18],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[18],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [19] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [20] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[20],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[20],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[20],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [21] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[21],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[21],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[21],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[21],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[21],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[21],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[21],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [22] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[22],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[22],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[22],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[22],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[22],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[22],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[22],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [23] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[23],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[23],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[23],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[23],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[23],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[23],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[23],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [24] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[24],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[24],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[24],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[24],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[24],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[24],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [25] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[25],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[25],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[25],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[25],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[25],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[25],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [26] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[26],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[26],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[26],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[26],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[26],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[26],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[26],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [27] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[27],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[27],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[27],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[27],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[27],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[27],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[27],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [28] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[28],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[28],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[28],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[28],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[28],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 2, NULL );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[28],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
double perc[] = {0.1,0.3,0.5,0.7,0.9};
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,10,NULL);
fpm[0] = 1.;
fpm[1] = 4.;
unur_distr_cont_set_pdfparams(distr_localcopy,fpm,2);
	gen = unur_init(par);
	if (gen) {
unur_tdrgw_chg_reinit_percentiles(gen, 5, perc );
unur_reinit(gen);	
	}
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[28],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [29] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[29],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[29],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,3,NULL);
unur_tdrgw_set_max_intervals(par,10);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[29],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[29],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [30] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[30],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[30],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_tdrgw_new(distr_localcopy);
	unur_tdrgw_set_pedantic(par,0);
unur_set_use_distr_privatecopy(par,FALSE);
unur_tdrgw_set_cpoints(par,30,NULL);
	gen = unur_init(par);
	if (gen) unur_tdrgw_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[30],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));


/* free distributions */
	unur_distr_free(distr[0]);
	unur_distr_free(distr[1]);
	unur_distr_free(distr[2]);
	unur_distr_free(distr[3]);
	unur_distr_free(distr[4]);
	unur_distr_free(distr[5]);
	unur_distr_free(distr[6]);
	unur_distr_free(distr[7]);
	unur_distr_free(distr[8]);
	unur_distr_free(distr[9]);
	unur_distr_free(distr[10]);
	unur_distr_free(distr[11]);
	unur_distr_free(distr[12]);
	unur_distr_free(distr[13]);
	unur_distr_free(distr[14]);
	unur_distr_free(distr[15]);
	unur_distr_free(distr[16]);
	unur_distr_free(distr[17]);
	unur_distr_free(distr[18]);
	unur_distr_free(distr[19]);
	unur_distr_free(distr[20]);
	unur_distr_free(distr[21]);
	unur_distr_free(distr[22]);
	unur_distr_free(distr[23]);
	unur_distr_free(distr[24]);
	unur_distr_free(distr[25]);
	unur_distr_free(distr[26]);
	unur_distr_free(distr[27]);
	unur_distr_free(distr[28]);
	unur_distr_free(distr[29]);
	unur_distr_free(distr[30]);

	/* test finished */
	test_ok &= (n_tests_failed>CHI2_FAILURES_TOLERATED) ? 0 : 1;
	/* we accept CHI2_FAILURES_TOLERATED failures */
	(n_tests_failed>CHI2_FAILURES_TOLERATED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

	/* prevent compiler from making useless annoying warnings */
	distr[0] = NULL;
	par = NULL;
	gen = NULL;
	darray = NULL;
	fpm[0] = 0.;

} /* end of test_validate */


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_tdrgw_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */


/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_deprecated_tdrgw_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_deprecated_tdrgw_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 137470;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 137470;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("tdrgw: ");

	/* run tests */
test_new();
test_set();
test_get();
test_chg();
test_init();
test_reinit();
test_sample();
test_validate();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

