#! /bin/sh

here=`pwd`
if test $? -ne 0; then exit 2; fi
tmp=/tmp/$$
mkdir $tmp
if test $? -ne 0; then exit 2; fi
cd $tmp
if test $? -ne 0; then exit 2; fi

fail()
{
    echo "FAILED" 1>&2
    cd $here
    chmod -R u+w $tmp
    rm -rf $tmp
    exit 1
}

pass()
{
    echo "PASSED" 1>&2
    cd $here
    chmod -R u+w $tmp
    rm -rf $tmp
    exit 0
}

trap "fail" 1 2 3 15

# execute test here. PWD is temporary, refer to classdesc home directory 
# with $here

if [ -n "$AEGIS_ARCH" ]; then
  BL=`aegis -cd -bl`
  BL1=$BL/../../baseline
  if [ $here == $BL ]; then fail; fi
  GRAPHNODE=`aefind -resolve $here/objc-examples -name main -print`
else #standalone test
  BL=.
  BL1=.
  CPPOBJC=$here/objc-examples/main
fi

if [ -x $CPPOBJC ]; then $CPPOBJC; fi
if test $? -ne 0; then fail; fi

pass
