/*
	file automatically generated by make_test_files.pl
	Tue Feb  9 11:20:31 2010
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for DISTR_CVEC
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );

int unur_distr_cvec_set_verify( UNUR_PAR *par, int verify);


/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */

#define COMPARE_SAMPLE_SIZE  (500)
#define VIOLATE_SAMPLE_SIZE   (20)

double mvpdf(const double *x, UNUR_DISTR *distr);
int mvdpdf(double *result, const double *x, UNUR_DISTR *distr);
double mvpdpdf(const double *x, int coord, UNUR_DISTR *distr);




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



double mvpdf(const double *x ATTRIBUTE__UNUSED, UNUR_DISTR *distr ATTRIBUTE__UNUSED) { return 1.; }
int mvdpdf(double *result ATTRIBUTE__UNUSED, const double *x ATTRIBUTE__UNUSED, UNUR_DISTR *distr ATTRIBUTE__UNUSED) { return 1; }
double mvpdpdf(const double *x ATTRIBUTE__UNUSED, int coord ATTRIBUTE__UNUSED, UNUR_DISTR *distr ATTRIBUTE__UNUSED) { return 1.; }

/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid data */
UNUR_DISTR *distr = NULL;
	distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,30,(unur_distr_cvec_new(0)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,30,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,41,(unur_distr_cvec_set_pdf( distr, mvpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,41,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,44,(unur_distr_cvec_set_dpdf( distr, mvdpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,44,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,47,(unur_distr_cvec_set_pdpdf( distr, mvpdpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,47,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,50,(unur_distr_cvec_set_logpdf( distr, mvpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,50,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,53,(unur_distr_cvec_set_dlogpdf( distr, mvdpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,53,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,56,(unur_distr_cvec_set_pdlogpdf( distr, mvpdpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,56,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,59,(unur_distr_cvec_set_mean( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,59,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,62,(unur_distr_cvec_set_covar( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,62,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,65,(unur_distr_cvec_set_covar_inv( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,65,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,68,(unur_distr_cvec_set_rankcorr( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,68,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,71,(unur_distr_cvec_set_mode( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,71,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,74,(unur_distr_cvec_set_center( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,74,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,77,(unur_distr_cvec_set_pdfparams( distr, NULL, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,77,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,80,(unur_distr_cvec_set_pdfparams_vec( distr, 0, NULL, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,80,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,83,(unur_distr_cvec_set_pdfvol( distr, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,83,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,86,(unur_distr_cvec_set_marginals( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,86,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,89,(unur_distr_cvec_set_marginal_array( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,89,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,92,(unur_distr_cvec_set_domain_rect( distr, NULL, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,92,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   double fpm[2] = {1.,2.};
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,100,(unur_distr_cvec_set_pdf( distr, mvpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,100,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,103,(unur_distr_cvec_set_dpdf( distr, mvdpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,103,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,106,(unur_distr_cvec_set_pdpdf( distr, mvpdpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,106,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,109,(unur_distr_cvec_set_logpdf( distr, mvpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,109,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,112,(unur_distr_cvec_set_dlogpdf( distr, mvdpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,112,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,115,(unur_distr_cvec_set_pdlogpdf( distr, mvpdpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,115,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,118,(unur_distr_cvec_set_mean( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,118,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,121,(unur_distr_cvec_set_covar( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,121,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,124,(unur_distr_cvec_set_covar_inv( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,124,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,127,(unur_distr_cvec_set_rankcorr( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,127,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,130,(unur_distr_cvec_set_mode( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,130,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,133,(unur_distr_cvec_set_center( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,133,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,136,(unur_distr_cvec_set_pdfparams( distr, fpm, 2 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,136,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,139,(unur_distr_cvec_set_pdfparams_vec( distr, 0, fpm, 2 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,139,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,142,(unur_distr_cvec_set_pdfvol( distr, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,142,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,145,(unur_distr_cvec_set_marginals( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,145,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,148,(unur_distr_cvec_set_marginal_array( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,148,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,151,(unur_distr_cvec_set_domain_rect( distr, NULL, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,151,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cvec_new(2); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,158,(unur_distr_cvec_set_pdf( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,158,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,161,(unur_distr_cvec_set_dpdf( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,161,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,164,(unur_distr_cvec_set_pdpdf( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,164,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,167,(unur_distr_cvec_set_logpdf( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,167,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,170,(unur_distr_cvec_set_dlogpdf( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,170,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,173,(unur_distr_cvec_set_pdlogpdf( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,173,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,176,(unur_distr_cvec_set_pdfparams( distr, NULL, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,176,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,179,(unur_distr_cvec_set_marginals( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,179,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,182,(unur_distr_cvec_set_marginal_array( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,182,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,185,(unur_distr_cvec_set_domain_rect( distr, NULL, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,185,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
   double fpm[2] = {1.,2.};
   double dpm[2] = {4., 0.5};
   double covar_invalid_negative[4] = {-1.,0.,0.,1.};
   double covar_invalid_nonsym[4] = {1.,0.5,0.,1.};
   double covar_invalid_nonpositive[4] = {0.5,1.,1.,0.5};
   double ll[] = { 0., 0. };
   double ru[] = { 0., 0. };
   UNUR_DISTR *marginal = unur_distr_binomial(dpm,2);
   UNUR_DISTR *marginal_array[2];
   marginal_array[0] = marginal;
   marginal_array[1] = marginal;
   distr = unur_distr_cvec_new(2); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,203,(unur_distr_cvec_set_pdfvol( distr, -1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,203,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,206,(unur_distr_cvec_set_covar( distr, covar_invalid_negative )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,206,UNUR_ERR_DISTR_DOMAIN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,209,(unur_distr_cvec_set_covar_inv( distr, covar_invalid_negative )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,209,UNUR_ERR_DISTR_DOMAIN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,212,(unur_distr_cvec_set_covar( distr, covar_invalid_nonsym )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,212,UNUR_ERR_DISTR_DOMAIN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,215,(unur_distr_cvec_set_covar_inv( distr, covar_invalid_nonsym )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,215,UNUR_ERR_DISTR_DOMAIN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,218,(unur_distr_cvec_set_covar( distr, covar_invalid_nonpositive )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,218,UNUR_ERR_DISTR_DOMAIN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,221,(unur_distr_cvec_set_rankcorr( distr, covar_invalid_negative )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,221,UNUR_ERR_DISTR_DOMAIN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,224,(unur_distr_cvec_set_rankcorr( distr, covar_invalid_nonsym )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,224,UNUR_ERR_DISTR_DOMAIN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,227,(unur_distr_cvec_set_pdfparams( distr, fpm, -1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,227,UNUR_ERR_DISTR_NPARAMS)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,230,(unur_distr_cvec_set_pdfparams_vec( distr, -1, fpm, 2 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,230,UNUR_ERR_DISTR_NPARAMS)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,233,(unur_distr_cvec_set_pdfparams_vec( distr, 100000, fpm, 2 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,233,UNUR_ERR_DISTR_NPARAMS)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,236,(unur_distr_cvec_set_marginals( distr, marginal )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,236,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,239,(unur_distr_cvec_set_marginal_array( distr, marginal_array )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,239,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,242,(unur_distr_cvec_set_domain_rect( distr, ll, ru )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,242,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;
unur_distr_free(marginal);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [get] */

void test_get (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[get "); fflush(stdout);
	fprintf(TESTLOG,"\n[get]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,255,(unur_distr_cvec_get_pdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,255,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,258,(unur_distr_cvec_get_dpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,258,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,261,(unur_distr_cvec_get_pdpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,261,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,264,(unur_distr_cvec_get_logpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,264,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,267,(unur_distr_cvec_get_dlogpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,267,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,270,(unur_distr_cvec_get_pdlogpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,270,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,273,(unur_distr_cvec_get_pdfvol( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,273,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,276,(unur_distr_cvec_get_mean( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,276,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,279,(unur_distr_cvec_get_covar( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,279,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,282,(unur_distr_cvec_get_covar_inv( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,282,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,285,(unur_distr_cvec_get_rankcorr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,285,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,288,(unur_distr_cvec_get_cholesky( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,288,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,291,(unur_distr_cvec_get_mode( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,291,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,294,(unur_distr_cvec_get_center( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,294,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,297,(unur_distr_cvec_get_pdfparams( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,297,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,300,(unur_distr_cvec_get_pdfparams_vec( distr, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,300,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,303,(unur_distr_cvec_get_marginal( distr, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,303,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   const double *fpm;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,311,(unur_distr_cvec_get_pdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,311,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,314,(unur_distr_cvec_get_dpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,314,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,317,(unur_distr_cvec_get_pdpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,317,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,320,(unur_distr_cvec_get_logpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,320,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,323,(unur_distr_cvec_get_dlogpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,323,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,326,(unur_distr_cvec_get_pdlogpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,326,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,329,(unur_distr_cvec_get_pdfvol( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,329,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,332,(unur_distr_cvec_get_mean( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,332,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,335,(unur_distr_cvec_get_covar( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,335,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,338,(unur_distr_cvec_get_covar_inv( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,338,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,341,(unur_distr_cvec_get_rankcorr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,341,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,344,(unur_distr_cvec_get_cholesky( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,344,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,347,(unur_distr_cvec_get_mode( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,347,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,350,(unur_distr_cvec_get_center( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,350,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,353,(unur_distr_cvec_get_pdfparams( distr, &fpm )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,353,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,356,(unur_distr_cvec_get_pdfparams_vec( distr, 0, &fpm )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,356,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,359,(unur_distr_cvec_get_marginal( distr, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,359,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* parameters not unknown */
UNUR_DISTR *distr = NULL;
   const double *fpm;
   distr = unur_distr_cvec_new(2); 


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,367,(unur_distr_cvec_get_pdfvol( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,367,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,370,(unur_distr_cvec_get_mean( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,370,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,373,(unur_distr_cvec_get_covar( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,373,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,376,(unur_distr_cvec_get_covar_inv( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,376,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,379,(unur_distr_cvec_get_rankcorr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,379,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,382,(unur_distr_cvec_get_cholesky( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,382,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,385,(unur_distr_cvec_get_mode( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,385,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,388,(unur_distr_cvec_get_pdfparams_vec( distr, -1, &fpm )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,388,UNUR_ERR_DISTR_NPARAMS)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,391,(unur_distr_cvec_get_pdfparams_vec( distr, 1000, &fpm )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,391,UNUR_ERR_DISTR_NPARAMS)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,394,(unur_distr_cvec_get_marginal( distr, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,394,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
   double covar_invalid_noninv[4] = {1.,1.,1.,1.};
   UNUR_DISTR *marginal = unur_distr_normal(NULL,0);
   distr = unur_distr_cvec_new(2); 
   unur_distr_cvec_set_marginals( distr, marginal );
   unur_distr_cvec_set_covar( distr, covar_invalid_noninv ); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,405,(unur_distr_cvec_get_covar( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,405,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,408,(unur_distr_cvec_get_rankcorr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,408,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,411,(unur_distr_cvec_get_marginal( distr, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,411,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,414,(unur_distr_cvec_get_marginal( distr, 3 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,414,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;
unur_distr_free(marginal);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_get() */

/*---------------------------------------------------------------------------*/
/* [chg] */

void test_chg (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[chg "); fflush(stdout);
	fprintf(TESTLOG,"\n[chg]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,426,(unur_distr_cvec_upd_mode( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,426,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,429,(unur_distr_cvec_upd_pdfvol( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,429,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,435,(unur_distr_cvec_upd_mode( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,435,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,438,(unur_distr_cvec_upd_pdfvol( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,438,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* missing data */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cvec_new(3); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,444,(unur_distr_cvec_upd_mode( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,444,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,447,(unur_distr_cvec_upd_pdfvol( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,447,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_chg() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,466,(unur_distr_cvec_eval_pdf( NULL, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,466,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,469,(unur_distr_cvec_eval_dpdf( NULL, NULL, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,469,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,472,(unur_distr_cvec_eval_pdpdf( NULL, 1, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,472,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,475,(unur_distr_cvec_eval_logpdf( NULL, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,475,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,478,(unur_distr_cvec_eval_dlogpdf( NULL, NULL, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,478,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,481,(unur_distr_cvec_eval_pdlogpdf( NULL, 1, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,481,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution object */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,488,(unur_distr_cvec_eval_pdf( NULL, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,488,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,491,(unur_distr_cvec_eval_dpdf( NULL, NULL, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,491,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,494,(unur_distr_cvec_eval_pdpdf( NULL, 1, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,494,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,497,(unur_distr_cvec_eval_logpdf( NULL, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,497,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,500,(unur_distr_cvec_eval_dlogpdf( NULL, NULL, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,500,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,503,(unur_distr_cvec_eval_pdlogpdf( NULL, 1, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,503,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* missing data */
UNUR_DISTR *distr = NULL;
   double x[2], result[2];
   distr = unur_distr_cvec_new(2); 


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,511,(unur_distr_cvec_eval_pdf( x, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,511,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,514,(unur_distr_cvec_eval_dpdf( result, x, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,514,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,517,(unur_distr_cvec_eval_pdpdf( x, 1, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,517,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,520,(unur_distr_cvec_eval_logpdf( x, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,520,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,523,(unur_distr_cvec_eval_dlogpdf( result, x, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,523,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,526,(unur_distr_cvec_eval_pdlogpdf( x, 1, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,526,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* check for memory leaks */
UNUR_DISTR *distr = NULL;
   double x[] = { 1., 2., 3. };
   distr = unur_distr_cvec_new(3); 


unur_reset_errno();
unur_distr_cvec_set_pdfparams_vec( distr, 0, x, 3 );
n_tests_failed += (check_errorcode(TESTLOG,534,UNUR_SUCCESS)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_distr_cvec_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */

int unur_distr_cvec_set_verify(UNUR_PAR *par ATTRIBUTE__UNUSED, int verify ATTRIBUTE__UNUSED) {return 0;}

/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_distr_cvec_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_distr_cvec_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 972939;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 972939;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("distr_cvec: ");

	/* run tests */
test_new();
test_set();
test_get();
test_chg();
test_sample();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

