
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*  Bessel functions.                                                        */
/*                                                                           */
/*  We use the functions from the R project.                                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/

#include <unur_source.h>

/*---------------------------------------------------------------------------*/
#ifdef HAVE_LIBRMATH
/*---------------------------------------------------------------------------*/

/* header files */
#include <unur_Rmath.h>

/*---------------------------------------------------------------------------*/

double
_unur_sf_bessel_k(double x, double nu)
/*---------------------------------------------------------------------------*/
/* modified Bessel function K_nu of second kind (AKA third kind).            */
/*                                                                           */
/* Parameters:                                                               */
/*   x  ... argument                                                         */
/*   nu ... order                                                            */
/*                                                                           */
/*---------------------------------------------------------------------------*/
{
  return bessel_k( x, nu, 1);
} /* end of _unur_sf_bessel_k() */

/*---------------------------------------------------------------------------*/

double
_unur_sf_bessel_k_expo(double x, double nu)
/*---------------------------------------------------------------------------*/
/* rescaled modified Bessel function K_nu of second kind (AKA third kind):   */
/*   exp(x) * bessel_k(x,nu)                                                 */
/*                                                                           */
/* Parameters:                                                               */
/*   x  ... argument                                                         */
/*   nu ... order                                                            */
/*                                                                           */
/*---------------------------------------------------------------------------*/
{
  return bessel_k( x, nu, 2);
} /* end of _unur_sf_bessel_k_expo() */

/*---------------------------------------------------------------------------*/
#endif /* end HAVE_LIBRMATH */
/*---------------------------------------------------------------------------*/
