/*
	file automatically generated by make_test_files.pl
	Tue Feb  9 11:20:42 2010
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for DARI
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );



/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */

#define _unur_sf_ln_factorial(x)   _unur_sf_ln_gamma((x)+1.)
#define _unur_sf_ln_gamma(x)   _unur_cephes_lgam(x)
double _unur_cephes_lgam( double x );

int unur_dari_set_pedantic( struct unur_par *par, int pedantic );

double pmf_poisson5(int k, const UNUR_DISTR *distr);
double pmf_poisson5_NaN(int k, const UNUR_DISTR *distr);
double pmf_poisson50(int k, const UNUR_DISTR *distr);

double pmf_negpoisson5(int k, const UNUR_DISTR *distr);
double pmf_negpoisson50(int k, const UNUR_DISTR *distr);

#define COMPARE_SAMPLE_SIZE   (10000)
#define VIOLATE_SAMPLE_SIZE   (20)

/* #define SEED   (298346) */




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



/* no such function */
int unur_dari_set_pedantic( struct unur_par *par ATTRIBUTE__UNUSED, int pedantic ATTRIBUTE__UNUSED)
{ return 1; }


double pmf_poisson5(int k, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ 
	double theta = 5.;
	return ((k<0) ? 0. : exp( -theta + k * log(theta) - _unur_sf_ln_factorial(k) ));
}

double pmf_poisson5_NaN(int k, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ 
	double theta = 5.;
	return ((k<0) ? 0. : exp( -theta + k * log(theta)) / exp (_unur_sf_ln_factorial(k) ));
}

double pmf_poisson50(int k, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ 
	double theta = 50.;
	return ((k<0) ? 0. : exp( -theta + k * log(theta) - _unur_sf_ln_factorial(k) ));
}

double pmf_negpoisson5(int k, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ 
	double theta = 5.;
	k *= -1;
	return ((k<0) ? 0. : exp( -theta + k * log(theta) - _unur_sf_ln_factorial(k) ));
}

double pmf_negpoisson50(int k, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ 
	double theta = 50.;
	k *= -1;
	return ((k<0) ? 0. : exp( -theta + k * log(theta) - _unur_sf_ln_factorial(k) ));
}

/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,41,(unur_dari_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,41,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,47,(unur_dari_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,47,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* data missing in distribution object */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new();   /* no PMF */ 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,53,(unur_dari_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,53,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,63,(unur_dari_set_cpfactor(par,1.)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,63,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,66,(unur_dari_set_squeeze(par, 1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,66,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,69,(unur_dari_set_tablesize(par,100)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,69,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,72,(unur_dari_set_verify(par,1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,72,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid parameter object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double fpar[1] = {0.5};
   distr = unur_distr_geometric(fpar,1);
   par = unur_dgt_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,81,(unur_dari_set_cpfactor(par,1.)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,81,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,84,(unur_dari_set_squeeze(par, 1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,84,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,87,(unur_dari_set_tablesize(par,100)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,87,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,90,(unur_dari_set_verify(par,1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,90,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double fpar[1] = {0.5};
   distr = unur_distr_geometric(fpar,1);
   par = unur_dari_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,100,(unur_dari_set_cpfactor(par,-1.)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,100,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_dari_set_cpfactor(par,3.);
n_tests_failed += (check_errorcode(TESTLOG,103,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,106,(unur_dari_set_tablesize(par,-100)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,106,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [chg] */

void test_chg (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[chg "); fflush(stdout);
	fprintf(TESTLOG,"\n[chg]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[1] = {0.5};
   distr = unur_distr_geometric(fpar,1);
   par = unur_dgt_new(distr);
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 122,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,126,(unur_dari_chg_verify( gen,1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,126,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_chg() */

/*---------------------------------------------------------------------------*/
/* [reinit] */

void test_reinit (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[reinit "); fflush(stdout);
	fprintf(TESTLOG,"\n[reinit]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* exist */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[1] = {0.5};
   distr = unur_distr_geometric(fpar,1);
   par = unur_dari_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 140,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_reinit(TESTLOG,144,(unur_reinit( gen )))==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_reinit() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* compare */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double fpar[] = {0.1};
   distr = unur_distr_geometric(fpar,1);
   par = NULL; 


unur_reset_errno();
/* default algorithm */
par = unur_dari_new(distr);
n_tests_failed += (compare_sequence_par_start(TESTLOG,157,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* default algorithm - verifying mode */
par = unur_dari_new(distr);
unur_dari_set_verify(par,1);
n_tests_failed += (compare_sequence_par(TESTLOG,162,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   double fpar[] = {10,0.3}; 
   distr = unur_distr_binomial(fpar,2);
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_dari_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,176,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,182,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare reinit */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[] = {10,0.3}; 
   distr = unur_distr_binomial(fpar,2);
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_dari_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,195,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* reinit */
unur_reinit(gen);
n_tests_failed += (compare_sequence_gen(TESTLOG,199,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare stringparser */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[] = {20, 0.8};
   distr = NULL;
   par = NULL;
   gen = NULL; 


unur_reset_errno();
distr = unur_distr_binomial(fpar,2);
par = unur_dari_new(distr);
unur_dari_set_cpfactor(par,0.7);
unur_dari_set_squeeze(par,TRUE);
unur_dari_set_tablesize(par,30);
unur_dari_set_verify(par,FALSE);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,216,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "binomial(20,0.8) & \
  method = dari; cpfactor = 0.7; squeeze; tablesize = 30; verify = off" );
n_tests_failed += (compare_sequence_gen(TESTLOG,222,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [validate] */

/*---------------------------------------------------------------------------*/

/* [validate] */

void test_validate (void)
{
	UNUR_DISTR *distr[23];
	UNUR_PAR *par;
	UNUR_GEN *gen;
	int n_tests_failed;
	int rcode;
	double *darray;
	double fpm[10];

	rcode = 0;

	/* start test */
	printf("[validate "); fflush(stdout);
	fprintf(TESTLOG,"\n[validate]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);


/* distributions: 23 */
{
fpm[0] = 0.5;
distr[0] = unur_distr_geometric(fpm,1);
}

{
fpm[0] = 0.1;
distr[1] = unur_distr_geometric(fpm,1);
}

{
fpm[0] = 0.001;
distr[2] = unur_distr_geometric(fpm,1);
}

{
fpm[0] = 0.1;
distr[3] = unur_distr_logarithmic(fpm,1);
}

{
fpm[0] = 0.9;
distr[4] = unur_distr_logarithmic(fpm,1);
}

{
fpm[0] = 0.5;
fpm[1] = 10.;
distr[5] = unur_distr_negativebinomial(fpm,2);
}

{
fpm[0] = 0.7;
fpm[1] = 5.;
distr[6] = unur_distr_negativebinomial(fpm,2);
}

{
fpm[0] = 0.1;
fpm[1] = 20.;
distr[7] = unur_distr_negativebinomial(fpm,2);
}

{
fpm[0] = 3.;
distr[8] = unur_distr_poisson(fpm,1);
}

{
fpm[0] = 50.;
distr[9] = unur_distr_poisson(fpm,1);
}

{
fpm[0] = 2.;
fpm[1] = 1.;
distr[10] = unur_distr_zipf(fpm,2);
unur_distr_discr_set_domain(distr[10],1,1000);
}

{
fpm[0] = 20.;
fpm[1] = 0.8;
distr[11] = unur_distr_binomial(fpm,2);
}

{
fpm[0] = 2000.;
fpm[1] = 0.0013;
distr[12] = unur_distr_binomial(fpm,2);
}

{
fpm[0] = 2000.;
fpm[1] = 200.;
fpm[2] = 20;
distr[13] = unur_distr_hypergeometric(fpm,3);
}

{
fpm[0] = 2000.;
fpm[1] = 200.;
fpm[2] = 220;
distr[14] = unur_distr_hypergeometric(fpm,3);
}

{
distr[15] = unur_distr_discr_new();
unur_distr_discr_set_pmf(distr[15],pmf_poisson5);
unur_distr_set_name(distr[15],"test-poisson");
}

{
distr[16] = unur_distr_discr_new();
unur_distr_discr_set_pmf(distr[16],pmf_poisson5);
unur_distr_set_name(distr[16],"test-poisson");
}

{
distr[17] = unur_distr_discr_new();
unur_distr_discr_set_pmf(distr[17],pmf_poisson5);
unur_distr_set_name(distr[17],"test-poisson");
}

{
distr[18] = unur_distr_discr_new();
unur_distr_discr_set_pmf(distr[18],pmf_poisson5);
unur_distr_discr_set_domain(distr[18],INT_MIN,INT_MAX);
unur_distr_set_name(distr[18],"test-poisson");
}

{
distr[19] = unur_distr_discr_new();
unur_distr_discr_set_pmf(distr[19],pmf_negpoisson5);
unur_distr_discr_set_domain(distr[19],INT_MIN,INT_MAX);
unur_distr_set_name(distr[19],"test-poisson");
}

{
distr[20] = unur_distr_discr_new();
unur_distr_discr_set_pmf(distr[20],pmf_negpoisson5);
unur_distr_discr_set_domain(distr[20],INT_MIN,0);
unur_distr_set_name(distr[20],"test-poisson");
}

{
distr[21] = unur_distr_discr_new();
unur_distr_discr_set_pmf(distr[21],pmf_negpoisson50);
unur_distr_discr_set_domain(distr[21],INT_MIN,INT_MAX);
unur_distr_set_name(distr[21],"test-poisson");
}

{
distr[22] = unur_distr_discr_new();
unur_distr_discr_set_pmf(distr[22],pmf_negpoisson50);
unur_distr_discr_set_domain(distr[22],INT_MIN,0);
unur_distr_set_name(distr[22],"test-poisson");
}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>setup time = %.3f ms\n", stopwatch_lap(&watch));

	printf("\n(chi^2) "); fflush(stdout);

/* chi^2 tests: 161 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nChi^2 Test:\n");

/* distribution [0] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [1] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [2] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [3] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [4] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [5] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [6] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [7] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [9] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [10] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [11] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [12] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [13] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [14] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [15] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [16] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [17] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_dari_new(distr_localcopy);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));

	printf("\n(verify hat) "); fflush(stdout);

/* verify hat tests: 161 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nVerify Hat Test (squeeze <= PDF <= hat):\n");

/* distribution [0] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [1] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [2] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [3] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [4] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [5] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [6] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [7] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
fpm[0] = 0.4;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen); 
unur_distr_discr_set_pmfparams(dg,fpm,1);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [9] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [10] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [11] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [12] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [13] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [14] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [15] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [16] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [17] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [19] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'0')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'0')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 100);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'0')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 1);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'0')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
unur_dari_set_tablesize(par, 0);
unur_dari_set_squeeze(par, 0);
	gen = unur_init(par);
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'0')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
{ UNUR_DISTR *dg =NULL;
par = unur_dari_new(distr_localcopy);
	unur_dari_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,5);
unur_distr_discr_upd_pmfsum(dg);
unur_distr_discr_upd_mode(dg);
unur_reinit(gen); }
	}
	if (gen) unur_dari_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'0')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));


/* free distributions */
	unur_distr_free(distr[0]);
	unur_distr_free(distr[1]);
	unur_distr_free(distr[2]);
	unur_distr_free(distr[3]);
	unur_distr_free(distr[4]);
	unur_distr_free(distr[5]);
	unur_distr_free(distr[6]);
	unur_distr_free(distr[7]);
	unur_distr_free(distr[8]);
	unur_distr_free(distr[9]);
	unur_distr_free(distr[10]);
	unur_distr_free(distr[11]);
	unur_distr_free(distr[12]);
	unur_distr_free(distr[13]);
	unur_distr_free(distr[14]);
	unur_distr_free(distr[15]);
	unur_distr_free(distr[16]);
	unur_distr_free(distr[17]);
	unur_distr_free(distr[18]);
	unur_distr_free(distr[19]);
	unur_distr_free(distr[20]);
	unur_distr_free(distr[21]);
	unur_distr_free(distr[22]);

	/* test finished */
	test_ok &= (n_tests_failed>CHI2_FAILURES_TOLERATED) ? 0 : 1;
	/* we accept CHI2_FAILURES_TOLERATED failures */
	(n_tests_failed>CHI2_FAILURES_TOLERATED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

	/* prevent compiler from making useless annoying warnings */
	distr[0] = NULL;
	par = NULL;
	gen = NULL;
	darray = NULL;
	fpm[0] = 0.;

} /* end of test_validate */


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_dari_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */


/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_dari_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_dari_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 860957;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 860957;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("dari: ");

	/* run tests */
test_new();
test_set();
test_chg();
test_reinit();
test_sample();
test_validate();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

