/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.text.CharacterIterator;
import sun.font.AttributeMap;
import sun.font.AttributeValues;
import sun.font.DelegatingShape;
import sun.font.Font2D;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.FontSubstitution;
import sun.font.FontUtilities;
import sun.font.StrikeMetrics;
import sun.java2d.loops.FontInfo;

public class StandardGlyphVector
extends GlyphVector {
    private Font font;
    private FontRenderContext frc;
    private int[] glyphs;
    private int[] userGlyphs;
    private float[] positions;
    private int[] charIndices;
    private int flags;
    private static final int UNINITIALIZED_FLAGS = -1;
    private GlyphTransformInfo gti;
    private AffineTransform ftx;
    private AffineTransform dtx;
    private AffineTransform invdtx;
    private AffineTransform frctx;
    private Font2D font2D;
    private SoftReference fsref;
    private SoftReference lbcacheRef;
    private SoftReference vbcacheRef;
    public static final int FLAG_USES_VERTICAL_BASELINE = 128;
    public static final int FLAG_USES_VERTICAL_METRICS = 256;
    public static final int FLAG_USES_ALTERNATE_ORIENTATION = 512;

    public StandardGlyphVector(Font font, String string, FontRenderContext fontRenderContext) {
        this.init(font, string.toCharArray(), 0, string.length(), fontRenderContext, -1);
    }

    public StandardGlyphVector(Font font, char[] cArray, FontRenderContext fontRenderContext) {
        this.init(font, cArray, 0, cArray.length, fontRenderContext, -1);
    }

    public StandardGlyphVector(Font font, char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        this.init(font, cArray, n, n2, fontRenderContext, -1);
    }

    private float getTracking(Font font) {
        if (font.hasLayoutAttributes()) {
            AttributeValues attributeValues = ((AttributeMap)font.getAttributes()).getValues();
            return attributeValues.getTracking();
        }
        return 0.0f;
    }

    public StandardGlyphVector(Font font, FontRenderContext fontRenderContext, int[] nArray, float[] fArray, int[] nArray2, int n) {
        this.initGlyphVector(font, fontRenderContext, nArray, fArray, nArray2, n);
        float f = this.getTracking(font);
        if (f != 0.0f) {
            Object object;
            Point2D.Float float_ = new Point2D.Float(f *= font.getSize2D(), 0.0f);
            if (font.isTransformed()) {
                object = font.getTransform();
                ((AffineTransform)object).deltaTransform(float_, float_);
            }
            object = FontUtilities.getFont2D(font);
            FontStrike fontStrike = ((Font2D)object).getStrike(font, fontRenderContext);
            float[] fArray2 = new float[]{float_.x, float_.y};
            for (int i = 0; i < fArray2.length; ++i) {
                float f2 = fArray2[i];
                if (f2 == 0.0f) continue;
                float f3 = 0.0f;
                int n2 = i;
                int n3 = 0;
                while (n3 < nArray.length) {
                    if (fontStrike.getGlyphAdvance(nArray[n3++]) != 0.0f) {
                        int n4 = n2;
                        fArray[n4] = fArray[n4] + f3;
                        f3 += f2;
                    }
                    n2 += 2;
                }
                int n5 = fArray.length - 2 + i;
                fArray[n5] = fArray[n5] + f3;
            }
        }
    }

    public void initGlyphVector(Font font, FontRenderContext fontRenderContext, int[] nArray, float[] fArray, int[] nArray2, int n) {
        this.font = font;
        this.frc = fontRenderContext;
        this.glyphs = nArray;
        this.userGlyphs = nArray;
        this.positions = fArray;
        this.charIndices = nArray2;
        this.flags = n;
        this.initFontData();
    }

    public StandardGlyphVector(Font font, CharacterIterator characterIterator, FontRenderContext fontRenderContext) {
        int n = characterIterator.getBeginIndex();
        char[] cArray = new char[characterIterator.getEndIndex() - n];
        char c = characterIterator.first();
        while (c != '\uffff') {
            cArray[characterIterator.getIndex() - n] = c;
            c = characterIterator.next();
        }
        this.init(font, cArray, 0, cArray.length, fontRenderContext, -1);
    }

    public StandardGlyphVector(Font font, int[] nArray, FontRenderContext fontRenderContext) {
        this.font = font;
        this.frc = fontRenderContext;
        this.flags = -1;
        this.initFontData();
        this.userGlyphs = nArray;
        this.glyphs = this.getValidatedGlyphs(this.userGlyphs);
    }

    public static StandardGlyphVector getStandardGV(GlyphVector glyphVector, FontInfo fontInfo) {
        Object object;
        if (fontInfo.aaHint == 2 && (object = glyphVector.getFontRenderContext().getAntiAliasingHint()) != RenderingHints.VALUE_TEXT_ANTIALIAS_ON && object != RenderingHints.VALUE_TEXT_ANTIALIAS_GASP) {
            FontRenderContext fontRenderContext = glyphVector.getFontRenderContext();
            fontRenderContext = new FontRenderContext(fontRenderContext.getTransform(), RenderingHints.VALUE_TEXT_ANTIALIAS_ON, fontRenderContext.getFractionalMetricsHint());
            return new StandardGlyphVector(glyphVector, fontRenderContext);
        }
        if (glyphVector instanceof StandardGlyphVector) {
            return (StandardGlyphVector)glyphVector;
        }
        return new StandardGlyphVector(glyphVector, glyphVector.getFontRenderContext());
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    @Override
    public void performDefaultLayout() {
        this.positions = null;
        if (this.getTracking(this.font) == 0.0f) {
            this.clearFlags(2);
        }
    }

    @Override
    public int getNumGlyphs() {
        return this.glyphs.length;
    }

    @Override
    public int getGlyphCode(int n) {
        return this.userGlyphs[n];
    }

    @Override
    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("count = " + n2);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("start = " + n);
        }
        if (n > this.glyphs.length - n2) {
            throw new IndexOutOfBoundsException("start + count = " + (n + n2));
        }
        if (nArray == null) {
            nArray = new int[n2];
        }
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.userGlyphs[i + n];
        }
        return nArray;
    }

    @Override
    public int getGlyphCharIndex(int n) {
        if (n < 0 && n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("" + n);
        }
        if (this.charIndices == null) {
            if ((this.getLayoutFlags() & 4) != 0) {
                return this.glyphs.length - 1 - n;
            }
            return n;
        }
        return this.charIndices[n];
    }

    @Override
    public int[] getGlyphCharIndices(int n, int n2, int[] nArray) {
        if (n < 0 || n2 < 0 || n2 > this.glyphs.length - n) {
            throw new IndexOutOfBoundsException("" + n + ", " + n2);
        }
        if (nArray == null) {
            nArray = new int[n2];
        }
        if (this.charIndices == null) {
            if ((this.getLayoutFlags() & 4) != 0) {
                int n3 = this.glyphs.length - 1 - n;
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = n3--;
                }
            } else {
                int n4 = n;
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = n4++;
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.charIndices[i + n];
            }
        }
        return nArray;
    }

    @Override
    public Rectangle2D getLogicalBounds() {
        this.setFRCTX();
        this.initPositions();
        LineMetrics lineMetrics = this.font.getLineMetrics("", this.frc);
        float f = 0.0f;
        float f2 = -lineMetrics.getAscent();
        float f3 = 0.0f;
        float f4 = lineMetrics.getDescent() + lineMetrics.getLeading();
        if (this.glyphs.length > 0) {
            f3 = this.positions[this.positions.length - 2];
        }
        return new Rectangle2D.Float(f, f2, f3 - f, f4 - f2);
    }

    @Override
    public Rectangle2D getVisualBounds() {
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < this.glyphs.length; ++i) {
            Rectangle2D rectangle2D2 = this.getGlyphVisualBounds(i).getBounds2D();
            if (rectangle2D2.isEmpty()) continue;
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
                continue;
            }
            Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
        }
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return rectangle2D;
    }

    @Override
    public Rectangle getPixelBounds(FontRenderContext fontRenderContext, float f, float f2) {
        return this.getGlyphsPixelBounds(fontRenderContext, f, f2, 0, this.glyphs.length);
    }

    @Override
    public Shape getOutline() {
        return this.getGlyphsOutline(0, this.glyphs.length, 0.0f, 0.0f);
    }

    @Override
    public Shape getOutline(float f, float f2) {
        return this.getGlyphsOutline(0, this.glyphs.length, f, f2);
    }

    @Override
    public Shape getGlyphOutline(int n) {
        return this.getGlyphsOutline(n, 1, 0.0f, 0.0f);
    }

    @Override
    public Shape getGlyphOutline(int n, float f, float f2) {
        return this.getGlyphsOutline(n, 1, f, f2);
    }

    @Override
    public Point2D getGlyphPosition(int n) {
        this.initPositions();
        return new Point2D.Float(this.positions[n *= 2], this.positions[n + 1]);
    }

    @Override
    public void setGlyphPosition(int n, Point2D point2D) {
        this.initPositions();
        int n2 = n << 1;
        this.positions[n2] = (float)point2D.getX();
        this.positions[n2 + 1] = (float)point2D.getY();
        this.clearCaches(n);
        this.addFlags(2);
    }

    @Override
    public AffineTransform getGlyphTransform(int n) {
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("ix = " + n);
        }
        if (this.gti != null) {
            return this.gti.getGlyphTransform(n);
        }
        return null;
    }

    @Override
    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("ix = " + n);
        }
        if (this.gti == null) {
            if (affineTransform == null || affineTransform.isIdentity()) {
                return;
            }
            this.gti = new GlyphTransformInfo(this);
        }
        this.gti.setGlyphTransform(n, affineTransform);
        if (this.gti.transformCount() == 0) {
            this.gti = null;
        }
    }

    @Override
    public int getLayoutFlags() {
        if (this.flags == -1) {
            this.flags = 0;
            if (this.charIndices != null && this.glyphs.length > 1) {
                boolean bl = true;
                boolean bl2 = true;
                int n = this.charIndices.length;
                for (int i = 0; i < this.charIndices.length && (bl || bl2); ++i) {
                    int n2 = this.charIndices[i];
                    bl = bl && n2 == i;
                    bl2 = bl2 && n2 == --n;
                }
                if (bl2) {
                    this.flags |= 4;
                }
                if (!bl2 && !bl) {
                    this.flags |= 8;
                }
            }
        }
        return this.flags;
    }

    @Override
    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("count = " + n2);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("start = " + n);
        }
        if (n > this.glyphs.length + 1 - n2) {
            throw new IndexOutOfBoundsException("start + count = " + (n + n2));
        }
        return this.internalGetGlyphPositions(n, n2, 0, fArray);
    }

    @Override
    public Shape getGlyphLogicalBounds(int n) {
        Shape shape;
        Shape[] shapeArray;
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("ix = " + n);
        }
        if (this.lbcacheRef == null || (shapeArray = (Shape[])this.lbcacheRef.get()) == null) {
            shapeArray = new Shape[this.glyphs.length];
            this.lbcacheRef = new SoftReference<Shape[]>(shapeArray);
        }
        if ((shape = shapeArray[n]) == null) {
            this.setFRCTX();
            this.initPositions();
            ADL aDL = new ADL();
            GlyphStrike glyphStrike = this.getGlyphStrike(n);
            glyphStrike.getADL(aDL);
            Point2D.Float float_ = glyphStrike.strike.getGlyphMetrics(this.glyphs[n]);
            float f = float_.x;
            float f2 = float_.y;
            float f3 = aDL.descentX + aDL.leadingX + aDL.ascentX;
            float f4 = aDL.descentY + aDL.leadingY + aDL.ascentY;
            float f5 = this.positions[n * 2] + glyphStrike.dx - aDL.ascentX;
            float f6 = this.positions[n * 2 + 1] + glyphStrike.dy - aDL.ascentY;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f5, f6);
            generalPath.lineTo(f5 + f, f6 + f2);
            generalPath.lineTo(f5 + f + f3, f6 + f2 + f4);
            generalPath.lineTo(f5 + f3, f6 + f4);
            generalPath.closePath();
            shapeArray[n] = shape = new DelegatingShape(generalPath);
        }
        return shape;
    }

    @Override
    public Shape getGlyphVisualBounds(int n) {
        Shape shape;
        Shape[] shapeArray;
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("ix = " + n);
        }
        if (this.vbcacheRef == null || (shapeArray = (Shape[])this.vbcacheRef.get()) == null) {
            shapeArray = new Shape[this.glyphs.length];
            this.vbcacheRef = new SoftReference<Shape[]>(shapeArray);
        }
        if ((shape = shapeArray[n]) == null) {
            shapeArray[n] = shape = new DelegatingShape(this.getGlyphOutlineBounds(n));
        }
        return shape;
    }

    @Override
    public Rectangle getGlyphPixelBounds(int n, FontRenderContext fontRenderContext, float f, float f2) {
        return this.getGlyphsPixelBounds(fontRenderContext, f, f2, n, 1);
    }

    @Override
    public GlyphMetrics getGlyphMetrics(int n) {
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("ix = " + n);
        }
        Rectangle2D rectangle2D = this.getGlyphVisualBounds(n).getBounds2D();
        Point2D point2D = this.getGlyphPosition(n);
        rectangle2D.setRect(rectangle2D.getMinX() - point2D.getX(), rectangle2D.getMinY() - point2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        Point2D.Float float_ = this.getGlyphStrike((int)n).strike.getGlyphMetrics(this.glyphs[n]);
        GlyphMetrics glyphMetrics = new GlyphMetrics(true, float_.x, float_.y, rectangle2D, 0);
        return glyphMetrics;
    }

    @Override
    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("ix = " + n);
        }
        return null;
    }

    @Override
    public boolean equals(GlyphVector glyphVector) {
        if (this == glyphVector) {
            return true;
        }
        if (glyphVector == null) {
            return false;
        }
        try {
            int n;
            StandardGlyphVector standardGlyphVector = (StandardGlyphVector)glyphVector;
            if (this.glyphs.length != standardGlyphVector.glyphs.length) {
                return false;
            }
            for (n = 0; n < this.glyphs.length; ++n) {
                if (this.glyphs[n] == standardGlyphVector.glyphs[n]) continue;
                return false;
            }
            if (!this.font.equals(standardGlyphVector.font)) {
                return false;
            }
            if (!this.frc.equals(standardGlyphVector.frc)) {
                return false;
            }
            if (standardGlyphVector.positions == null != (this.positions == null)) {
                if (this.positions == null) {
                    this.initPositions();
                } else {
                    standardGlyphVector.initPositions();
                }
            }
            if (this.positions != null) {
                for (n = 0; n < this.positions.length; ++n) {
                    if (this.positions[n] == standardGlyphVector.positions[n]) continue;
                    return false;
                }
            }
            if (this.gti == null) {
                return standardGlyphVector.gti == null;
            }
            return this.gti.equals(standardGlyphVector.gti);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.font.hashCode() ^ this.glyphs.length;
    }

    public boolean equals(Object object) {
        try {
            return this.equals((GlyphVector)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public StandardGlyphVector copy() {
        return (StandardGlyphVector)this.clone();
    }

    public Object clone() {
        try {
            StandardGlyphVector standardGlyphVector = (StandardGlyphVector)super.clone();
            standardGlyphVector.clearCaches();
            if (this.positions != null) {
                standardGlyphVector.positions = (float[])this.positions.clone();
            }
            if (this.gti != null) {
                standardGlyphVector.gti = new GlyphTransformInfo(standardGlyphVector, this.gti);
            }
            return standardGlyphVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public void setGlyphPositions(float[] fArray, int n, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("count = " + n3);
        }
        this.initPositions();
        int n4 = n2 * 2;
        int n5 = n4 + n3 * 2;
        int n6 = n;
        while (n4 < n5) {
            this.positions[n4] = fArray[n6];
            ++n4;
            ++n6;
        }
        this.clearCaches();
        this.addFlags(2);
    }

    public void setGlyphPositions(float[] fArray) {
        int n = this.glyphs.length * 2 + 2;
        if (fArray.length != n) {
            throw new IllegalArgumentException("srcPositions.length != " + n);
        }
        this.positions = (float[])fArray.clone();
        this.clearCaches();
        this.addFlags(2);
    }

    public float[] getGlyphPositions(float[] fArray) {
        return this.internalGetGlyphPositions(0, this.glyphs.length + 1, 0, fArray);
    }

    public AffineTransform[] getGlyphTransforms(int n, int n2, AffineTransform[] affineTransformArray) {
        if (n < 0 || n2 < 0 || n + n2 > this.glyphs.length) {
            throw new IllegalArgumentException("start: " + n + " count: " + n2);
        }
        if (this.gti == null) {
            return null;
        }
        if (affineTransformArray == null) {
            affineTransformArray = new AffineTransform[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            affineTransformArray[n3] = this.gti.getGlyphTransform(n);
            ++n3;
            ++n;
        }
        return affineTransformArray;
    }

    public AffineTransform[] getGlyphTransforms() {
        return this.getGlyphTransforms(0, this.glyphs.length, null);
    }

    public void setGlyphTransforms(AffineTransform[] affineTransformArray, int n, int n2, int n3) {
        int n4 = n2 + n3;
        for (int i = n2; i < n4; ++i) {
            this.setGlyphTransform(i, affineTransformArray[n + i]);
        }
    }

    public void setGlyphTransforms(AffineTransform[] affineTransformArray) {
        this.setGlyphTransforms(affineTransformArray, 0, 0, this.glyphs.length);
    }

    public float[] getGlyphInfo() {
        this.setFRCTX();
        this.initPositions();
        float[] fArray = new float[this.glyphs.length * 8];
        int n = 0;
        int n2 = 0;
        while (n < this.glyphs.length) {
            float f = this.positions[n * 2];
            float f2 = this.positions[n * 2 + 1];
            fArray[n2] = f;
            fArray[n2 + 1] = f2;
            int n3 = this.glyphs[n];
            GlyphStrike glyphStrike = this.getGlyphStrike(n);
            Point2D.Float float_ = glyphStrike.strike.getGlyphMetrics(n3);
            fArray[n2 + 2] = float_.x;
            fArray[n2 + 3] = float_.y;
            Rectangle2D rectangle2D = this.getGlyphVisualBounds(n).getBounds2D();
            fArray[n2 + 4] = (float)rectangle2D.getMinX();
            fArray[n2 + 5] = (float)rectangle2D.getMinY();
            fArray[n2 + 6] = (float)rectangle2D.getWidth();
            fArray[n2 + 7] = (float)rectangle2D.getHeight();
            ++n;
            n2 += 8;
        }
        return fArray;
    }

    public void pixellate(FontRenderContext fontRenderContext, Point2D point2D, Point point) {
        if (fontRenderContext == null) {
            fontRenderContext = this.frc;
        }
        AffineTransform affineTransform = fontRenderContext.getTransform();
        affineTransform.transform(point2D, point2D);
        point.x = (int)point2D.getX();
        point.y = (int)point2D.getY();
        point2D.setLocation(point.x, point.y);
        try {
            affineTransform.inverseTransform(point2D, point2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalArgumentException("must be able to invert frc transform");
        }
    }

    boolean needsPositions(double[] dArray) {
        return this.gti != null || (this.getLayoutFlags() & 2) != 0 || !StandardGlyphVector.matchTX(dArray, this.frctx);
    }

    Object setupGlyphImages(long[] lArray, float[] fArray, double[] dArray) {
        this.initPositions();
        this.setRenderTransform(dArray);
        if (this.gti != null) {
            return this.gti.setupGlyphImages(lArray, fArray, this.dtx);
        }
        GlyphStrike glyphStrike = this.getDefaultStrike();
        glyphStrike.strike.getGlyphImagePtrs(this.glyphs, lArray, this.glyphs.length);
        if (fArray != null) {
            if (this.dtx.isIdentity()) {
                System.arraycopy(this.positions, 0, fArray, 0, this.glyphs.length * 2);
            } else {
                this.dtx.transform(this.positions, 0, fArray, 0, this.glyphs.length);
            }
        }
        return glyphStrike;
    }

    private static boolean matchTX(double[] dArray, AffineTransform affineTransform) {
        return dArray[0] == affineTransform.getScaleX() && dArray[1] == affineTransform.getShearY() && dArray[2] == affineTransform.getShearX() && dArray[3] == affineTransform.getScaleY();
    }

    private static AffineTransform getNonTranslateTX(AffineTransform affineTransform) {
        if (affineTransform.getTranslateX() != 0.0 || affineTransform.getTranslateY() != 0.0) {
            affineTransform = new AffineTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), 0.0, 0.0);
        }
        return affineTransform;
    }

    private static boolean equalNonTranslateTX(AffineTransform affineTransform, AffineTransform affineTransform2) {
        return affineTransform.getScaleX() == affineTransform2.getScaleX() && affineTransform.getShearY() == affineTransform2.getShearY() && affineTransform.getShearX() == affineTransform2.getShearX() && affineTransform.getScaleY() == affineTransform2.getScaleY();
    }

    private void setRenderTransform(double[] dArray) {
        assert (dArray.length == 4);
        if (!StandardGlyphVector.matchTX(dArray, this.dtx)) {
            this.resetDTX(new AffineTransform(dArray));
        }
    }

    private final void setDTX(AffineTransform affineTransform) {
        if (!StandardGlyphVector.equalNonTranslateTX(this.dtx, affineTransform)) {
            this.resetDTX(StandardGlyphVector.getNonTranslateTX(affineTransform));
        }
    }

    private final void setFRCTX() {
        if (!StandardGlyphVector.equalNonTranslateTX(this.frctx, this.dtx)) {
            this.resetDTX(StandardGlyphVector.getNonTranslateTX(this.frctx));
        }
    }

    private final void resetDTX(AffineTransform affineTransform) {
        this.fsref = null;
        this.dtx = affineTransform;
        this.invdtx = null;
        if (!this.dtx.isIdentity()) {
            try {
                this.invdtx = this.dtx.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        if (this.gti != null) {
            this.gti.strikesRef = null;
        }
    }

    private StandardGlyphVector(GlyphVector glyphVector, FontRenderContext fontRenderContext) {
        this.font = glyphVector.getFont();
        this.frc = fontRenderContext;
        this.initFontData();
        int n = glyphVector.getNumGlyphs();
        this.userGlyphs = glyphVector.getGlyphCodes(0, n, null);
        this.glyphs = glyphVector instanceof StandardGlyphVector ? this.userGlyphs : this.getValidatedGlyphs(this.userGlyphs);
        this.flags = glyphVector.getLayoutFlags() & 0xF;
        if ((this.flags & 2) != 0) {
            this.positions = glyphVector.getGlyphPositions(0, n + 1, null);
        }
        if ((this.flags & 8) != 0) {
            this.charIndices = glyphVector.getGlyphCharIndices(0, n, null);
        }
        if ((this.flags & 1) != 0) {
            AffineTransform[] affineTransformArray = new AffineTransform[n];
            for (int i = 0; i < n; ++i) {
                affineTransformArray[i] = glyphVector.getGlyphTransform(i);
            }
            this.setGlyphTransforms(affineTransformArray);
        }
    }

    int[] getValidatedGlyphs(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i] == 65534 || nArray[i] == 65535 ? nArray[i] : this.font2D.getValidatedGlyphCode(nArray[i]);
        }
        return nArray2;
    }

    private void init(Font font, char[] cArray, int n, int n2, FontRenderContext fontRenderContext, int n3) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException("start or count out of bounds");
        }
        this.font = font;
        this.frc = fontRenderContext;
        this.flags = n3;
        if (this.getTracking(font) != 0.0f) {
            this.addFlags(2);
        }
        if (n != 0) {
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            cArray = cArray2;
        }
        this.initFontData();
        this.glyphs = new int[n2];
        this.userGlyphs = this.glyphs;
        this.font2D.getMapper().charsToGlyphs(n2, cArray, this.glyphs);
    }

    private void initFontData() {
        this.font2D = FontUtilities.getFont2D(this.font);
        if (Font2D.fontSubstitutionEnabled && this.font2D instanceof FontSubstitution) {
            this.font2D = ((FontSubstitution)((Object)this.font2D)).getCompositeFont2D();
        }
        float f = this.font.getSize2D();
        if (this.font.isTransformed()) {
            this.ftx = this.font.getTransform();
            if (this.ftx.getTranslateX() != 0.0 || this.ftx.getTranslateY() != 0.0) {
                this.addFlags(2);
            }
            this.ftx.setTransform(this.ftx.getScaleX(), this.ftx.getShearY(), this.ftx.getShearX(), this.ftx.getScaleY(), 0.0, 0.0);
            this.ftx.scale(f, f);
        } else {
            this.ftx = AffineTransform.getScaleInstance(f, f);
        }
        this.frctx = this.frc.getTransform();
        this.resetDTX(StandardGlyphVector.getNonTranslateTX(this.frctx));
    }

    private float[] internalGetGlyphPositions(int n, int n2, int n3, float[] fArray) {
        if (fArray == null) {
            fArray = new float[n3 + n2 * 2];
        }
        this.initPositions();
        int n4 = n3;
        int n5 = n3 + n2 * 2;
        int n6 = n * 2;
        while (n4 < n5) {
            fArray[n4] = this.positions[n6];
            ++n4;
            ++n6;
        }
        return fArray;
    }

    private Rectangle2D getGlyphOutlineBounds(int n) {
        this.setFRCTX();
        this.initPositions();
        return this.getGlyphStrike(n).getGlyphOutlineBounds(this.glyphs[n], this.positions[n * 2], this.positions[n * 2 + 1]);
    }

    private Shape getGlyphsOutline(int n, int n2, float f, float f2) {
        this.setFRCTX();
        this.initPositions();
        GeneralPath generalPath = new GeneralPath(1);
        int n3 = n;
        int n4 = n + n2;
        int n5 = n * 2;
        while (n3 < n4) {
            float f3 = f + this.positions[n5];
            float f4 = f2 + this.positions[n5 + 1];
            this.getGlyphStrike(n3).appendGlyphOutline(this.glyphs[n3], generalPath, f3, f4);
            ++n3;
            n5 += 2;
        }
        return generalPath;
    }

    private Rectangle getGlyphsPixelBounds(FontRenderContext fontRenderContext, float f, float f2, int n, int n2) {
        this.initPositions();
        AffineTransform affineTransform = null;
        affineTransform = fontRenderContext == null || fontRenderContext.equals(this.frc) ? this.frctx : fontRenderContext.getTransform();
        this.setDTX(affineTransform);
        if (this.gti != null) {
            return this.gti.getGlyphsPixelBounds(affineTransform, f, f2, n, n2);
        }
        FontStrike fontStrike = this.getDefaultStrike().strike;
        Rectangle rectangle = null;
        Rectangle rectangle2 = new Rectangle();
        Point2D.Float float_ = new Point2D.Float();
        int n3 = n * 2;
        while (--n2 >= 0) {
            float_.x = f + this.positions[n3++];
            float_.y = f2 + this.positions[n3++];
            affineTransform.transform(float_, float_);
            fontStrike.getGlyphImageBounds(this.glyphs[n++], float_, rectangle2);
            if (rectangle2.isEmpty()) continue;
            if (rectangle == null) {
                rectangle = new Rectangle(rectangle2);
                continue;
            }
            rectangle.add(rectangle2);
        }
        return rectangle != null ? rectangle : rectangle2;
    }

    private void clearCaches(int n) {
        Shape[] shapeArray;
        if (this.lbcacheRef != null && (shapeArray = (Shape[])this.lbcacheRef.get()) != null) {
            shapeArray[n] = null;
        }
        if (this.vbcacheRef != null && (shapeArray = (Shape[])this.vbcacheRef.get()) != null) {
            shapeArray[n] = null;
        }
    }

    private void clearCaches() {
        this.lbcacheRef = null;
        this.vbcacheRef = null;
    }

    private void initPositions() {
        if (this.positions == null) {
            this.setFRCTX();
            this.positions = new float[this.glyphs.length * 2 + 2];
            Point2D.Float float_ = null;
            float f = this.getTracking(this.font);
            if (f != 0.0f) {
                float_ = new Point2D.Float(f *= this.font.getSize2D(), 0.0f);
            }
            Point2D.Float float_2 = new Point2D.Float(0.0f, 0.0f);
            if (this.font.isTransformed()) {
                AffineTransform affineTransform = this.font.getTransform();
                affineTransform.transform(float_2, float_2);
                this.positions[0] = float_2.x;
                this.positions[1] = float_2.y;
                if (float_ != null) {
                    affineTransform.deltaTransform(float_, float_);
                }
            }
            int n = 0;
            int n2 = 2;
            while (n < this.glyphs.length) {
                this.getGlyphStrike(n).addDefaultGlyphAdvance(this.glyphs[n], float_2);
                if (float_ != null) {
                    float_2.x += float_.x;
                    float_2.y += float_.y;
                }
                this.positions[n2] = float_2.x;
                this.positions[n2 + 1] = float_2.y;
                ++n;
                n2 += 2;
            }
        }
    }

    private void addFlags(int n) {
        this.flags = this.getLayoutFlags() | n;
    }

    private void clearFlags(int n) {
        this.flags = this.getLayoutFlags() & ~n;
    }

    private GlyphStrike getGlyphStrike(int n) {
        if (this.gti == null) {
            return this.getDefaultStrike();
        }
        return this.gti.getStrike(n);
    }

    private GlyphStrike getDefaultStrike() {
        GlyphStrike glyphStrike = null;
        if (this.fsref != null) {
            glyphStrike = (GlyphStrike)this.fsref.get();
        }
        if (glyphStrike == null) {
            glyphStrike = GlyphStrike.create(this, this.dtx, null);
            this.fsref = new SoftReference<GlyphStrike>(glyphStrike);
        }
        return glyphStrike;
    }

    public String toString() {
        return this.appendString(null).toString();
    }

    StringBuffer appendString(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        try {
            int n;
            stringBuffer.append("SGV{font: ");
            stringBuffer.append(this.font.toString());
            stringBuffer.append(", frc: ");
            stringBuffer.append(this.frc.toString());
            stringBuffer.append(", glyphs: (");
            stringBuffer.append(this.glyphs.length);
            stringBuffer.append(")[");
            for (n = 0; n < this.glyphs.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(Integer.toHexString(this.glyphs[n]));
            }
            stringBuffer.append("]");
            if (this.positions != null) {
                stringBuffer.append(", positions: (");
                stringBuffer.append(this.positions.length);
                stringBuffer.append(")[");
                for (n = 0; n < this.positions.length; n += 2) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.positions[n]);
                    stringBuffer.append("@");
                    stringBuffer.append(this.positions[n + 1]);
                }
                stringBuffer.append("]");
            }
            if (this.charIndices != null) {
                stringBuffer.append(", indices: (");
                stringBuffer.append(this.charIndices.length);
                stringBuffer.append(")[");
                for (n = 0; n < this.charIndices.length; ++n) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.charIndices[n]);
                }
                stringBuffer.append("]");
            }
            stringBuffer.append(", flags:");
            if (this.getLayoutFlags() == 0) {
                stringBuffer.append(" default");
            } else {
                if ((this.flags & 1) != 0) {
                    stringBuffer.append(" tx");
                }
                if ((this.flags & 2) != 0) {
                    stringBuffer.append(" pos");
                }
                if ((this.flags & 4) != 0) {
                    stringBuffer.append(" rtl");
                }
                if ((this.flags & 8) != 0) {
                    stringBuffer.append(" complex");
                }
            }
        }
        catch (Exception exception) {
            stringBuffer.append(" " + exception.getMessage());
        }
        stringBuffer.append("}");
        return stringBuffer;
    }

    static class ADL {
        public float ascentX;
        public float ascentY;
        public float descentX;
        public float descentY;
        public float leadingX;
        public float leadingY;

        ADL() {
        }

        public String toString() {
            return this.toStringBuffer(null).toString();
        }

        protected StringBuffer toStringBuffer(StringBuffer stringBuffer) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append("ax: ");
            stringBuffer.append(this.ascentX);
            stringBuffer.append(" ay: ");
            stringBuffer.append(this.ascentY);
            stringBuffer.append(" dx: ");
            stringBuffer.append(this.descentX);
            stringBuffer.append(" dy: ");
            stringBuffer.append(this.descentY);
            stringBuffer.append(" lx: ");
            stringBuffer.append(this.leadingX);
            stringBuffer.append(" ly: ");
            stringBuffer.append(this.leadingY);
            return stringBuffer;
        }
    }

    public static final class GlyphStrike {
        StandardGlyphVector sgv;
        FontStrike strike;
        float dx;
        float dy;

        static GlyphStrike create(StandardGlyphVector standardGlyphVector, AffineTransform affineTransform, AffineTransform affineTransform2) {
            float f = 0.0f;
            float f2 = 0.0f;
            AffineTransform affineTransform3 = standardGlyphVector.ftx;
            if (!affineTransform.isIdentity() || affineTransform2 != null) {
                affineTransform3 = new AffineTransform(standardGlyphVector.ftx);
                if (affineTransform2 != null) {
                    affineTransform3.preConcatenate(affineTransform2);
                    f = (float)affineTransform3.getTranslateX();
                    f2 = (float)affineTransform3.getTranslateY();
                }
                if (!affineTransform.isIdentity()) {
                    affineTransform3.preConcatenate(affineTransform);
                }
            }
            int n = 1;
            Object object = standardGlyphVector.frc.getAntiAliasingHint();
            if (object == RenderingHints.VALUE_TEXT_ANTIALIAS_GASP && !affineTransform3.isIdentity() && (affineTransform3.getType() & 0xFFFFFFFE) != 0) {
                double d = affineTransform3.getShearX();
                if (d != 0.0) {
                    double d2 = affineTransform3.getScaleY();
                    n = (int)Math.sqrt(d * d + d2 * d2);
                } else {
                    n = (int)Math.abs(affineTransform3.getScaleY());
                }
            }
            int n2 = FontStrikeDesc.getAAHintIntVal(object, standardGlyphVector.font2D, n);
            int n3 = FontStrikeDesc.getFMHintIntVal(standardGlyphVector.frc.getFractionalMetricsHint());
            FontStrikeDesc fontStrikeDesc = new FontStrikeDesc(affineTransform, affineTransform3, standardGlyphVector.font.getStyle(), n2, n3);
            Font2D font2D = standardGlyphVector.font2D;
            if (Font2D.fontSubstitutionEnabled && font2D instanceof FontSubstitution) {
                font2D = ((FontSubstitution)((Object)font2D)).getCompositeFont2D();
            }
            FontStrike fontStrike = font2D.handle.font2D.getStrike(fontStrikeDesc);
            return new GlyphStrike(standardGlyphVector, fontStrike, f, f2);
        }

        private GlyphStrike(StandardGlyphVector standardGlyphVector, FontStrike fontStrike, float f, float f2) {
            this.sgv = standardGlyphVector;
            this.strike = fontStrike;
            this.dx = f;
            this.dy = f2;
        }

        void getADL(ADL aDL) {
            StrikeMetrics strikeMetrics = this.strike.getFontMetrics();
            Point2D.Float float_ = null;
            if (this.sgv.font.isTransformed()) {
                float_ = new Point2D.Float();
                float_.x = (float)this.sgv.font.getTransform().getTranslateX();
                float_.y = (float)this.sgv.font.getTransform().getTranslateY();
            }
            aDL.ascentX = -strikeMetrics.ascentX;
            aDL.ascentY = -strikeMetrics.ascentY;
            aDL.descentX = strikeMetrics.descentX;
            aDL.descentY = strikeMetrics.descentY;
            aDL.leadingX = strikeMetrics.leadingX;
            aDL.leadingY = strikeMetrics.leadingY;
        }

        void getGlyphPosition(int n, int n2, float[] fArray, float[] fArray2) {
            fArray2[n2] = fArray[n2] + this.dx;
            fArray2[++n2] = fArray[n2] + this.dy;
        }

        void addDefaultGlyphAdvance(int n, Point2D.Float float_) {
            Point2D.Float float_2 = this.strike.getGlyphMetrics(n);
            float_.x += float_2.x + this.dx;
            float_.y += float_2.y + this.dy;
        }

        Rectangle2D getGlyphOutlineBounds(int n, float f, float f2) {
            Rectangle2D rectangle2D = null;
            if (this.sgv.invdtx == null) {
                rectangle2D = new Rectangle2D.Float();
                rectangle2D.setRect(this.strike.getGlyphOutlineBounds(n));
            } else {
                GeneralPath generalPath = this.strike.getGlyphOutline(n, 0.0f, 0.0f);
                generalPath.transform(this.sgv.invdtx);
                rectangle2D = generalPath.getBounds2D();
            }
            if (!rectangle2D.isEmpty()) {
                rectangle2D.setRect(rectangle2D.getMinX() + (double)f + (double)this.dx, rectangle2D.getMinY() + (double)f2 + (double)this.dy, rectangle2D.getWidth(), rectangle2D.getHeight());
            }
            return rectangle2D;
        }

        void appendGlyphOutline(int n, GeneralPath generalPath, float f, float f2) {
            GeneralPath generalPath2 = null;
            if (this.sgv.invdtx == null) {
                generalPath2 = this.strike.getGlyphOutline(n, f + this.dx, f2 + this.dy);
            } else {
                generalPath2 = this.strike.getGlyphOutline(n, 0.0f, 0.0f);
                generalPath2.transform(this.sgv.invdtx);
                generalPath2.transform(AffineTransform.getTranslateInstance(f + this.dx, f2 + this.dy));
            }
            PathIterator pathIterator = generalPath2.getPathIterator(null);
            generalPath.append(pathIterator, false);
        }
    }

    static final class GlyphTransformInfo {
        StandardGlyphVector sgv;
        int[] indices;
        double[] transforms;
        SoftReference strikesRef;
        boolean haveAllStrikes;

        GlyphTransformInfo(StandardGlyphVector standardGlyphVector) {
            this.sgv = standardGlyphVector;
        }

        GlyphTransformInfo(StandardGlyphVector standardGlyphVector, GlyphTransformInfo glyphTransformInfo) {
            this.sgv = standardGlyphVector;
            this.indices = glyphTransformInfo.indices == null ? null : (int[])glyphTransformInfo.indices.clone();
            this.transforms = glyphTransformInfo.transforms == null ? null : (double[])glyphTransformInfo.transforms.clone();
            this.strikesRef = null;
        }

        public boolean equals(GlyphTransformInfo glyphTransformInfo) {
            if (glyphTransformInfo == null) {
                return false;
            }
            if (glyphTransformInfo == this) {
                return true;
            }
            if (this.indices.length != glyphTransformInfo.indices.length) {
                return false;
            }
            if (this.transforms.length != glyphTransformInfo.transforms.length) {
                return false;
            }
            for (int i = 0; i < this.indices.length; ++i) {
                int n;
                int n2 = this.indices[i];
                if (n2 == 0 != ((n = glyphTransformInfo.indices[i]) == 0)) {
                    return false;
                }
                if (n2 == 0) continue;
                n2 *= 6;
                n *= 6;
                for (int j = 6; j > 0; --j) {
                    if (this.indices[--n2] == glyphTransformInfo.indices[--n]) continue;
                    return false;
                }
            }
            return true;
        }

        void setGlyphTransform(int n, AffineTransform affineTransform) {
            double[] dArray = new double[6];
            boolean bl = true;
            if (affineTransform == null || affineTransform.isIdentity()) {
                dArray[3] = 1.0;
                dArray[0] = 1.0;
            } else {
                bl = false;
                affineTransform.getMatrix(dArray);
            }
            if (this.indices == null) {
                if (bl) {
                    return;
                }
                this.indices = new int[this.sgv.glyphs.length];
                this.indices[n] = 1;
                this.transforms = dArray;
            } else {
                int n2;
                int n3;
                boolean bl2 = false;
                int n4 = -1;
                if (bl) {
                    n4 = 0;
                } else {
                    bl2 = true;
                    block0: for (n3 = 0; n3 < this.transforms.length; n3 += 6) {
                        for (n2 = 0; n2 < 6; ++n2) {
                            if (this.transforms[n3 + n2] != dArray[n2]) continue block0;
                        }
                        bl2 = false;
                        break;
                    }
                    n4 = n3 / 6 + 1;
                }
                n3 = this.indices[n];
                if (n4 != n3) {
                    n2 = 0;
                    if (n3 != 0) {
                        n2 = 1;
                        for (int i = 0; i < this.indices.length; ++i) {
                            if (this.indices[i] != n3 || i == n) continue;
                            n2 = 0;
                            break;
                        }
                    }
                    if (n2 != 0 && bl2) {
                        n4 = n3;
                        System.arraycopy(dArray, 0, this.transforms, (n4 - 1) * 6, 6);
                    } else if (n2 != 0) {
                        if (this.transforms.length == 6) {
                            this.indices = null;
                            this.transforms = null;
                            this.sgv.clearCaches(n);
                            this.sgv.clearFlags(1);
                            this.strikesRef = null;
                            return;
                        }
                        double[] dArray2 = new double[this.transforms.length - 6];
                        System.arraycopy(this.transforms, 0, dArray2, 0, (n3 - 1) * 6);
                        System.arraycopy(this.transforms, n3 * 6, dArray2, (n3 - 1) * 6, this.transforms.length - n3 * 6);
                        this.transforms = dArray2;
                        for (int i = 0; i < this.indices.length; ++i) {
                            if (this.indices[i] <= n3) continue;
                            int n5 = i;
                            this.indices[n5] = this.indices[n5] - 1;
                        }
                        if (n4 > n3) {
                            // empty if block
                        }
                    } else if (bl2) {
                        double[] dArray3 = new double[this.transforms.length + 6];
                        System.arraycopy(this.transforms, 0, dArray3, 0, this.transforms.length);
                        System.arraycopy(dArray, 0, dArray3, this.transforms.length, 6);
                        this.transforms = dArray3;
                    }
                    this.indices[n] = --n4;
                }
            }
            this.sgv.clearCaches(n);
            this.sgv.addFlags(1);
            this.strikesRef = null;
        }

        AffineTransform getGlyphTransform(int n) {
            int n2 = this.indices[n];
            if (n2 == 0) {
                return null;
            }
            int n3 = (n2 - 1) * 6;
            return new AffineTransform(this.transforms[n3 + 0], this.transforms[n3 + 1], this.transforms[n3 + 2], this.transforms[n3 + 3], this.transforms[n3 + 4], this.transforms[n3 + 5]);
        }

        int transformCount() {
            if (this.transforms == null) {
                return 0;
            }
            return this.transforms.length / 6;
        }

        Object setupGlyphImages(long[] lArray, float[] fArray, AffineTransform affineTransform) {
            int n = this.sgv.glyphs.length;
            GlyphStrike[] glyphStrikeArray = this.getAllStrikes();
            for (int i = 0; i < n; ++i) {
                GlyphStrike glyphStrike = glyphStrikeArray[this.indices[i]];
                int n2 = this.sgv.glyphs[i];
                lArray[i] = glyphStrike.strike.getGlyphImagePtr(n2);
                glyphStrike.getGlyphPosition(n2, i * 2, this.sgv.positions, fArray);
            }
            affineTransform.transform(fArray, 0, fArray, 0, n);
            return glyphStrikeArray;
        }

        Rectangle getGlyphsPixelBounds(AffineTransform affineTransform, float f, float f2, int n, int n2) {
            Rectangle rectangle = null;
            Rectangle rectangle2 = new Rectangle();
            Point2D.Float float_ = new Point2D.Float();
            int n3 = n * 2;
            while (--n2 >= 0) {
                GlyphStrike glyphStrike = this.getStrike(n);
                float_.x = f + this.sgv.positions[n3++] + glyphStrike.dx;
                float_.y = f2 + this.sgv.positions[n3++] + glyphStrike.dy;
                affineTransform.transform(float_, float_);
                glyphStrike.strike.getGlyphImageBounds(this.sgv.glyphs[n++], float_, rectangle2);
                if (rectangle2.isEmpty()) continue;
                if (rectangle == null) {
                    rectangle = new Rectangle(rectangle2);
                    continue;
                }
                rectangle.add(rectangle2);
            }
            return rectangle != null ? rectangle : rectangle2;
        }

        GlyphStrike getStrike(int n) {
            if (this.indices != null) {
                GlyphStrike[] glyphStrikeArray = this.getStrikeArray();
                return this.getStrikeAtIndex(glyphStrikeArray, this.indices[n]);
            }
            return this.sgv.getDefaultStrike();
        }

        private GlyphStrike[] getAllStrikes() {
            if (this.indices == null) {
                return null;
            }
            GlyphStrike[] glyphStrikeArray = this.getStrikeArray();
            if (!this.haveAllStrikes) {
                for (int i = 0; i < glyphStrikeArray.length; ++i) {
                    this.getStrikeAtIndex(glyphStrikeArray, i);
                }
                this.haveAllStrikes = true;
            }
            return glyphStrikeArray;
        }

        private GlyphStrike[] getStrikeArray() {
            GlyphStrike[] glyphStrikeArray = null;
            if (this.strikesRef != null) {
                glyphStrikeArray = (GlyphStrike[])this.strikesRef.get();
            }
            if (glyphStrikeArray == null) {
                this.haveAllStrikes = false;
                glyphStrikeArray = new GlyphStrike[this.transformCount() + 1];
                this.strikesRef = new SoftReference<GlyphStrike[]>(glyphStrikeArray);
            }
            return glyphStrikeArray;
        }

        private GlyphStrike getStrikeAtIndex(GlyphStrike[] glyphStrikeArray, int n) {
            GlyphStrike glyphStrike = glyphStrikeArray[n];
            if (glyphStrike == null) {
                if (n == 0) {
                    glyphStrike = this.sgv.getDefaultStrike();
                } else {
                    int n2 = (n - 1) * 6;
                    AffineTransform affineTransform = new AffineTransform(this.transforms[n2], this.transforms[n2 + 1], this.transforms[n2 + 2], this.transforms[n2 + 3], this.transforms[n2 + 4], this.transforms[n2 + 5]);
                    glyphStrike = GlyphStrike.create(this.sgv, this.sgv.dtx, affineTransform);
                }
                glyphStrikeArray[n] = glyphStrike;
            }
            return glyphStrike;
        }
    }
}

