/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.peer.RobotPeer;
import sun.awt.AWTAccessor;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsEnvironment;

class XRobotPeer
implements RobotPeer {
    private static volatile boolean isGtkSupported;
    private X11GraphicsConfig xgc = null;
    static Object robotLock;

    XRobotPeer(GraphicsConfiguration graphicsConfiguration) {
        this.xgc = (X11GraphicsConfig)graphicsConfiguration;
        SunToolkit sunToolkit = (SunToolkit)Toolkit.getDefaultToolkit();
        XRobotPeer.setup(sunToolkit.getNumberOfButtons(), AWTAccessor.getInputEventAccessor().getButtonDownMasks());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!isGtkSupported && toolkit instanceof UNIXToolkit && ((UNIXToolkit)toolkit).loadGTK()) {
            isGtkSupported = true;
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void mouseMove(int n, int n2) {
        XRobotPeer.mouseMoveImpl(this.xgc, n, n2);
    }

    @Override
    public void mousePress(int n) {
        XRobotPeer.mousePressImpl(n);
    }

    @Override
    public void mouseRelease(int n) {
        XRobotPeer.mouseReleaseImpl(n);
    }

    @Override
    public void mouseWheel(int n) {
        XRobotPeer.mouseWheelImpl(n);
    }

    @Override
    public void keyPress(int n) {
        XRobotPeer.keyPressImpl(n);
    }

    @Override
    public void keyRelease(int n) {
        XRobotPeer.keyReleaseImpl(n);
    }

    @Override
    public int getRGBPixel(int n, int n2) {
        int[] nArray = new int[1];
        XRobotPeer.getRGBPixelsImpl(this.xgc, n, n2, 1, 1, nArray, isGtkSupported, X11GraphicsEnvironment.isWayland());
        return nArray[0];
    }

    @Override
    public int[] getRGBPixels(Rectangle rectangle) {
        int[] nArray = new int[rectangle.width * rectangle.height];
        XRobotPeer.getRGBPixelsImpl(this.xgc, rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray, isGtkSupported, X11GraphicsEnvironment.isWayland());
        return nArray;
    }

    private static synchronized native void setup(int var0, int[] var1);

    private static synchronized native void mouseMoveImpl(X11GraphicsConfig var0, int var1, int var2);

    private static synchronized native void mousePressImpl(int var0);

    private static synchronized native void mouseReleaseImpl(int var0);

    private static synchronized native void mouseWheelImpl(int var0);

    private static synchronized native void keyPressImpl(int var0);

    private static synchronized native void keyReleaseImpl(int var0);

    private static synchronized native void getRGBPixelsImpl(X11GraphicsConfig var0, int var1, int var2, int var3, int var4, int[] var5, boolean var6, boolean var7);

    static {
        robotLock = new Object();
    }
}

