/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import javax.swing.text.BadLocationException;
import javax.swing.text.GlyphView;
import javax.swing.text.ParagraphView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

class GlyphPainter1
extends GlyphView.GlyphPainter {
    FontMetrics metrics;

    GlyphPainter1() {
    }

    @Override
    public float getSpan(GlyphView glyphView, int n, int n2, TabExpander tabExpander, float f) {
        this.sync(glyphView);
        Segment segment = glyphView.getText(n, n2);
        int[] nArray = this.getJustificationData(glyphView);
        int n3 = Utilities.getTabbedTextWidth(glyphView, segment, this.metrics, (int)f, tabExpander, n, nArray);
        SegmentCache.releaseSharedSegment(segment);
        return n3;
    }

    @Override
    public float getHeight(GlyphView glyphView) {
        this.sync(glyphView);
        return this.metrics.getHeight();
    }

    @Override
    public float getAscent(GlyphView glyphView) {
        this.sync(glyphView);
        return this.metrics.getAscent();
    }

    @Override
    public float getDescent(GlyphView glyphView) {
        this.sync(glyphView);
        return this.metrics.getDescent();
    }

    @Override
    public void paint(GlyphView glyphView, Graphics graphics, Shape shape, int n, int n2) {
        int n3;
        Segment segment;
        this.sync(glyphView);
        TabExpander tabExpander = glyphView.getTabExpander();
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n4 = rectangle.x;
        int n5 = glyphView.getStartOffset();
        int[] nArray = this.getJustificationData(glyphView);
        if (n5 != n) {
            segment = glyphView.getText(n5, n);
            n3 = Utilities.getTabbedTextWidth(glyphView, segment, this.metrics, n4, tabExpander, n5, nArray);
            n4 += n3;
            SegmentCache.releaseSharedSegment(segment);
        }
        n3 = rectangle.y + this.metrics.getHeight() - this.metrics.getDescent();
        segment = glyphView.getText(n, n2);
        graphics.setFont(this.metrics.getFont());
        Utilities.drawTabbedText(glyphView, segment, n4, n3, graphics, tabExpander, n, nArray);
        SegmentCache.releaseSharedSegment(segment);
    }

    @Override
    public Shape modelToView(GlyphView glyphView, int n, Position.Bias bias, Shape shape) throws BadLocationException {
        this.sync(glyphView);
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n2 = glyphView.getStartOffset();
        int n3 = glyphView.getEndOffset();
        TabExpander tabExpander = glyphView.getTabExpander();
        if (n == n3) {
            return new Rectangle(rectangle.x + rectangle.width, rectangle.y, 0, this.metrics.getHeight());
        }
        if (n >= n2 && n <= n3) {
            Segment segment = glyphView.getText(n2, n);
            int[] nArray = this.getJustificationData(glyphView);
            int n4 = Utilities.getTabbedTextWidth(glyphView, segment, this.metrics, rectangle.x, tabExpander, n2, nArray);
            SegmentCache.releaseSharedSegment(segment);
            return new Rectangle(rectangle.x + n4, rectangle.y, 0, this.metrics.getHeight());
        }
        throw new BadLocationException("modelToView - can't convert", n3);
    }

    @Override
    public int viewToModel(GlyphView glyphView, float f, float f2, Shape shape, Position.Bias[] biasArray) {
        this.sync(glyphView);
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n = glyphView.getStartOffset();
        int n2 = glyphView.getEndOffset();
        TabExpander tabExpander = glyphView.getTabExpander();
        Segment segment = glyphView.getText(n, n2);
        int[] nArray = this.getJustificationData(glyphView);
        int n3 = Utilities.getTabbedTextOffset(glyphView, segment, this.metrics, rectangle.x, (int)f, tabExpander, n, nArray);
        SegmentCache.releaseSharedSegment(segment);
        int n4 = n + n3;
        if (n4 == n2) {
            --n4;
        }
        biasArray[0] = Position.Bias.Forward;
        return n4;
    }

    @Override
    public int getBoundedPosition(GlyphView glyphView, int n, float f, float f2) {
        this.sync(glyphView);
        TabExpander tabExpander = glyphView.getTabExpander();
        Segment segment = glyphView.getText(n, glyphView.getEndOffset());
        int[] nArray = this.getJustificationData(glyphView);
        int n2 = Utilities.getTabbedTextOffset(glyphView, segment, this.metrics, (int)f, (int)(f + f2), tabExpander, n, false, nArray);
        SegmentCache.releaseSharedSegment(segment);
        int n3 = n + n2;
        return n3;
    }

    void sync(GlyphView glyphView) {
        Serializable serializable;
        Serializable serializable2;
        if (this.metrics != null) {
            serializable2 = this.metrics.getFontRenderContext().getTransform();
            serializable = SwingUtilities2.getFontRenderContext(glyphView.getContainer()).getTransform();
            if (((AffineTransform)serializable2).getScaleX() != ((AffineTransform)serializable).getScaleX() || ((AffineTransform)serializable2).getScaleY() != ((AffineTransform)serializable).getScaleY()) {
                this.metrics = null;
            }
        }
        serializable2 = glyphView.getFont();
        if (this.metrics == null || !((Font)serializable2).equals(this.metrics.getFont())) {
            serializable = glyphView.getContainer();
            this.metrics = serializable != null ? ((Component)serializable).getFontMetrics((Font)serializable2) : Toolkit.getDefaultToolkit().getFontMetrics((Font)serializable2);
        }
    }

    private int[] getJustificationData(GlyphView glyphView) {
        View view = glyphView.getParent();
        int[] nArray = null;
        if (view instanceof ParagraphView.Row) {
            ParagraphView.Row row = (ParagraphView.Row)view;
            nArray = row.justificationData;
        }
        return nArray;
    }
}

