/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMNamespaceContext
implements NamespaceContext {
    private Map<String, String> namespaceMap = new HashMap<String, String>();

    public DOMNamespaceContext(Node node) {
        this.addNamespaces(node);
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.namespaceMap.get(string);
    }

    @Override
    public String getPrefix(String string) {
        for (String string2 : this.namespaceMap.keySet()) {
            String string3 = this.namespaceMap.get(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String string) {
        return this.namespaceMap.keySet().iterator();
    }

    private void addNamespaces(Node node) {
        if (node.getParentNode() != null) {
            this.addNamespaces(node.getParentNode());
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (!"xmlns".equals(attr.getPrefix())) continue;
                this.namespaceMap.put(attr.getLocalName(), attr.getValue());
            }
        }
    }
}

