/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StyledFontLayoutTest
extends JPanel {
    static final int W = 600;
    static final int H = 400;
    static boolean interactive;
    static BufferedImage im;

    public static void main(String[] stringArray) {
        interactive = stringArray.length > 0;
        StyledFontLayoutTest.runTest();
        if (!interactive) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            JFrame jFrame = new JFrame("Styled Font Layout Test");
            jFrame.add(new StyledFontLayoutTest());
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(600, 400);
            jFrame.setLocationRelativeTo(null);
            jFrame.setVisible(true);
        });
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.drawImage(im, 0, 0, null);
    }

    private static void runTest() {
        im = new BufferedImage(600, 400, 1);
        Graphics2D graphics2D = im.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, 600, 400);
        graphics2D.setColor(Color.black);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        char[] cArray = "Sample Text.".toCharArray();
        int n = cArray.length;
        int n2 = 50;
        int n3 = 100;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = new Font("Serif", 0, 48);
        GlyphVector glyphVector = font.layoutGlyphVector(fontRenderContext, cArray, 0, n, 0);
        graphics2D.setFont(font);
        graphics2D.drawChars(cArray, 0, n, n2, n3);
        graphics2D.drawGlyphVector(glyphVector, n2, n3 += 50);
        n3 += 50;
        Rectangle2D rectangle2D = font.getStringBounds(cArray, 0, n, fontRenderContext);
        Rectangle2D rectangle2D2 = glyphVector.getLogicalBounds();
        Font font2 = new Font("Serif", 1, 48);
        GlyphVector glyphVector2 = font2.layoutGlyphVector(fontRenderContext, cArray, 0, n, 0);
        Rectangle2D rectangle2D3 = font2.getStringBounds(cArray, 0, n, fontRenderContext);
        Rectangle2D rectangle2D4 = glyphVector2.getLogicalBounds();
        graphics2D.setFont(font2);
        graphics2D.drawChars(cArray, 0, n, n2, n3);
        graphics2D.drawGlyphVector(glyphVector2, n2, n3 += 50);
        System.out.println("Plain String Bounds = " + rectangle2D);
        System.out.println("Bold String Bounds = " + rectangle2D3);
        System.out.println("Plain GlyphVector Bounds = " + rectangle2D2);
        System.out.println("Bold GlyphVector Bounds = " + rectangle2D4);
        if (!rectangle2D.equals(rectangle2D3) && rectangle2D2.equals(rectangle2D4)) {
            System.out.println("Test failed: Plain GV bounds same as Bold");
            if (!interactive) {
                throw new RuntimeException("Plain GV bounds same as Bold");
            }
        }
    }
}

