#define _XOPEN_SOURCE 600
#define _LARGEFILE64_SOURCE 1
//#define _FILE_OFFSET_BITS 64
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <sys/stat.h>

#include "fallocate.h"

static int err = 0;
__off64_t exp_res[] = {0ULL, 16*1024ULL, 256*1024ULL, 8*1024*1024*1024ULL, 
				              100ULL, 8*1024*1024*1024ULL,
		       0ULL, 0ULL, 256*1024ULL, 256*1024ULL, 100ULL, 100ULL};
static int idx = 0;

#define TEST_RES(FUNC,FD) test_res(FUNC,FD,#FUNC)

void test_res(int err, int fd, const char* str)
{
	struct stat64 st;
	if (fstat64(fd, &st)) {
		++err;
		fprintf(stderr, "!!! fstat64(%i) failed\n", fd);
		return;
	}
	if (err != 0) {
		fprintf(stderr, "! %s failed w/ %i: %s\n", str, err, strerror(errno));
		exp_res[idx] = exp_res[idx-1];
	}
#if __WORDSIZE == 64
	printf("  file size %zi, expected %zi, used %li k\n", st.st_size, exp_res[idx], st.st_blocks/2);
#else
	printf("  file size %Li, expected %Li, used %Li k\n", st.st_size, exp_res[idx], st.st_blocks/2);
#endif
	if (st.st_size != exp_res[idx++]) {
		fprintf(stderr, "!!! ERROR: Mismatch! ***\n");
		++err;
	}
	return;	
}

int main(int argc, char *argv[])
{
	int fd;
	if (argc < 2)
		return -1;
	printf("__off64_t has %i bits\n", 8*(int)sizeof(__off64_t));
	fd = open(argv[1], O_RDWR | O_CREAT | O_TRUNC | O_LARGEFILE, 0644);
	test_res(0, fd, "");
	TEST_RES(fallocate64_with_fallback(fd, 0, 0, 16*1024, 1, 1), fd);
	TEST_RES(posix_fallocate(fd, 0, 256*1024), fd);
	TEST_RES(linux_fallocate64(fd, 0, 256*1024, 8*1024*1024*1024ULL-256*1024ULL), fd);
	TEST_RES(ftruncate(fd, 100), fd);
	TEST_RES(fallocate64_with_fallback(fd, 0, 256*1024, 
				  8*1024*1024*1024ULL-256*1024ULL, 0, 1), fd);
	close(fd);
	fd = open(argv[1], O_RDWR | O_CREAT | O_TRUNC | O_LARGEFILE, 0644);
	test_res(0, fd, "");
	TEST_RES(fallocate64_with_fallback(fd, FALLOC_FL_KEEP_SIZE, 0, 16*1024, 1, 1), fd);
	TEST_RES(posix_fallocate(fd, 0, 256*1024), fd);
	TEST_RES(linux_fallocate64(fd, FALLOC_FL_KEEP_SIZE, 256*1024, 
			8*1024*1024*1024ULL-256*1024ULL), fd);
	TEST_RES(ftruncate(fd, 100), fd);
	TEST_RES(fallocate64_with_fallback(fd, FALLOC_FL_KEEP_SIZE, 256*1024, 
				8*1024*1024*1024ULL-256*1024ULL, 0, 1), fd);
	return err;
}

