Name: libfallocate0
Version: 0.1.1
Release: 0
URL: http://libfallocate.sf.net/
Source: libfallocate-%{version}.tar.bz2
#Patch:
BuildRequires: gcc glibc-devel autoconf
BuildRoot: /var/tmp/%{name}-%{version}-build
Prefix: /usr
Summary: filesystem preallocation interface library
License: GNU LGPL v2.1 or later
Group: System/Filesystems

%description
libfallocate provides an interface for applications to tell filesystems
about the size of to-be-written files, so the filesystem can do a better
job in taking allocation decisions to avoid fragmentation.

libfallocate provides a wrapper for the fallocate() syscall in case your
glibc (<2.10) does not have it yet. It also provides linux_fallocate()
which will attempt the space reservation ioctl that xfs and ocfs2
provide in case fallocate() did not succeed.

It has an additional richer interface fallocate_with_fallback() that
allows you to instruct it to fallback to do preallocation by zeroing
things out (like posix_fallocate()) or to extend the file size by a sparse
write (like a successful fallocate() with mode==0 would have done).


Authors:
--------
Kurt Garloff <garloff@suse.de>

%package -n libfallocate-devel
Requires: %{name} = %{version}
Summary: header and devel files for libfallocate
Group: Development/Libraries/C and C++

%description -n libfallocate-devel
This package contains the header file and the .so library to link
against for apps that want to use libfallocate.

%prep
%setup -n libfallocate-%{version}

%build
./autogen.sh
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS" static

%check
make check

%install
make install-lib install-static install-header DESTDIR=$RPM_BUILD_ROOT PREFIX=%{_prefix} LIBDIR=%{_libdir} DOCDIR=%{_docdir}/libfallocate0

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(0755,root,root)
%{_libdir}/libfallocate.so.*
%defattr(-,root,root)
%doc README TODO COPYING AUTHORS

%files -n libfallocate-devel
%defattr(0755,root,root)
%{_libdir}/libfallocate.so
%defattr(0644,root,root)
%{_libdir}/libfallocate.a
%{_prefix}/include/fallocate.h

