/** Internal interfaces for libfallocate. */
#ifndef _FALLOCATE_INTERNAL_H
#define _FALLOCATE_INTERNAL_H

#include "fallocate.h"

#ifdef HAVE_CONFIG_H
#include "falloc_config.h"
#endif

#if __GNUC__ >= 4
# define HIDDEN __attribute__((visibility("hidden")))
#else
# define HIDDEN  
#endif

extern int fallocate64_sparse(int fd, int mode, __off64_t start, 
			      __off64_t len, const struct stat64 *stbuf) HIDDEN;
extern int fallocate64_zero(int fd, __off64_t start, __off64_t len, 
			    const struct stat64 *stbuf) HIDDEN;
extern int fallocate64_xfs_ocfs2(int fd, int mode, __off64_t start, 
				 __off64_t len, const struct stat64 *stbuf) HIDDEN;
#endif /* _FALLOCATE_INTERNAL_H */

