#define _XOPEN_SOURCE 600
#define _LARGEFILE64_SOURCE 1
//#define _FILE_OFFSET_BITS 64
#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>

#include "fallocate_internal.h"

int fallocate64_sparse(int fd, int mode, __off64_t start, 
		       __off64_t len, const struct stat64 *stbuf)
{
	int dummy = 0;
	/* Don't overwrite existing data */
	if (stbuf->st_size >= start+len)
	       return 0;
	if (mode == 0)
		return (pwrite64(fd, &dummy, 1, start+len-1) == 1? 0: -1);
	else if (mode == (int)FALLOC_FL_KEEP_SIZE)
		return pwrite64(fd, &dummy, 0, start+len);
	else
		return -1;
}

#if !defined(HAVE_POSIX_FALLOCATE)
static inline __off64_t lmax(__off64_t a1, __off64_t a2)
{
	return (a1 > a2? a1: a2);
}

static inline __off64_t lmin(__off64_t a1, __off64_t a2)
{
	return (a1 < a2? a1: a2);
}


int fallocate64_zero(int fd, __off64_t start, __off64_t len, 
		     const struct stat64 *stbuf)
{
	ssize_t wr = -1;
	__off64_t realstart = lmax(start, stbuf->st_size);
	__off64_t towrite = start+len-realstart;
	/* Don't overwrite existing data */
	if (towrite < 0)
	       return 0;
       	int zfd = open("/dev/zero", O_RDONLY);
	size_t maplen = lmin((towrite+4095)/4096*4096, 4*1024*1024);
	void* ptr = mmap(NULL, maplen, PROT_READ, MAP_PRIVATE, zfd, 0);
	if (ptr > 0) {
		while (towrite > 0) {
			wr = pwrite64(fd, ptr, lmin(towrite, maplen),
				      realstart);
			realstart += wr; towrite -= wr;
		}
		munmap(ptr, maplen);
	}
	close(zfd);
	return wr>=0? 0: wr;
}
#endif
