/* This is from the linux kernel header (2.6.31-rc), 
 * slightly modified */

#ifndef _FALLOC_H_
#define _FALLOC_H_

#include <stdint.h>
#if 0
#include <asm-generic/ioctl.h>
#else
#include <sys/ioctl.h>
#endif


/**
 * Space reservation ioctls and argument structure
 * are designed to be compatible with the legacy XFS ioctls.
 */
struct space_resv {
	int16_t		l_type;
	int16_t		l_whence;
	int64_t		l_start;
	int64_t		l_len;		/* len == 0 means until end of file */
	int32_t		l_sysid;
	uint32_t	l_pid;
	int32_t		l_pad[4];	/* reserved area */
};

#define FS_IOC_RESVSP		_IOW('X', 40, struct space_resv)
#define FS_IOC_UNRESVSP		_IOW('X', 41, struct space_resv)
#define FS_IOC_RESVSP64		_IOW('X', 42, struct space_resv)
#define FS_IOC_UNRESVSP64	_IOW('X', 43, struct space_resv)

#endif /* _FALLOC_H_ */
