/*
 * Obtains disks capacity and usage, and writes these to xenstore.
 *
 * Copyright 2016, Huawei Tech. Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation; or, when distributed
 * separately from the Linux kernel or incorporated into other
 * software packages, subject to the following license:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this source file (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy, modify,
 * merge, publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */


#include "libxenctl.h"
#include "public_common.h"
#include <sys/vfs.h>
#include <mntent.h>
#include <sys/stat.h>
#include <ctype.h>
#include <dirent.h>
#include <unistd.h>
#include "securec.h"

#define PROC_PARTITIONS             "/proc/partitions"
#define PROC_SWAPS                  "/proc/swaps"
#define PROC_MOUNTS                 "/proc/mounts"
#define PROC_DEVICES                "/proc/devices"
#define DISK_DATA_PATH              "control/uvp/disk"
#define FILE_DATA_PATH              "control/uvp/filesystem"
/*xenstore֧4096ֽڣƺֵٽfilesystemϢд*/
#define FILE_DATA_EXTRA_PATH_PREFIX        "control/uvp/filesystem_extra"
/*filesystemֵĿ*/
#define FILE_NUM_PATH               "control/uvp/filesystem_extra_num"
#define DEVPATH                     "/dev/disk/by-id/"
#define CMPSTRING                   "../../"
#define SCSI_DISK_PATH              "device/vscsi"
#define RAM_MAJOR                   1
#define LOOP_MAJOR                  7
#define MAX_DISKUSAGE_LEN           1024
#define MAX_NAME_LEN                64
#define MAX_STR_LEN                 1024
#define UNIT_TRANSFER_CYCLE         1024
#define MAX_DISK_NUMBER             128          /* TODO:1.ֽ׶֧11xvdạ17scsịԺֵ֧Ĵ˴ӦӦ. 
                                                         2. Ϊ֧60ֵ̣Ϊ128*/
#define MAX_PARTNAME_LEN            10
/*֧50filesystem*/
#define MAX_FILENAMES_SIZE          52800
/*xenstoreֵ󳤶Ϊ4096ȥֵȣʣ³Ϊfilesystemɷŵĳ*/
#define MAX_FILENAMES_XENSTORLEN    4042
/*ֻϱ60̵Ϣ*/
#define MAX_DISKUSAGE_STRING_NUM    60
/*FilenamesArrװļϵͳʹ*/
char FilenameArr[MAX_FILENAMES_SIZE] = {0};
/* device-mapperӦ豸 */
int g_deviceMapperNum = 0;

/* 豸Ƽ豸Žṹ壨/proc/partitions */
struct DevMajorMinor
{
    int  devMajor;                              /* 豸豸 */
    int  devMinor;                              /* 豸豸 */
    char devBlockSize[MAX_STR_LEN];             /* 豸ĿС(KB) */
    char devName[MAX_NAME_LEN];                 /* 豸 */
};

/* Ƽʹÿռ䡢ܿռĽṹ */
struct DeviceInfo
{
    char phyDevName[MAX_NAME_LEN];                     /*  */
    char deviceTotalSpace[MAX_STR_LEN];                /* ̵ܿռ(MB) */
    char diskUsage[MAX_DISKUSAGE_LEN];                 /* ̵ʹÿռ(MB) */
};

/* صӦļϵͳϢʹÿռĽṹ */
struct DiskInfo
{
    int  st_rdev;                                  /* 洢ļϵͳӦ豸ID */
    char filesystem[MAX_STR_LEN];                  /* ļϵͳӦFileSystem */
    char usage[MAX_DISKUSAGE_LEN];                 /* ļϵͳʹÿռ(MB) */
    char mountPoint[MAX_STR_LEN];                  /* ļϵͳĹص */
};

/* ¼ǰṹʵʴ洢ĸ */
struct NumberCount
{
    int partNum;             /* ¼DevMajorMinor */
    int diskNum;             /* ¼DeviceInfo */
    int mountNum;            /* ¼DiskInfo */
};

/*****************************************************************************
 Function   : strAdd()
 Description: ַӺ
 Input      : inputNum1          һַ
              inputNum2          ڶַ
 Output     : outputResult       ַ͵ַ
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 *****************************************************************************/
int strAdd(char *inputNum1, char *inputNum2, char *outputResult)
{
    char *pszFirstNum = inputNum1;
    char *pszSecondNum = inputNum2;
    char szTmpResult[MAX_STR_LEN] = {0};
    int nFirstNumLen;
    int nSecondNumLen;
    int nTmpStrLen;
    int nNum1 = 0;
    int nNum2 = 0;
    int sum = 0;
    int ten = 0;
    int i;
    int j = 0;
    int k = 0;

    /* һΪNULLش */
    if (NULL == pszFirstNum || NULL == pszSecondNum || NULL == outputResult)
    {
        return ERROR;
    }

    nFirstNumLen = strlen(pszFirstNum);
    nSecondNumLen = strlen(pszSecondNum);

    /* нϳһݵĳ */
    nTmpStrLen = (nFirstNumLen < nSecondNumLen) ? nSecondNumLen : nFirstNumLen;
    if (MAX_STR_LEN <= nTmpStrLen)
    {
        return ERROR;
    }
    /* ѭȡÿһλ */
    for (i = 0; i < nTmpStrLen; i++)
    {
        /* ӦݳСѭλΪ0ֱӻȡλݣҽASCIIתΪ */
        j = nFirstNumLen - i - 1;
        k = nSecondNumLen - i - 1;
        (j >= 0) ? (nNum1 = pszFirstNum[j] - 48) : (nNum1 = 0);
        (k >= 0) ? (nNum2 = pszSecondNum[k] - 48) : (nNum2 = 0);
        /* ʱ־λĺͣȡλʮλ */
        sum = nNum1 + nNum2 + ten;
        ten = sum / 10;
        sum = sum % 10;
        /* Ӧĺ͵ĸλָʱַ */
        *(szTmpResult + i) = sum + 48;
    }
    /* ˳ѭλ־1ٽλ1ʱַ */
    if (1 == ten)
    {
        *(szTmpResult + i) = ten + 48;
    }

    /* ȡʱַĳȣ䰴Ƹ */
    nTmpStrLen = strlen(szTmpResult);
    for (i = 0; i < nTmpStrLen; i++)
    {
        outputResult[i] = szTmpResult[nTmpStrLen - i - 1];
    }
    /* ֶַĩβ\0ֹظʹô */
    outputResult[i] = '\0';

    return SUCC;
}

/*****************************************************************************
 Function   : strMinus()
 Description: ַ
 Input      : inputNum1          
              inputNum2          
 Output     : outputResult       ַַ
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 *****************************************************************************/
int strMinus(char *inputNum1, char *inputNum2, char *outputResult)
{
    char *pszFirstNum = inputNum1;
    char *pszSecondNum = inputNum2;
    char szTmpResult[MAX_STR_LEN] = {0};
    int nFirstNumLen;
    int nSecondNumLen;
    int nTmpStrLen;
    int nNum1 = 0;
    int nNum2 = 0;
    /* ÿλŵʱ */
    int wanting = 0;
    /* ǽλ */
    int isNegative = 0;
    /* Žַ± */
    int nTmpLocation = 0;
    int i;

    /* һΪNULLش */
    if (NULL == pszFirstNum || NULL == pszSecondNum || NULL == outputResult)
    {
        return ERROR;
    }

    nFirstNumLen = strlen(pszFirstNum);
    nSecondNumLen = strlen(pszSecondNum);

    /* ĳȴڱĳ(Ϊ)ش */
    if (nFirstNumLen < nSecondNumLen)
    {
        return ERROR;
    }

    /* ѭȡÿһλݣȻжӦݲ */
    for (i = 0; i < nSecondNumLen; i++)
    {
        /* ȡӦλϵ */
        nNum1 = pszFirstNum[nFirstNumLen - i - 1] - 48;
        nNum2 = pszSecondNum[nSecondNumLen - i - 1] - 48;
        /* жϱӦݱλǷڼĶӦСڣҪһλλ򣬲Ҫ */
        if (nNum1 >= nNum2 + isNegative)
        {
            wanting = nNum1 - nNum2 - isNegative;
            isNegative = 0;
        }
        else
        {
            wanting = nNum1 + 10 - nNum2 - isNegative;
            isNegative = 1;
        }
        /* Ӧλֵַʱַ */
        *(szTmpResult + i) = wanting + 48;
    }

    /* ѭֱĳΪֹ */
    for (; i < nFirstNumLen; i++)
    {
        nNum1 = pszFirstNum[nFirstNumLen - i - 1] - 48;
        /* λ־0Ӧ㣬ֱӽǰλݴݸ */
        if (1 == isNegative)
        {
            /* ǰλõֵС1ֱһλλ */
            if (nNum1 >= 1)
            {
                wanting = nNum1 - isNegative;
                *(szTmpResult + i) = wanting + 48;
                isNegative = 0;
            }
            else
            {
                wanting = nNum1 + 10 - isNegative;
                *(szTmpResult + i) = wanting + 48;
                isNegative = 1;
            }
        }
        else
        {
            *(szTmpResult + i) = nNum1 + 48;
        }
    }
    /* 걻λλǻǴ0򷵻ش */
    if (1 == isNegative)
    {
        return ERROR;
    }

    /* ȡʱַĳȣ䰴Ƹ */
    nTmpStrLen = strlen(szTmpResult);
    for (i = 0; i < nTmpStrLen; i++)
    {
        /* ȥλ0 */
        if (0 == strlen(outputResult) && '0' == szTmpResult[nTmpStrLen - i - 1])
        {
            continue;
        }
        outputResult[nTmpLocation] = szTmpResult[nTmpStrLen - i - 1];
        nTmpLocation++;
    }

    /* ַΪ0θֵһ0 */
    if (0 == strlen(outputResult))
    {
        (void)strncpy_s(outputResult, 3, "0", 2);
    }

    return SUCC;
}

/*****************************************************************************
 Function   : strMulti()
 Description: ַ˺
 Input      : inputNum1         һַ
                inputNum1         ڶַ
 Output     : outputResult      ַַ
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 *****************************************************************************/
int strMulti(char *inputNum1, char *inputNum2, char *outputResult)
{
    char *pszFirstNum = inputNum1;
    char *pszSecondNum = inputNum2;
    char szTmpResult[MAX_STR_LEN] = {0};
    char szOneTimeResult[MAX_STR_LEN] = {0};
    char szFinalResult[MAX_STR_LEN] = {0};
    int nFirstNumLen;
    int nSecondNumLen;
    int nTmpStrLen = 0;
    int nNum1 = 0;
    int nNum2 = 0;
    /* Žλʱ */
    int carry = 0;
    int nTempResult = 0;
    int nLen;
    int i;
    int j = 0;

    /* һΪNULLش */
    if (NULL == pszFirstNum || NULL == pszSecondNum || NULL == outputResult)
    {
        return ERROR;
    }

    nFirstNumLen = strlen(pszFirstNum);
    nSecondNumLen = strlen(pszSecondNum);

    /* ѭһַÿһλһλʼ */
    for (i = nFirstNumLen; i > 0; i--)
    {
        /* ȡӦλõ */
        nNum1 = *(pszFirstNum + i - 1) - 48;
        /* ѭһַÿһλһλʼ */
        for (j = nSecondNumLen; j > 0; j--)
        {
            /* ȡӦλõ */
            nNum2 = *(pszSecondNum + j - 1) - 48;
            /* ȡ˺λ */
            nTempResult = nNum1 * nNum2 + carry;
            /* ֱȡλββݸʱַ */
            carry = nTempResult / 10;
            nTempResult = nTempResult % 10;
            *(szTmpResult + nSecondNumLen - j) = nTempResult + 48;
        }
        /* ɺ󣬽λԲΪ0򽫽λݸʱַ */
        if (0 != carry)
        {
            *(szTmpResult + nSecondNumLen) = carry + 48;
            carry = 0;
        }
        /* ȡʱַĳȣ䰴ƴݸִеʱַ */
        nTmpStrLen = strlen(szTmpResult);
        for (j = 0; j < nTmpStrLen; j++)
        {
            szOneTimeResult[j] = szTmpResult[nTmpStrLen - j - 1];
        }
        /* ÿνĵλ0Թ˺ַӦλ */
        for (j = 0; j < nFirstNumLen - i; j++)
        {
            (void)strncat_s(szOneTimeResult, MAX_STR_LEN, "0", 2);
        }
        /* ִн˽ۼ */
        (void)strAdd(szOneTimeResult, szFinalResult, szFinalResult);
        /* ʱַ͵νַ */
        memset_s(szTmpResult, MAX_STR_LEN, 0, sizeof(szTmpResult));
        memset_s(szOneTimeResult, MAX_STR_LEN, 0, sizeof(szOneTimeResult));
    }

    /* ַɣսݸ */
    nLen = strlen(szFinalResult);
    /* ַΪ0ʱ˵Ϊ0 */
    if ('0' == szFinalResult[0])
    {
        nLen = 1;
    }
    (void)strncpy_s(outputResult, nLen + 1, szFinalResult, nLen);
    outputResult[nLen] = '\0';

    return SUCC;
}

/*****************************************************************************
 Function   : unitTransfer()
 Description: λתֽںKBתΪMBʹõǽλ
 Input      : sourceStr      ΣֽڴС/KBС
              level          Σλı
 Output     : targetStr      Σڴ洢
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 *****************************************************************************/
int unitTransfer(char *sourceStr, unsigned long level, char *targetStr)
{
    char *pszFirstNum = sourceStr;
    char szResult[MAX_STR_LEN] = {0};
    unsigned long nCycle = level;
    int nNumLen;
    unsigned long tmpNum = 0;
    /* ̳ʼΪ0 */
    int divide = 0;
    /* ʼΪ0 */
    unsigned long remainder = 0;
    int nLen;
    int i;
    /* ̵ַ± */
    int j = 0;

    /* жַǷΪNULL߳Ϊ0򷵻ش */
    if (NULL == pszFirstNum || NULL == targetStr || 0 == nCycle)
    {
        return ERROR;
    }

    nNumLen = strlen(pszFirstNum);

    /* ѭȡÿһλ */
    for (i = 0; i < nNumLen; i++)
    {
        /* λȡֵַ */
        tmpNum = remainder * 10 + (pszFirstNum[i] - 48);
        /* жʱֵǷڳ̵ַǷΪգСΪգʱֵַ */
        if(tmpNum < nCycle && 0 == strlen(szResult))
        {
            remainder = tmpNum;
        }
        else
        {
            /* ʱݴڳʼʽļ㣬̵ʱݳԳʱģ */
            divide = tmpNum / nCycle;
            remainder = tmpNum % nCycle;
            /* ̸ֵӦĽ */
            *(szResult + j) = divide + 48;
            j++;
        }
    }
    /* ַȫȡϣûдڳ򽫽Ϊ0 */
    if(0 == j)
    {
        *(szResult + j) = divide + 48;
    }
    /* ִ֮Ϊ0λ(+1) */
    if (0 != remainder)
    {
        (void)strAdd(szResult, "1", szResult);
    }

    /* սַƸ */
    nLen = strlen(szResult);
    if (MAX_STR_LEN <= nLen)
    {
        nLen = MAX_STR_LEN - 1;
    }
    (void)strncpy_s(targetStr, nLen + 1, szResult, nLen);
    targetStr[nLen] = '\0';

    return SUCC;
}

/*****************************************************************************
 Function   : openPipe()
 Description: popenзװUT
 Input      : command        popenΣҪִе
 Output     : type           popenΣģʽ
 Return     : FILE*          ļָ
 Other      : N/A
 *****************************************************************************/
FILE *openPipe(const char *pszCommand, const char *pszType)
{
    return popen(pszCommand, pszType);
}

/*****************************************************************************
 Function   : openFile()
 Description: fopenзװUT
 Input      : filepath       fopenΣļ·
 Output     : type           fopenΣģʽ
 Return     : FILE*          ļָ
 Other      : N/A
 *****************************************************************************/
FILE *openFile(const char *pszFilePath, const char *pszType)
{
    return fopen(pszFilePath, pszType);
}

/*****************************************************************************
 Function   : getDeviceMapperNumber()
 Description: Device-Mapper͵豸
 Input      : N/A
 Output     : N/A
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 *****************************************************************************/
int getDeviceMapperNumber()
{
    FILE *fpDevices;
    char szLine[MAX_STR_LEN] = {0};
    const char *pszDeviceMapperName = "device-mapper";
    char szMajor[MAX_NAME_LEN] = {0};
    char szDeviceType[MAX_STR_LEN] = {0};

    /* /proc/devicesļ */
    fpDevices = openFile(PROC_DEVICES, "r");
    if (NULL == fpDevices)
    {
        return ERROR;
    }

    while (fgets(szLine, sizeof(szLine), fpDevices))
    {
        /* ȡ豸ͺͶӦ豸 */
        if (sscanf_s(szLine, "%s %[^\n ]", szMajor, sizeof(szMajor), szDeviceType, sizeof(szDeviceType)) != 2)
        {
            continue;
        }
        /* ȶǷΪdevice-mapper߼ */
        if (0 == strcmp(szDeviceType, pszDeviceMapperName))
        {
            g_deviceMapperNum = atoi(szMajor);
            break;
        }
    }
    (void)fclose(fpDevices);
    //lint -save -e438
    fpDevices = NULL;

    return SUCC;
    //lint -save -e438
}

/*****************************************************************************
 Function   : freePath()
 Description: ͷָ뵽Ŀռ
 Input      : char *path1
              char *path2
              char *path3
 Output     : N/A
 Return     : void
 Other      : N/A
 *****************************************************************************/
void freePath(char *path1, char *path2, char *path3)
{
    if (path1 != NULL)
    {
        free(path1);
    }

    if (path2 != NULL)
    {
        free(path2);
    }

    if (path3 != NULL)
    {
        free(path3);
    }
}

/*****************************************************************************
 Function   : startsWith()
 Description: жַstrǷַprefixʼ
 Input      : str           
              prefix        
 Output     : N/A
 Return     : 1:    ַstrַprefixʼ
              0:    ַstrַprefixʼ
 Other      : N/A
 History    : 2013.09.02, h00227765 created this function.
 *****************************************************************************/
static int startsWith(const char *str, const char *prefix)
{
    return strncmp(str, prefix, strlen(prefix)) == 0;
}

/*****************************************************************************
 Function   : getScsiBackendPath()
 Description: öӦxenstore scsi豸·
 Input      : struct xs_handle* handle      handle of xenstore
              dir                           ǰxenstoreĿ¼
 Output     : N/A
 Return     : NULL = success, NULL = failure
 Other      : N/A
 History    : 2013.09.02, h00227765 created this function.
 *****************************************************************************/
static char* getScsiBackendPath(struct xs_handle *handle, char *dir)
{
    char    szXsPath[MAX_STR_LEN];
    int     ret;

    /* 磺ȡdevice/vscsi/2048/backendúxenstore· */
    ret = snprintf_s(szXsPath, sizeof(szXsPath), sizeof(szXsPath), "%s/%s/%s", SCSI_DISK_PATH, dir, "backend");
    if (ret < 0)
    {
        return NULL;
    }

    return read_from_xenstore(handle, szXsPath);
}

/*****************************************************************************
 Function   : getScsiBackendParams()
 Description: öӦxenstore scsi豸·params
 Input      : struct xs_handle* handle      handle of xenstore
              bePath                        xenstore·
 Output     : N/A
 Return     : NULL = success, NULL = failure
 Other      : N/A
 History    : 2013.09.02, h00227765 created this function.
 *****************************************************************************/
static char* getScsiBackendParams(struct xs_handle *handle, char *bePath)
{
    char    szXsPath[MAX_STR_LEN];
    int     ret;

    /* 磺ȡ˼ֵ/local/domain/0/backend/vbd/%d/2048/paramsȡ豸id */
    ret = snprintf_s(szXsPath, sizeof(szXsPath), sizeof(szXsPath), "%s/%s", bePath,  "params");
    if (ret < 0)
    {
        return NULL;
    }

    return read_from_xenstore(handle, szXsPath);
}

/*****************************************************************************
 Function   : getScsiBackendName()
 Description: öӦxenstore scsi豸·豸XML豸
 Input      : struct xs_handle* handle      handle of xenstore
              bePath                        xenstore·
 Output     : N/A
 Return     : NULL = success, NULL = failure
 Other      : N/A
 History    : 2013.09.02, h00227765 created this function.
 *****************************************************************************/
static char* getScsiBackendName(struct xs_handle *handle, char *bePath)
{
    char    szXsPath[MAX_STR_LEN];
    int     ret;

    /* 磺ȡ˼ֵ/local/domain/0/backend/vbd/%d/2048/devȡxml豸 */
    ret = snprintf_s(szXsPath, sizeof(szXsPath), sizeof(szXsPath), "%s/%s", bePath, "dev");
    if (ret < 0)
    {
        return NULL;
    }

    return read_from_xenstore(handle, szXsPath);
}

/*****************************************************************************
 Function   : getScsiDiskXmlName()
 Description: ͨxenstore豸, scsi豸xmlе豸
 Input      : struct xs_handle *handle      handle of xenstore
              char *d_name                  豸sda
 Output     : N/A
 Return     : NULL = success, NULL = failure
 Other      : N/A
 *****************************************************************************/
static char* getScsiDiskXmlName(struct xs_handle *handle, const char *d_name)
{
    unsigned int    i;
    unsigned int    num;
    char            **xs_dir;
    char            *fptr;
    char            *bePath = NULL;
    char            *params = NULL;
    char            *devname = NULL;

    /* ȡscsi豸żscsi̸ */
    xs_dir = xs_directory(handle, 0, SCSI_DISK_PATH, &num);
    if (xs_dir == NULL)
    {
        return NULL;
    }

    for (i = 0; i < num; i++)
    {
        /* 磺ȡdevice/vscsi/2048/backendúxenstore· */
        bePath = getScsiBackendPath(handle, xs_dir[i]);
        if (bePath == NULL)
        {
            free(xs_dir);
            return NULL;
        }

        /* 磺ȡ˼ֵ/local/domain/0/backend/vbd/%d/2048/paramsȡ豸id */
        params = getScsiBackendParams(handle, bePath);
        if (params == NULL)
        {
            free(xs_dir);
            freePath(bePath, NULL, NULL);
            return NULL;
        }

        /* 磺ȡ˼ֵ/local/domain/0/backend/vbd/%d/2048/devȡxml豸 */
        fptr = params + strlen(DEVPATH);
        if (0 == strcmp(fptr, d_name))
        {
            devname = getScsiBackendName(handle, bePath);

            free(xs_dir);
            freePath(bePath, params, NULL);
            return devname;
        }

        freePath(bePath, params, devname);
    }

    free(xs_dir);
    return NULL;
}

/*****************************************************************************
 Function   : isCorrectDev()
 Description: /dev/disk/by-idµļǷҪҵ豸
 Input      : ptName                ҵ豸
              entry                 /dev/disk/by-idµһļ
 Output     : N/A
 Return     : 1:                    Ǵҵ豸
              0:                    Ǵҵ豸
 Other      : N/A
 History    : 2013.09.02, h00227765 created this function.
 *****************************************************************************/
static int isCorrectDev(const char *ptName, struct dirent *entry)
{
    char    fullPath[MAX_STR_LEN];
    char    actualPath[MAX_STR_LEN];
    ssize_t len;

    /* Ŀ¼Ϊ"...wwn-" */
    if (startsWith(entry->d_name, ".") ||
        startsWith(entry->d_name, "..") ||
        startsWith(entry->d_name, "wwn-"))
    {
        return 0;
    }

    snprintf_s(fullPath, sizeof(fullPath), sizeof(fullPath), "%s%s", DEVPATH, entry->d_name);
    /*
     * ȡidӣԵõ"../../sda"
     * readlink() does not append a null byte to buf.
     */
    len = readlink(fullPath, actualPath, sizeof(actualPath) - 1);
    if (-1 == len)
    {
        return 0;
    }
    actualPath[len] = '\0'; /* On success, readlink() returns the number of bytes placed in buf. */

    /* ǰ"../../"ôַ(sda)бȽsda */
    if (0 != strcmp(ptName, actualPath + strlen(CMPSTRING)))
    {
        return 0;
    }

    return 1;
}

/*****************************************************************************
 Function   : getXmlDevName()
 Description: scsiȡXML豸
 Input      : handle                handle of xenstore
              ptName                XML豸ڷ
 Output     : N/A
 Return     : XML豸Ҫͷ
              NULL = success, NULL = failure
 Other      : N/A
 History    : 2013.09.02, h00227765 created this function.
 *****************************************************************************/
static char* getXmlDevName(struct xs_handle *handle, const char *ptName)
{
    char            *xmlDevName = NULL;
    DIR             *dir;
    struct dirent   entry;
    struct dirent   *result = NULL;
    int             ret;

    dir = opendir(DEVPATH);
    if (NULL == dir)
    {
        return NULL;
    }

    /* /dev/disk/by-idĿ¼µļ */
    for (ret = readdir_r(dir, &entry, &result); (ret == 0) && (result != NULL); ret = readdir_r(dir, &entry, &result))
    {
        if (isCorrectDev(ptName, &entry))
        {
            xmlDevName = getScsiDiskXmlName(handle, entry.d_name);
            if (xmlDevName)
                break;
        }
    }

    (void)closedir(dir);
    return xmlDevName;
}

/*****************************************************************************
 Function   : getPartitionsInfo()
 Description: ȡ/proc/partition豸Լ豸Ϣ
 Input      : struct xs_handle* handle   handle of xenstore
 Output     : struct DevMajorMinor* devMajorMinor    豸Ƽ豸ŵĽṹ
              int* pnPartNum                         
              struct DeviceInfo* diskUsage           Ƽʹÿռ䡢ܿռĽṹ
              int* pnDiskNum                         
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 *****************************************************************************/
int getPartitionsInfo(struct xs_handle *handle,
                             struct DevMajorMinor *devMajorMinor,
                             int *pnPartNum,
                             struct DeviceInfo *diskUsage,
                             int *pnDiskNum)
{
    FILE    *fpProcPt;
    char    szLine[MAX_STR_LEN];
    char    szPtName[MAX_NAME_LEN];
    int     nMajor = 0;
    int     nMinor = 0;
    char    szSize[MAX_STR_LEN];
    int     nPartitionNum = 0;
    int     nDiskNum = 0;
    int     nPtNameLen;
    char    *xmlDevName;
    struct DevMajorMinor    *tmpDev = NULL;
    struct DeviceInfo       *tmpUsage = NULL;

    /* /proc/partitionsļ */
    fpProcPt = openFile(PROC_PARTITIONS, "r");
    if (NULL == fpProcPt)
    {
        return ERROR;
    }

    /* ѭȡÿһеϢ */
    while (fgets(szLine, sizeof(szLine), fpProcPt))
    {
        /* ʽȡӦ */
        if (sscanf_s(szLine, " %d %d %s %[^\n ]", &nMajor, &nMinor, szSize, sizeof(szSize), szPtName, sizeof(szPtName)) != 4)
        {
            continue;
        }
        /* loopramdm豸Ϣ */
        if (LOOP_MAJOR == nMajor || RAM_MAJOR == nMajor)
        {
            continue;
        }
        /* ȫݣҵdmsetup豸ʱҪѰҶӦ豸 */
        tmpDev = devMajorMinor + nPartitionNum;
        tmpDev->devMajor = nMajor;
        tmpDev->devMinor = nMinor;

        szSize[MAX_STR_LEN - 1] = '\0';
        szPtName[MAX_NAME_LEN - 1] = '\0';
        (void)strncpy_s(tmpDev->devBlockSize, MAX_STR_LEN, szSize, strlen(szSize));
        (void)strncpy_s(tmpDev->devName, MAX_NAME_LEN, szPtName, strlen(szPtName));
        nPartitionNum++;
        /* ĿǰUVPֹ֧xvd*hd*sd*͵豸 */
        if ('h' != szPtName[0] && 's' != szPtName[0] && 'x' != szPtName[0])
        {
            continue;
        }

        /* ĿǰUVPֹ֧شֵ豸ͣԻȡszPtNameеһַ鿴ǷΪ֣ǣ˵Ǵ*/
        nPtNameLen = strlen(szPtName);
        if (szPtName[nPtNameLen - 1] >= '0' && szPtName[nPtNameLen - 1] <= '9')
        {
            continue;
        }

        tmpUsage = diskUsage + nDiskNum;

        /*
         * ϢݴϢĽṹС
         * scsi豸޸Ϊxmlļ豸(target dev)scsi豸ڲʾΪ׼
         */
        if ( 's' == szPtName[0])
        {
            xmlDevName = getXmlDevName(handle, szPtName);
            if (NULL == xmlDevName)
            {
                continue;
            }
            (void)strncpy_s(tmpUsage->phyDevName, sizeof(tmpUsage->phyDevName), xmlDevName, sizeof(tmpUsage->phyDevName)-1);
            free(xmlDevName);
        }
        else
        {
            (void)strncpy_s(tmpUsage->phyDevName, sizeof(tmpUsage->phyDevName), szPtName, sizeof(tmpUsage->phyDevName)-1);
        }
        tmpUsage->phyDevName[MAX_NAME_LEN - 1] = '\0';

        /* ʼʹϢΪ0 */
        (void)strncpy_s(tmpUsage->diskUsage, MAX_DISKUSAGE_LEN, "0", 2);
        (void)unitTransfer(szSize, UNIT_TRANSFER_CYCLE, tmpUsage->deviceTotalSpace);
        nDiskNum++;
    }

    *pnPartNum = nPartitionNum;
    *pnDiskNum = nDiskNum;

    (void)fclose(fpProcPt);
    return SUCC;
}

/*****************************************************************************
 Function   : getSwapInfo()
 Description: ȡswapļϵͳԼӦĿռС
 Input      : N/A
 Output     : struct DiskInfo* diskMap           swapϢʹÿռ
              int* pnMountNum                    swap
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 *****************************************************************************/
int getSwapInfo(struct DiskInfo *diskMap, int *pnMountNum)
{
    FILE *fpProcSwap;
    int nFsSize = 0;
    int nSwapPartitionNum = *pnMountNum;
    char szLine[MAX_STR_LEN] = {0};
    char szSwapName[MAX_STR_LEN] = {0};
    struct DiskInfo *tmpDisk = NULL;

    /* /proc/swapsļ */
    fpProcSwap = openFile(PROC_SWAPS, "r");
    if (NULL == fpProcSwap)
    {
        return ERROR;
    }
    /* diskMapswapϢ */
    while (fgets(szLine, sizeof(szLine), fpProcSwap))
    {
        if (sscanf_s(szLine, "%s %*s %d %*[^\n ]", szSwapName, sizeof(szSwapName), &nFsSize) != 2)
        {
            continue;
        }
        tmpDisk = diskMap + nSwapPartitionNum;

        szSwapName[MAX_STR_LEN - 1] = '\0';
        (void)strncpy_s(tmpDisk->filesystem, MAX_STR_LEN, szSwapName, strlen(szSwapName));
        (void)snprintf_s(tmpDisk->usage, sizeof(tmpDisk->usage), sizeof(tmpDisk->usage), "%d", nFsSize / UNIT_TRANSFER_CYCLE);
        nSwapPartitionNum++;
    }
    *pnMountNum = nSwapPartitionNum;
    (void)fclose(fpProcSwap);
    //lint -save -e438
    fpProcSwap = NULL;

    return SUCC;
    //lint -restore
}

/*****************************************************************************
 Function   : getDrbdParent()
 Description: drbd豸ȡӦĸڵ
 Input      : char* drbdName                     drbd豸
 Output     : char* parentName                   ڵ
 Return     : 0
 Other      : N/A
 *****************************************************************************/
int getDrbdParent(char *drbdName, char *parentName)
{
    char szCmd[MAX_STR_LEN] = {0};
    FILE *fpDmCmd;
    char szLine[MAX_STR_LEN] = {0};
    char tmpParentName[MAX_NAME_LEN] = {0};

    /* ݵǰdrbd豸drbdsetupȡ豸 */
    (void)snprintf_s(szCmd, sizeof(szCmd), sizeof(szCmd), "drbdsetup %s show |grep /dev", drbdName);
    fpDmCmd = openPipe(szCmd, "r");
    if (NULL == fpDmCmd)
    {
        return 0;
    }

    /* ȡִнļָ */
    if (NULL != fgets(szLine, sizeof(szLine), fpDmCmd))
    {
        /* drbdsetupȡ豸 */
        if (sscanf_s(szLine, "%*[^\"]\"%[^\"]", tmpParentName, sizeof(tmpParentName)) != 1)
        {
            (void)pclose(fpDmCmd);
            return 0;
        }
    }

    (void)pclose(fpDmCmd);
    //lint -save -e438
    fpDmCmd = NULL;
    //lint -restore
    memset_s(parentName, strlen(parentName), 0, strlen(parentName));
    (void)strncpy_s(parentName, strlen(parentName) + 1, tmpParentName, strlen(tmpParentName));

    return 0;
}

/*****************************************************************************
 Function   : getMountInfo()
 Description: ȡ/proc/mountsʵļϵͳԼصӦϢ(ȥظtmp)
 Input      : N/A
 Output     : struct DiskInfo mountInfo[]     صӦļϵͳϢʹÿռĽṹ
              int* pnMountNum                 صӦļϵͳϢĸ
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 *****************************************************************************/
int getMountInfo(struct DiskInfo *mountInfo, int *pnMountNum)
{
    FILE *fpProcMount;
    char szLine[MAX_STR_LEN] = {0};
    struct DiskInfo *tmpMountInfo;
    struct DiskInfo *firstInfo = NULL;
    struct DiskInfo *secondInfo = NULL;
    char szFilesystemName[MAX_NAME_LEN] = {0};
    char szMountPointName[MAX_STR_LEN] = {0};
    char szMountType[MAX_STR_LEN] = {0};
    int nTmpMountNum = *pnMountNum;
    int nMountNum = 0;
    int nFlag = 0;
    /* жϹصǷΪĿ¼־λ */
    int nIsGetOneInfo = 0;
    int i;
    int j = 0;

    tmpMountInfo = (struct DiskInfo *)malloc(MAX_STR_LEN * sizeof(struct DiskInfo));
    if (NULL == tmpMountInfo)
    {
        return ERROR;
    }
    memset_s(tmpMountInfo, MAX_STR_LEN * sizeof(struct DiskInfo), 0, MAX_STR_LEN * sizeof(struct DiskInfo));

    /* /proc/mountsļ */
    fpProcMount = openFile(PROC_MOUNTS, "r");
    if (NULL == fpProcMount)
    {
        free(tmpMountInfo);
        //lint -save -e438
        tmpMountInfo = NULL;
        return ERROR;
        //lint -restore
    }

    for (i = 0; i < nTmpMountNum; i++)
    {
        firstInfo = tmpMountInfo + i;
        secondInfo = mountInfo + i;
        (void)strncpy_s(firstInfo->filesystem, MAX_STR_LEN, secondInfo->filesystem, strlen(secondInfo->filesystem));
    }

    /* ѭȡÿһ */
    while (fgets(szLine, sizeof(szLine), fpProcMount))
    {
        /* ʽȡӦҪ */
        if (sscanf_s(szLine, "%s %s %s %*[^\n ]", 
                    szFilesystemName, sizeof(szFilesystemName), 
                    szMountPointName, sizeof(szMountPointName),
                    szMountType, sizeof(szMountType)) != 3)
        {
            continue;
        }

        /* ȥ/dev/ͷļϵͳtmpfsȣȥloop豸ȥظص/Ŀ¼ĺ漸ļϵͳ
         * ȥcdromĹص㣬صĹramfsiso9660
         */
        if (0 != strncmp(szFilesystemName, "/dev/", 5) || 0 == strncmp(szFilesystemName, "/dev/loop", 9)
                || (1 == nIsGetOneInfo && 0 == strcmp(szMountPointName, "/"))
                || 5 == strspn(szMountType , "ramfs") || 7 == strspn(szMountType , "iso9660"))
        {
            continue;
        }

        /* ص㱻ظ */
        for (i = 0; i < nTmpMountNum; i++)
        {
            firstInfo = tmpMountInfo + i;
            /* ѯtmpMountInfoǷڸùصӦϢѾڣtmpMountInfoиùصӦϢ */
            if (0 == strcmp(szMountPointName, firstInfo->mountPoint))
            {
                memset_s(firstInfo->filesystem, MAX_STR_LEN, 0, strlen(firstInfo->filesystem));
                (void)strncpy_s(firstInfo->filesystem, MAX_STR_LEN, szFilesystemName, strlen(szFilesystemName));
                nFlag = 1;
                break;
            }
        }
        if (0 == nFlag)
        {
            firstInfo = tmpMountInfo + nTmpMountNum;
            /* жͨ˵ϢΪҪӵһ¼¼ӵӦṹУݼۼ */
            strncpy_s(firstInfo->filesystem, MAX_STR_LEN, szFilesystemName, strlen(szFilesystemName));
            strncpy_s(firstInfo->mountPoint, MAX_STR_LEN, szMountPointName, strlen(szMountPointName));
            nTmpMountNum++;
        }
        nFlag = 0;
        nIsGetOneInfo = 1;
    }

    /* ļϵͳظ */
    for (i = 0; i < nTmpMountNum; i++)
    {
        firstInfo = tmpMountInfo + i;

        for (j = 0; j < nMountNum; j++)
        {
            /* ѯmountInfoǷڸļϵͳӦϢѾڣӸ¼ */
            if (0 == strcmp(firstInfo->filesystem, (mountInfo + j)->filesystem))
            {
                nFlag = 1;
                break;
            }
        }
        if (1 == nFlag)
        {
            nFlag = 0;
            continue;
        }
        secondInfo = mountInfo + nMountNum;
        /* mountInfoûиļϵͳӦϢһ¼¼ݼۼ */
        strncpy_s(secondInfo->filesystem, MAX_STR_LEN, firstInfo->filesystem, strlen(firstInfo->filesystem));
        strncpy_s(secondInfo->mountPoint, MAX_STR_LEN, firstInfo->mountPoint, strlen(firstInfo->mountPoint));
        nMountNum++;
    }

    *pnMountNum = nMountNum;
    (void)fclose(fpProcMount);
    //lint -save -e438
    fpProcMount = NULL;

    free(tmpMountInfo);
    tmpMountInfo = NULL;

    return SUCC;
    //lint -restore
}

/*****************************************************************************
 Function   : getInfoFromID()
 Description: 豸豸ţȡӦ豸֣Լ豸С
 Input      : struct DevMajorMinor* devMajorMinor    豸Ƽ豸Žṹ
              int partNum                            
              int devID                              豸豸
 Output     : char* devName                          ڵ
              char* devBlockSize                     ڵռС
 Return     : 0
 Other      : N/A
 *****************************************************************************/
int getInfoFromID(struct DevMajorMinor *devMajorMinor, int partNum, int devID, char *devName, char *devBlockSize)
{
    int i;
    char szDevName[MAX_STR_LEN] = {0};
    char szBlockSize[MAX_STR_LEN] = {0};
    int nMajor = major(devID);
    int nMinor = minor(devID);
    struct DevMajorMinor *tmpDev = NULL;

    for(i = 0; i < partNum; i++)
    {
        tmpDev = devMajorMinor + i;
        /* 豸Ŷ/proc/partitionsһ˵ͬһ豸豸ݸ */
        if (nMajor == tmpDev->devMajor && nMinor == tmpDev->devMinor)
        {
            (void)strncpy_s(szDevName, MAX_STR_LEN, tmpDev->devName, strlen(tmpDev->devName));
            (void)strncpy_s(szBlockSize, MAX_STR_LEN, tmpDev->devBlockSize, strlen(tmpDev->devBlockSize));
            /* devNameΪNULL豸ŶӦ豸ݸ */
            if (NULL != devName && 0 != strlen(szDevName))
            {
                (void)strncpy_s(devName, strlen(szDevName)+1, szDevName, strlen(szDevName));
            }
            /* devBlockSizeΪNULL豸ŶӦ豸ʵʿռСݸ */
            if (NULL != devBlockSize && 0 != strlen(szBlockSize))
            {
                (void)strncpy_s(devBlockSize, strlen(szBlockSize)+1, szBlockSize, strlen(szBlockSize));
            }
            break;
        }
    }

    return 0;
}

/*****************************************************************************
 Function   : getDiskInfo()
 Description: ȡdfжӦϢ洢ṹ
 Input      : struct DevMajorMinor* devMajorMinor     豸Ƽ豸Žṹ
              int partNum                             
 Output     : struct DiskInfo* diskMap                صӦļϵͳϢʹÿռĽṹ
              int* pnMountNum                         ڴ洢ش
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 *****************************************************************************/
int getDiskInfo(struct DevMajorMinor *devMajorMinor, int partNum, struct DiskInfo *diskMap, int *pnMountNum)
{
    /* ֮ǰڵúУȻȡswapȽswapֵص */
    int nMountedFsNum = *pnMountNum;
    int nResult;
    struct statfs statfsInfo;
    struct stat statBuf;
    char szFreeSize[MAX_STR_LEN] = {0};
    char szFsFreeBlock[MAX_STR_LEN] = {0};
    char szFsBlockSize[MAX_STR_LEN] = {0};
    char szFsSize[MAX_STR_LEN] = {0};
    int i;
    struct DiskInfo *tmpDisk = NULL;
    char *substr = NULL;
    char tmp_mountPoint[MAX_STR_LEN] = {0};
    int offset = 0;
    int len = 0;

    /* getMountInfoȡصļϵͳϢ(swap֮ۼ) */
    nResult = getMountInfo(diskMap, &nMountedFsNum);
    if (ERROR == nResult)
    {
        return ERROR;
    }

    /* ѭļϵͳϢ */
    for (i = 0; i < nMountedFsNum; i++)
    {
        tmpDisk = diskMap + i;
        /* ͨstatȡļϵͳӦ豸Ϣ浽ṹӦԱ */
        nResult = stat(tmpDisk->filesystem, &statBuf);
        if (0 != nResult || 0 == statBuf.st_rdev)
        {
            continue;
        }

        /* swapʱͨصȡʹϢ */
        if (*pnMountNum <= i)
        {
            /* ͨstatfsļϵͳص㣬ȡļϵͳϢ */
            if (statfs(tmpDisk->mountPoint, &statfsInfo) != 0)
            {
                if (ENOENT != errno)
                {
                    return ERROR;
                }
                /* should retry, such as redhat-6.1 at GUI mode, USB DISK shown as /media/STEC\040DISK, need to replace \040 with ' '*/
                substr = strstr(tmpDisk->mountPoint, "\\040");
                if (!substr)
                {
                    return ERROR;
                }

                (void)memset_s(tmp_mountPoint, MAX_STR_LEN, 0 ,MAX_STR_LEN);
                offset = substr - tmpDisk->mountPoint;
                len = offset + strlen("\\040");

                (void)memcpy_s(tmp_mountPoint, MAX_STR_LEN, tmpDisk->mountPoint, offset);
                (void)memset_s(tmp_mountPoint + offset, MAX_STR_LEN - strlen("\\040"), '\040', 1);
                (void)memcpy_s(tmp_mountPoint + offset + 1 , MAX_STR_LEN - offset - 1, tmpDisk->mountPoint + len, strlen(tmpDisk->mountPoint) - len);

                if (statfs(tmp_mountPoint, &statfsInfo) != 0)
                {
                    return ERROR;
                }
            }
            /* ܿ0mountϢǿգصϢļִָ² */
            if (statfsInfo.f_blocks > 0)
            {
                /* ÿĴСֵszFsBlockSizeļϵͳֵṹĶӦԱ */
                (void)snprintf_s(szFsBlockSize, sizeof(szFsBlockSize), sizeof(szFsBlockSize), "%ld", (long)statfsInfo.f_bsize);
                /* ʣfreeĿСֵӦı */
                (void)snprintf_s(szFsFreeBlock, sizeof(szFsFreeBlock), sizeof(szFsFreeBlock), "%lu", statfsInfo.f_bfree);
                /* ʹַ˷ʣСм㣬תΪKB */
                (void)strMulti(szFsFreeBlock, szFsBlockSize, szFreeSize);
                (void)unitTransfer(szFreeSize, UNIT_TRANSFER_CYCLE, szFreeSize);
            }
        }

        tmpDisk->st_rdev = statBuf.st_rdev;
        /* ͨgetInfoFromIDļϵͳ豸ţȡӦʵʿռСϢ */
        (void)getInfoFromID(devMajorMinor, partNum, statBuf.st_rdev, NULL, szFsSize);
        /* ȡļϵͳʵʿռȥļϵͳʣÿռ䣬ļϵͳʹÿռ(Ϊ˼ļϵͳʽռÿռ) */
        nResult = strMinus(szFsSize, szFreeSize, tmpDisk->usage);
        if (ERROR == nResult)
        {
            return ERROR;
        }
        /* еλת󣬴ṹӦԱ */
        nResult = unitTransfer(tmpDisk->usage, UNIT_TRANSFER_CYCLE, tmpDisk->usage);
        if (ERROR == nResult)
        {
            return ERROR;
        }

        /* һЩʱַϢȫ */
        memset_s(szFsBlockSize, MAX_STR_LEN, 0, sizeof(szFsBlockSize));
        memset_s(szFreeSize, MAX_STR_LEN, 0, sizeof(szFreeSize));
        memset_s(szFsFreeBlock, MAX_STR_LEN, 0, sizeof(szFsFreeBlock));
        memset_s(szFsSize, MAX_STR_LEN, 0, sizeof(szFsSize));
    }
    *pnMountNum = nMountedFsNum;

    return SUCC;
}

/*****************************************************************************
 Function   : getDiskNameFromPartName()
 Description: ѷеĸַֿĸΪ
 Input       : char *pPartName    
 Output     : char* pDiskName   ڵĴ
 Return     : SUCC = success, ERROR = failure
 Other      :  LVMPV ΪʱpPartNamepDiskName
 *****************************************************************************/
int getDiskNameFromPartName(const char *pPartName, char *pDiskName)
{
    int i = 0;
    int j = 0;

    if (NULL == pPartName || 0 == strlen(pPartName) || NULL == pDiskName)
    {
        return ERROR;
    }

    while(*(pPartName + i) != '\0')
    {
        if(*(pPartName + i) <= 'z' && *(pPartName + i) >= 'A')
        {
            pDiskName[j] = *(pPartName + i);
            j++;
        }
        i++;
    }

    if(0 == i)
    {
        return ERROR;
    }
    else
    {
        return SUCC;
    }
}

/*****************************************************************************
 Function   : getDmParentNode()
 Description: ļϵͳ豸ţȡļϵͳĸڵ
 Input      : struct DevMajorMinor* devMajorMinor       /proc/partitions豸豸Žṹ
              int partNum                               Ӧϵ
              int devID                                 ļϵͳ豸
 Output     : char* parentName                          ڵ
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 *****************************************************************************/
int getDmParentNode(struct DevMajorMinor *devMajorMinor, int partNum, int devID, char *parentName)
{
    char szCmd[MAX_STR_LEN] = {0};
    int nParentMajor = 0;
    int nParentMinor = 0;
    FILE *fpDmCmd;
    char szLine[MAX_STR_LEN] = {0};
    char szRealName[MAX_NAME_LEN] = {0};
    int nParentDevID = 0;
    /* 洢߼豸 */
    int nCount = 0;
    int nFlag = 0;

    char szDiskName[MAX_PARTNAME_LEN] = {0};
    char szDiskNameTmp[MAX_PARTNAME_LEN] = {0};

    /* ݵǰ߼豸ţdmsetupȡ豸豸 */
    (void)snprintf_s(szCmd, sizeof(szCmd), sizeof(szCmd), "dmsetup table -j %d -m %d", major(devID), minor(devID));
    fpDmCmd = openPipe(szCmd, "r");
    if (NULL == fpDmCmd)
    {
        return ERROR;
    }

    /* ѭȡִнļָ */
    while (fgets(szLine, sizeof(szLine), fpDmCmd))
    {
        /* dmsetupȡ豸豸 */
        if (sscanf_s(szLine, "%*d %*d %*s %d:%d %*[^\n ]", &nParentMajor, &nParentMinor) != 2)
         {
             if(sscanf_s(szLine, "%*d %*d %*s %*s %*s %*d %d:%d %*[^\n ]", &nParentMajor, &nParentMinor) != 2)
             {
                 nFlag = ERROR;
                 break;
             }
         }

        /* ߼豸߼ֱӷERROR(߼ϴ߼) */
        if (g_deviceMapperNum == nParentMajor)
        {
            nFlag = ERROR;
            break;
        }
        nParentDevID = makedev(nParentMajor, nParentMinor);
        memset_s(szRealName, MAX_NAME_LEN, 0, MAX_NAME_LEN);
        memset_s(szDiskName, MAX_PARTNAME_LEN, 0, MAX_PARTNAME_LEN);
        (void)getInfoFromID(devMajorMinor, partNum, nParentDevID, szRealName, NULL);
        if(ERROR == getDiskNameFromPartName(szRealName, szDiskName))
        {
            nFlag = ERROR;
            break;
        }
        if(0 == nCount)
        {
            memset_s(szDiskNameTmp, MAX_PARTNAME_LEN, 0, MAX_PARTNAME_LEN);
            (void)strncpy_s(szDiskNameTmp, MAX_PARTNAME_LEN, szDiskName, strlen(szDiskName));
        }
        else
        {
            /*szDiskNameTmp  szDiskNameȣ˵LVM˶*/
            if (0 != strcmp(szDiskNameTmp, szDiskName))
            {
                nFlag = UNKNOWN;
                break;
            }
            memset_s(szDiskNameTmp, MAX_PARTNAME_LEN, 0, MAX_PARTNAME_LEN);
            (void)strncpy_s(szDiskNameTmp, MAX_PARTNAME_LEN, szDiskName, strlen(szDiskName));
        }
        nCount++;
    }
    (void)pclose(fpDmCmd);
    //lint -save -e438
    fpDmCmd = NULL;
    //lint -restore

    if (ERROR == nFlag)
    {
        return ERROR;
    }

    /* ȡĸ豸ݸ */
    (void)strncpy_s(parentName, strlen(szRealName)+1, szRealName, strlen(szRealName));

    return SUCC;
}

/*****************************************************************************
 Function   : addDiskUsageToDevice()
 Description: ݷʵ֣Աȴ̣Ϣһ£ۼʹÿռϢӦ
 Input      : struct DeviceInfo* linuxDiskUsage       Ƽʹÿռ䡢ܿռĽṹ
              int diskNum                             
              char* partitionsName                    ڱȶǷһ
              char* partitionsUsage                   ʹϢۼӵ̿ռ
 Output     : struct DeviceInfo linuxDiskUsage
 Return     : 0
 Other      : N/A
 *****************************************************************************/
int addDiskUsageToDevice(struct DeviceInfo *linuxDiskUsage,
                         int diskNum,
                         const char *partitionsName,
                         char *partitionsUsage)
{
    char szTmpPartition[MAX_NAME_LEN] = {0};
    int i;
    int nPartNameLen = strlen(partitionsName);
    struct DeviceInfo *tmpUsage = NULL;

    for (i = 0; i < nPartNameLen; i++)
    {
        if (partitionsName[i] >= '0' && partitionsName[i] <= '9')
        {
            break;
        }
        szTmpPartition[i] = partitionsName[i];
    }

    for (i = 0; i < diskNum; i++)
    {
        tmpUsage = linuxDiskUsage + i;
        /* ͨԱȷ豸(ĩβ)Ƿһһ򽫷ʹϢۼӵʹÿռ */
        if (0 == strcmp(szTmpPartition, tmpUsage->phyDevName))
        {
            (void)strAdd(tmpUsage->diskUsage, partitionsUsage, tmpUsage->diskUsage);
            break;
        }
    }

    return 0;
}

/*****************************************************************************
 Function   : getAllDeviceUsage()
 Description: еķϢۼӵӦ̵ʹÿռ
 Input      : struct DevMajorMinor* devMajorMinor      豸豸Žṹ
              struct DeviceInfo* linuxDiskUsage        Ƽʹÿռ䡢ܿռĽṹ
              struct DiskInfo diskMap                  صӦļϵͳϢʹÿռĽṹ
              struct NumberCount numberCount           ԼصӦļϵͳϢĽṹ
 Output     : struct DeviceInfo* linuxDiskUsage        ̵ʹÿռȡ
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 *****************************************************************************/
int getAllDeviceUsage(struct DevMajorMinor *devMajorMinor, struct DeviceInfo *linuxDiskUsage,
                      struct DiskInfo *diskMap, struct NumberCount numberCount)
{
    char szParentName[MAX_NAME_LEN] = {0};
    int nResult = 0;
    int i;
    struct DiskInfo *tmpDisk = NULL;
    /* drbd豸Ӧĸ豸豸 */
    struct stat statBuf;

    for (i = 0; i < numberCount.mountNum; i++)
    {
        tmpDisk = diskMap + i;

        /* mount¼ļϵͳdrbd豸ʱҪҵӦĸ豸 */
        if (NULL != strstr(tmpDisk->filesystem, "drbd"))
        {
            (void)getDrbdParent(tmpDisk->filesystem, tmpDisk->filesystem);
            /* ͨstatȡdrbd豸Ӧĸ豸豸Ϣ浽ṹӦԱ */
            nResult = stat(tmpDisk->filesystem, &statBuf);
            if (0 != nResult || 0 == statBuf.st_rdev)
            {
                continue;
            }
            /* mount¼е豸 */
            tmpDisk->st_rdev = statBuf.st_rdev;
        }

        if (g_deviceMapperNum == major(tmpDisk->st_rdev))
        {
            /* ͨdmsetupȡ߼Ӧ豸 */
            nResult = getDmParentNode(devMajorMinor, numberCount.partNum, tmpDisk->st_rdev, szParentName);
            if (ERROR == nResult)
            {
                return ERROR;
            }
        }
        else
        {
            /* ߼ֱӽֵڵںͳһѰҸڵ */
            (void)getInfoFromID(devMajorMinor, numberCount.partNum, tmpDisk->st_rdev, szParentName, NULL);
        }

        /*
         * szParentNameĳȲΪ0˵mount¼µľѾҵ/proc/partitionsµĶӦ
         * Ϊ0˵mountļ¼ͳƴʵķΧڣм
         */
        if (0 != strlen(szParentName))
        {
            /* ͨaddDiskUsageToDeviceķʹÿռۼӵӦĴ */
            (void)addDiskUsageToDevice(linuxDiskUsage, numberCount.diskNum, szParentName, tmpDisk->usage);
            memset_s(szParentName, MAX_NAME_LEN, 0, sizeof(szParentName));
        }
    }

    return SUCC;
}

/*****************************************************************************
 Function   : freeSpace()
 Description: ͷṹ뵽Ŀռ
 Input      : N/A
 Output     : struct DevMajorMinor* devMajorMinor   豸豸Žṹ
            struct DeviceInfo* linuxDiskUsage     Ƽʹÿռ䡢ܿռĽṹ
            struct DiskInfo* diskMap              صӦļϵͳϢʹÿռĽṹ
 Return     : void
 Other      : N/A
 *****************************************************************************/
void freeSpace(struct DevMajorMinor *devMajorMinor, struct DeviceInfo *linuxDiskUsage, struct DiskInfo *diskMap)
{
    //lint -save -e438
    if (devMajorMinor != NULL)
    {
        free(devMajorMinor);
        devMajorMinor = NULL;
    }

    if (linuxDiskUsage != NULL)
    {
        free(linuxDiskUsage);
        linuxDiskUsage = NULL;
    }

    if (diskMap != NULL)
    {
        free(diskMap);
        diskMap = NULL;
    }
    //lint -restore
}

/*****************************************************************************
 Function   : getDiskUsage()
 Description: ô
 Input      : struct xs_handle* handle   handle of xenstore
 Output     : char* pszDiskUsage   洢ʵַ
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 *****************************************************************************/
int getDiskUsage(struct xs_handle *handle, char *pszDiskUsage)
{
    /* 洢ܴ̿ռϢַ(λΪMB) */
    char szTotalSize[MAX_DISKUSAGE_LEN] = {0};
    /* 洢ʹÿռϢַ(λΪMB) */
    char szTotalUsage[MAX_DISKUSAGE_LEN] = {0};
    /* 洢ÿϢӵַ */
    char szUsageString[MAX_DISKUSAGE_LEN] = {0};
    struct DevMajorMinor *devMajorMinor;
    struct DeviceInfo *linuxDiskUsage;
    struct DiskInfo *diskMap = NULL;
    struct NumberCount numberCount = {0};
    int nSwapNum;
    int nResult = 0;
    int i;

    devMajorMinor = (struct DevMajorMinor *)malloc(MAX_DISKUSAGE_LEN * sizeof(struct DevMajorMinor));
    if (NULL == devMajorMinor)
    {
        return ERROR;
    }
    memset_s(devMajorMinor, 
        MAX_DISKUSAGE_LEN * sizeof(struct DevMajorMinor), 
        0, 
        MAX_DISKUSAGE_LEN * sizeof(struct DevMajorMinor));

    linuxDiskUsage = (struct DeviceInfo *)malloc(MAX_DISK_NUMBER * sizeof(struct DeviceInfo));
    if (NULL == linuxDiskUsage)
    {
        freeSpace(devMajorMinor, linuxDiskUsage, diskMap);
        return ERROR;
    }
    memset_s(linuxDiskUsage, 
        MAX_DISK_NUMBER * sizeof(struct DeviceInfo),
        0, 
        MAX_DISK_NUMBER * sizeof(struct DeviceInfo));

    diskMap = (struct DiskInfo *)malloc(MAX_DISKUSAGE_LEN * sizeof(struct DiskInfo));
    if (NULL == diskMap)
    {
        freeSpace(devMajorMinor, linuxDiskUsage, diskMap);
        return ERROR;
    }
    memset_s(diskMap, 
        MAX_DISKUSAGE_LEN * sizeof(struct DiskInfo),
        0, 
        MAX_DISKUSAGE_LEN * sizeof(struct DiskInfo));

    /* Ӧdevice-mapper͵豸Ϊ0getDeviceMapperNumberȡ豸 */
    if (0 == g_deviceMapperNum)
    {
        nResult = getDeviceMapperNumber();
        if (ERROR == nResult)
        {
            freeSpace(devMajorMinor, linuxDiskUsage, diskMap);
            return ERROR;
        }
    }

    /*
     * getPartitionsInfoȡ̣ԼӦĴܿռСKB豸Ϣ
     * ȡӦ豸ռСfdiskӦϢ
     */
    nResult = getPartitionsInfo(handle, devMajorMinor, &numberCount.partNum, linuxDiskUsage, &numberCount.diskNum);
    if (ERROR == nResult || 0 == numberCount.partNum || 0 == numberCount.diskNum)
    {
        freeSpace(devMajorMinor, linuxDiskUsage, diskMap);
        return ERROR;
    }

    /* getSwapInfoȡǰswapϢ */
    nResult = getSwapInfo(diskMap, &numberCount.mountNum);
    if (ERROR == nResult)
    {
        freeSpace(devMajorMinor, linuxDiskUsage, diskMap);
        return ERROR;
    }
    nSwapNum = numberCount.mountNum;

    /* getDiskInfoȡǰصļϵͳص㣬豸ԼʹÿռϢ */
    nResult = getDiskInfo(devMajorMinor, numberCount.partNum, diskMap, &numberCount.mountNum);
    if (ERROR == nResult || nSwapNum >= numberCount.mountNum)
    {
        freeSpace(devMajorMinor, linuxDiskUsage, diskMap);
        return ERROR;
    }

    /* getAllDeviceUsageͨȡĹصļϵͳʹϢҶӦĸ豸Ӧ̵ʹϢ */
    nResult = getAllDeviceUsage(devMajorMinor, linuxDiskUsage, diskMap, numberCount);
    if (ERROR == nResult)
    {
        freeSpace(devMajorMinor, linuxDiskUsage, diskMap);
        return ERROR;
    }

    /* ѭȡṹݵÿԱ */
    for (i = 0; i < numberCount.diskNum; i++)
    {
        /* ȡϢתΪַҼܿռС */
        (void)strAdd(linuxDiskUsage[i].deviceTotalSpace, szTotalSize, szTotalSize);
        (void)strAdd(linuxDiskUsage[i].diskUsage, szTotalUsage, szTotalUsage);
        //ֻƴ12Ϣ(1+11)ֹ60̵ĳ³ִչϢضϵ
        if(i <= MAX_DISKUSAGE_STRING_NUM)
        {
            (void)snprintf_s(szUsageString + strlen(szUsageString), 
                            (MAX_DISKUSAGE_LEN - strlen(szUsageString)), 
                            (MAX_DISKUSAGE_LEN - strlen(szUsageString)), 
                            "%s:%s:%s;",
                            linuxDiskUsage[i].phyDevName, 
                            linuxDiskUsage[i].deviceTotalSpace, 
                            linuxDiskUsage[i].diskUsage);
        }
    }
    /* ܵĴ̿ռʹÿռԼյÿ̵ʹʶӦֵַ */
    (void)snprintf_s(pszDiskUsage, MAX_DISKUSAGE_LEN, MAX_DISKUSAGE_LEN, 
                    "0:%s:%s;%s", szTotalSize, szTotalUsage, szUsageString);

    freeSpace(devMajorMinor, linuxDiskUsage, diskMap);

    return SUCC;
}
/*****************************************************************************
 Function   : FilesystemUsage()
 Description: get Filesystemname list and its usage
 Input      : struct xs_handle* handle   handle of xenstore
 Output     : int 
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 Remark     : 2013-9-4 create this function for suse11sp1 Linux OS
 *****************************************************************************/
int FilesystemUsage(struct xs_handle *handle)
{ 
    FILE *file;
    char buf[1056] = {0};
    char filename[1024] = {0};
    char path[32] = {0};
    char value[MAX_FILENAMES_XENSTORLEN+1] = {0};
    char numbuf[32] = {0};
    int FileNameArrLen;
    int size,used;
    int num;
    int exceedflag;
    int i;
    /*ͻṩshellʽshellȡļϵͳƣܴСôС*/
    file = openPipe("df -lmP | grep -v Filesystem | grep -v Used | grep -v tmpfs | grep -v shm","r");
    if(NULL == file)
    {
       DEBUG_LOG("Failed to exec df -lmP shell command.");
       (void)write_to_xenstore(handle, FILE_DATA_PATH, "error");
       return ERROR;
    }
    (void)memset_s(FilenameArr,MAX_FILENAMES_SIZE,0,MAX_FILENAMES_SIZE);
    while(NULL != fgets(buf,sizeof(buf),file))
    {
       (void)sscanf_s(buf,"%s %d %d",filename,sizeof(filename),&size,&used);
       (void)snprintf_s(FilenameArr+strlen(FilenameArr),
                        sizeof(FilenameArr) - strlen(FilenameArr),
                        sizeof(FilenameArr) - strlen(FilenameArr),
                        "%s:%d:%d;",filename,size,used);
    }
    (void)pclose(file);
    FileNameArrLen = strlen(FilenameArr);
	num = FileNameArrLen / MAX_FILENAMES_XENSTORLEN;
	exceedflag = FileNameArrLen % MAX_FILENAMES_XENSTORLEN;
    (void)snprintf_s(value, MAX_FILENAMES_XENSTORLEN, MAX_FILENAMES_XENSTORLEN, "%s", FilenameArr);
    if(xb_write_first_flag == 0)
    {
       (void)write_to_xenstore(handle, FILE_DATA_PATH, value);
    }
    else
    {
        (void)write_weak_to_xenstore(handle, FILE_DATA_PATH, value);
    }
    /*ٽֵnum+1;:33/32=1;1ֽڣҪд*/
    if(exceedflag)
    {
       num += 1; 
    }
    /*xenstoreֵܳfilesystem_extra%dֵд*/
    for(i=1; i<num; i++)
    {
        (void)snprintf_s(path, sizeof(path), sizeof(path), FILE_DATA_EXTRA_PATH_PREFIX"%d", i); //filesystem_extra%d
        (void)snprintf_s(value, MAX_FILENAMES_XENSTORLEN, MAX_FILENAMES_XENSTORLEN,
                        "%s", FilenameArr+(MAX_FILENAMES_XENSTORLEN*i)); 
	if(xb_write_first_flag == 0)
	{
            (void)write_to_xenstore(handle, path, value);
	}
	else
	{
	    (void)write_weak_to_xenstore(handle, path, value);
	}
    }
    (void)snprintf_s(numbuf, sizeof(numbuf), sizeof(numbuf), "%d", num);
    if(xb_write_first_flag == 0)
    {
        (void)write_to_xenstore(handle, FILE_NUM_PATH, numbuf);
    }
    else
    {
        (void)write_weak_to_xenstore(handle, FILE_NUM_PATH, numbuf);
    }
    return SUCC;
}
/*****************************************************************************
 Function   : diskworkctlmon()
 Description: getdiskusage󣬽Ϣдxenstore
 Input      : struct xs_handle* handle   handle of xenstore
 Output     : N/A
 Return     : SUCC = success, ERROR = failure
 Other      : N/A
 *****************************************************************************/
int diskworkctlmon(struct xs_handle *handle)
{
    char szDiskUsage[MAX_DISKUSAGE_LEN] = {0};
    int nRet;

    if (NULL == handle)
    {
        return ERROR;
    }

    /* úشַ */
    nRet = getDiskUsage(handle, szDiskUsage);
    if ( ERROR == nRet)
    {
        /*ʧдerror*/
        if(xb_write_first_flag == 0)
        {
            write_to_xenstore(handle, DISK_DATA_PATH, "error");
        }
        else
        {
            write_weak_to_xenstore(handle, DISK_DATA_PATH, "error");
        }
        return ERROR;
    }
    else
    {
        if(xb_write_first_flag == 0)
        {
            /*سɹдϢ*/
            write_to_xenstore(handle, DISK_DATA_PATH, szDiskUsage);
        }
        else
        {
            write_weak_to_xenstore(handle, DISK_DATA_PATH, szDiskUsage);
        }
    }
    if(g_exinfo_flag_value & EXINFO_FLAG_FILESYSTEM)
    {
        (void)FilesystemUsage(handle);
    }
    return SUCC;
}
