#define _XOPEN_SOURCE 600
#define _BSD_SOURCE
#define _LARGEFILE64_SOURCE 1
#include <unistd.h>
#include <sys/syscall.h>
#include <endian.h>
#include <errno.h>

#include "fallocate_internal.h"
#undef fallocate

#ifdef SYS_fallocate
/* Linux has a system call fallocate() since 2.6.23, but glibc
 * only provides the wrapper with glibc-2.10+
 * So add a (weak) fallocate symbol here.
 */
int fallocate64(int fd, int mode, __off64_t start, __off64_t len) __attribute__((weak));
int fallocate64(int fd, int mode, __off64_t start, __off64_t len)
{
#if __WORDSIZE == 64
	/* Two extra 0ULL for strace */
	return syscall(SYS_fallocate, fd, mode,
			start, len /*, 0ULL, 0ULL*/);	
#else
#if __BYTE_ORDER == __LITTLE_ENDIAN
	return syscall(SYS_fallocate, fd, mode,
			(int)start, (int)(start>>32),
			(int)len, (int)(len>>32));
#else
	return syscall(SYS_fallocate, fd, mode,
			(int)(start>>32), (int)start,
			(int)(len>>32), (int)len);
#endif
#endif
}

#else /* SYS_fallocate */
int fallocate64(int fd, int mode, __off64_t start, __off64_t len) __attribute__((weak));
int fallocate64(int fd, int mode, __off64_t start, __off64_t len)
{
	errno = ENOSYS;
	return -1;
}
#endif

#ifndef HAVE_FALLOCATE
#if __WORDSIZE == 64
int fallocate(int, int, off_t, off_t) __attribute__ ((weak, alias("fallocate64")));
#else
int fallocate(int fd, int mode, off_t start, off_t len) __attribute__((weak));
int fallocate(int fd, int mode, off_t start, off_t len)
{
	return fallocate64(fd, mode, start, len);
}
#endif

#endif /* ! HAVE_FALLOCATE */

